/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.util.CharsetUtil;

public class Multipart
implements Body {
    private String preamble = "";
    private String epilogue = "";
    private List bodyParts = new LinkedList();
    private Entity parent = null;
    private String subType = "alternative";

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
        Iterator it = this.bodyParts.iterator();
        while (it.hasNext()) {
            ((BodyPart)it.next()).setParent(parent);
        }
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue;
    }

    public List getBodyParts() {
        return Collections.unmodifiableList(this.bodyParts);
    }

    public void setBodyParts(List bodyParts) {
        this.bodyParts = bodyParts;
        Iterator it = bodyParts.iterator();
        while (it.hasNext()) {
            ((BodyPart)it.next()).setParent(this.parent);
        }
    }

    public void addBodyPart(BodyPart bodyPart) {
        this.bodyParts.add(bodyPart);
        bodyPart.setParent(this.parent);
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public void writeTo(OutputStream out) throws IOException {
        String boundary = this.getBoundary();
        List bodyParts = this.getBodyParts();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, CharsetUtil.getCharset(this.getCharset())), 8192);
        writer.write(this.getPreamble() + "\r\n");
        for (int i = 0; i < bodyParts.size(); ++i) {
            writer.write(boundary + "\r\n");
            ((BodyPart)bodyParts.get(i)).writeTo(out);
        }
        writer.write(this.getEpilogue() + "\r\n");
        writer.write(boundary + "--" + "\r\n");
    }

    private String getBoundary() {
        Entity e = this.getParent();
        ContentTypeField cField = (ContentTypeField)e.getHeader().getField("Content-Type");
        return cField.getBoundary();
    }

    private String getCharset() {
        Entity e = this.getParent();
        String charString = ((ContentTypeField)e.getHeader().getField("Content-Type")).getCharset();
        return charString;
    }
}

