/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.mboxiterator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class CharBufferWrapper {
    private final CharBuffer messageBuffer;

    public CharBufferWrapper(CharBuffer messageBuffer) {
        if (messageBuffer == null) {
            throw new IllegalStateException("The buffer is null");
        }
        this.messageBuffer = messageBuffer;
    }

    public InputStream asInputStream(Charset encoding) {
        return new ByteBufferInputStream(encoding.encode(this.messageBuffer));
    }

    public char[] asCharArray() {
        return this.messageBuffer.array();
    }

    public String toString() {
        return this.messageBuffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharBufferWrapper)) {
            return false;
        }
        CharBufferWrapper that = (CharBufferWrapper)o;
        return this.messageBuffer.equals(that.messageBuffer);
    }

    public int hashCode() {
        return this.messageBuffer.hashCode();
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buf;

        private ByteBufferInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            this.buf.get(bytes, off, Math.min(len, this.buf.remaining()));
            return len;
        }
    }
}

