/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.samples.mbox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.mboxiterator.CharBufferWrapper;
import org.apache.james.mime4j.mboxiterator.MboxIterator;
import org.apache.james.mime4j.message.DefaultMessageBuilder;

public class IterateOverMbox {
    private static final CharsetEncoder ENCODER = Charset.forName("UTF-8").newEncoder();

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Please supply a path to an mbox file to parse");
        }
        File mbox = new File(args[0]);
        long start = System.currentTimeMillis();
        int count = 0;
        for (CharBufferWrapper message : MboxIterator.fromFile((File)mbox).charset(ENCODER.charset()).build()) {
            System.out.println(IterateOverMbox.messageSummary(message.asInputStream(ENCODER.charset())));
            ++count;
        }
        System.out.println("Found " + count + " messages");
        long end = System.currentTimeMillis();
        System.out.println("Done in: " + (end - start) + " milis");
    }

    private static void saveMessageToFile(int count, CharBuffer buf) throws IOException {
        FileOutputStream fout = new FileOutputStream(new File("target/messages/msg-" + count));
        FileChannel fileChannel = fout.getChannel();
        ByteBuffer buf2 = ENCODER.encode(buf);
        fileChannel.write(buf2);
        fileChannel.close();
        fout.close();
    }

    private static String messageSummary(InputStream messageBytes) throws IOException, MimeException {
        DefaultMessageBuilder builder = new DefaultMessageBuilder();
        Message message = builder.parseMessage(messageBytes);
        return String.format("\nMessage %s \nSent by:\t%s\nTo:\t%s\n", message.getSubject(), message.getSender(), message.getTo());
    }
}

