/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.samples.dom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.field.address.AddressBuilder;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.storage.StorageProvider;

public class MultipartMessage {
    public static void main(String[] args) throws Exception {
        MessageImpl message = new MessageImpl();
        message.setDate(new Date());
        message.setFrom(AddressBuilder.DEFAULT.parseMailbox("John Doe <jdoe@machine.example>"));
        message.createMessageId("machine.example");
        message.setTo((Address)AddressBuilder.DEFAULT.parseMailbox("Mary Smith <mary@example.net>"));
        message.setSubject("An image for you");
        MultipartImpl multipart = new MultipartImpl("mixed");
        multipart.setPreamble("This is a multi-part message in MIME format.");
        StorageBodyFactory bodyFactory = new StorageBodyFactory();
        BodyPart textPart = MultipartMessage.createTextPart(bodyFactory, "Why so serious?");
        multipart.addBodyPart((Entity)textPart);
        BufferedImage image = MultipartMessage.renderSampleImage();
        BodyPart imagePart = MultipartMessage.createImagePart(bodyFactory, image);
        multipart.addBodyPart((Entity)imagePart);
        message.setMultipart((Multipart)multipart);
        DefaultMessageWriter writer = new DefaultMessageWriter();
        writer.writeMessage((Message)message, (OutputStream)System.out);
        message.dispose();
    }

    private static BodyPart createTextPart(StorageBodyFactory bodyFactory, String text) {
        TextBody body = bodyFactory.textBody(text, "UTF-8");
        BodyPart bodyPart = new BodyPart();
        bodyPart.setText(body);
        bodyPart.setContentTransferEncoding("quoted-printable");
        return bodyPart;
    }

    private static BodyPart createImagePart(StorageBodyFactory bodyFactory, BufferedImage image) throws IOException {
        StorageProvider storageProvider = bodyFactory.getStorageProvider();
        Storage storage = MultipartMessage.storeImage(storageProvider, image, "png");
        BinaryBody body = bodyFactory.binaryBody(storage);
        BodyPart bodyPart = new BodyPart();
        bodyPart.setBody((Body)body, "image/png");
        bodyPart.setContentTransferEncoding("base64");
        bodyPart.setFilename("smiley.png");
        return bodyPart;
    }

    private static Storage storeImage(StorageProvider storageProvider, BufferedImage image, String formatName) throws IOException {
        StorageOutputStream out = storageProvider.createStorageOutputStream();
        ImageIO.write((RenderedImage)image, formatName, (OutputStream)out);
        return out.toStorage();
    }

    private static BufferedImage renderSampleImage() {
        System.setProperty("java.awt.headless", "true");
        int size = 100;
        BufferedImage img = new BufferedImage(100, 100, 10);
        Graphics2D gfx = img.createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setStroke(new BasicStroke(2.5f, 1, 1));
        gfx.setColor(Color.BLACK);
        gfx.setBackground(Color.WHITE);
        gfx.clearRect(0, 0, 100, 100);
        int b = 3;
        gfx.drawOval(b, b, 99 - 2 * b, 99 - 2 * b);
        int esz = 14;
        int ex = 27;
        gfx.drawOval(ex, ex, esz, esz);
        gfx.drawOval(99 - esz - ex, ex, esz, esz);
        b = 20;
        gfx.drawArc(b, b, 99 - 2 * b, 99 - 2 * b, 200, 140);
        return img;
    }
}

