/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.field.address.DefaultAddressParser;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.AbstractEntityBuilder;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.message.ParserStreamContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.NameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBuilder
extends AbstractEntityBuilder {
    private MimeConfig config;
    private DecodeMonitor monitor;
    private BodyDescriptorBuilder bodyDescBuilder;
    private FieldParser<?> fieldParser;
    private BodyFactory bodyFactory;
    private boolean flatMode;
    private boolean rawContent;

    public static MessageBuilder create() {
        return new MessageBuilder();
    }

    public static MessageBuilder createCopy(Message other) {
        return new MessageBuilder().copy(other);
    }

    public static MessageBuilder read(InputStream is) throws IOException {
        return new MessageBuilder().parse(is);
    }

    public MessageBuilder use(MimeConfig config) {
        this.config = config;
        return this;
    }

    public MessageBuilder use(DecodeMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public MessageBuilder use(BodyDescriptorBuilder bodyDescBuilder) {
        this.bodyDescBuilder = bodyDescBuilder;
        return this;
    }

    public MessageBuilder use(FieldParser<?> fieldParser) {
        this.fieldParser = fieldParser;
        return this;
    }

    public MessageBuilder use(BodyFactory bodyFactory) {
        this.bodyFactory = bodyFactory;
        return this;
    }

    public MessageBuilder enableFlatMode() {
        this.flatMode = true;
        return this;
    }

    public MessageBuilder disableFlatMode() {
        this.flatMode = false;
        return this;
    }

    public MessageBuilder enableContentDecoding() {
        this.rawContent = false;
        return this;
    }

    public MessageBuilder disableContentDecoding() {
        this.rawContent = true;
        return this;
    }

    @Override
    public MessageBuilder setField(Field field) {
        super.setField(field);
        return this;
    }

    @Override
    public MessageBuilder addField(Field field) {
        super.addField(field);
        return this;
    }

    @Override
    public MessageBuilder removeFields(String name) {
        super.removeFields(name);
        return this;
    }

    @Override
    public MessageBuilder clearFields() {
        super.clearFields();
        return this;
    }

    @Override
    public MessageBuilder setContentTransferEncoding(String contentTransferEncoding) {
        super.setContentTransferEncoding(contentTransferEncoding);
        return this;
    }

    @Override
    public MessageBuilder setContentType(String mimeType, NameValuePair ... parameters) {
        super.setContentType(mimeType, parameters);
        return this;
    }

    @Override
    public MessageBuilder setContentDisposition(String dispositionType) {
        super.setContentDisposition(dispositionType);
        return this;
    }

    @Override
    public MessageBuilder setContentDisposition(String dispositionType, String filename) {
        super.setContentDisposition(dispositionType, filename);
        return this;
    }

    @Override
    public MessageBuilder setContentDisposition(String dispositionType, String filename, long size) {
        super.setContentDisposition(dispositionType, filename, size);
        return this;
    }

    @Override
    public MessageBuilder setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        super.setContentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate);
        return this;
    }

    @Override
    public MessageBuilder setBody(Body body) {
        super.setBody(body);
        return this;
    }

    @Override
    public MessageBuilder setBody(TextBody textBody) {
        super.setBody(textBody);
        return this;
    }

    @Override
    public MessageBuilder setBody(BinaryBody binaryBody) {
        super.setBody(binaryBody);
        return this;
    }

    @Override
    public MessageBuilder setBody(Multipart multipart) {
        super.setBody(multipart);
        return this;
    }

    @Override
    public MessageBuilder setBody(Message message) {
        super.setBody(message);
        return this;
    }

    public MessageBuilder setBody(String text, Charset charset) throws IOException {
        return this.setBody(text, null, charset);
    }

    public MessageBuilder setBody(String text, String subtype, Charset charset) throws IOException {
        String mimeType = "text/" + (subtype != null ? subtype : "plain");
        if (charset != null) {
            this.setField(Fields.contentType(mimeType, new NameValuePair("charset", charset.name())));
        } else {
            this.setField(Fields.contentType(mimeType));
        }
        TextBody textBody = this.bodyFactory != null ? this.bodyFactory.textBody(InputStreams.create((CharSequence)text, (Charset)charset), charset != null ? charset.name() : null) : BasicBodyFactory.INSTANCE.textBody(text, charset);
        return this.setBody((Body)textBody);
    }

    public MessageBuilder setBody(byte[] bin, String mimeType) throws IOException {
        this.setField(Fields.contentType(mimeType != null ? mimeType : "application/octet-stream"));
        BinaryBody binBody = this.bodyFactory != null ? this.bodyFactory.binaryBody(InputStreams.create((byte[])bin)) : BasicBodyFactory.INSTANCE.binaryBody(bin);
        return this.setBody((Body)binBody);
    }

    public String getMessageId() {
        Object field = this.obtainField("Message-ID");
        return field != null ? field.getBody() : null;
    }

    public MessageBuilder generateMessageId(String hostname) {
        if (hostname == null) {
            this.removeFields("Message-ID");
        } else {
            this.setField(Fields.generateMessageId(hostname));
        }
        return this;
    }

    public MessageBuilder setMessageId(String messageId) {
        if (messageId == null) {
            this.removeFields("Message-ID");
        } else {
            this.setField(Fields.messageId(messageId));
        }
        return this;
    }

    public String getSubject() {
        UnstructuredField field = (UnstructuredField)this.obtainField("Subject");
        return field != null ? field.getValue() : null;
    }

    public MessageBuilder setSubject(String subject) {
        if (subject == null) {
            this.removeFields("Subject");
        } else {
            this.setField(Fields.subject(subject));
        }
        return this;
    }

    public Date getDate() {
        DateTimeField field = (DateTimeField)this.obtainField("Date");
        return field != null ? field.getDate() : null;
    }

    public MessageBuilder setDate(Date date) {
        return this.setDate(date, null);
    }

    public MessageBuilder setDate(Date date, TimeZone zone) {
        if (date == null) {
            this.removeFields("Date");
        } else {
            this.setField(Fields.date("Date", date, zone));
        }
        return this;
    }

    public Mailbox getSender() {
        return this.getMailbox("Sender");
    }

    public MessageBuilder setSender(Mailbox sender) {
        return this.setMailbox("Sender", sender);
    }

    public MessageBuilder setSender(String sender) throws ParseException {
        return this.setMailbox("Sender", sender);
    }

    public MailboxList getFrom() {
        return this.getMailboxList("From");
    }

    public MessageBuilder setFrom(Mailbox from) {
        return this.setMailboxList("From", from);
    }

    public MessageBuilder setFrom(String from) throws ParseException {
        return this.setMailboxList("From", from);
    }

    public MessageBuilder setFrom(Mailbox ... from) {
        return this.setMailboxList("From", from);
    }

    public MessageBuilder setFrom(String ... from) throws ParseException {
        return this.setMailboxList("From", from);
    }

    public MessageBuilder setFrom(Collection<Mailbox> from) {
        return this.setMailboxList("From", from);
    }

    public AddressList getTo() {
        return this.getAddressList("To");
    }

    public MessageBuilder setTo(Address to) {
        return this.setAddressList("To", to);
    }

    public MessageBuilder setTo(String to) throws ParseException {
        return this.setAddressList("To", to);
    }

    public MessageBuilder setTo(Address ... to) {
        return this.setAddressList("To", to);
    }

    public MessageBuilder setTo(String ... to) throws ParseException {
        return this.setAddressList("To", to);
    }

    public MessageBuilder setTo(Collection<? extends Address> to) {
        return this.setAddressList("To", to);
    }

    public AddressList getCc() {
        return this.getAddressList("Cc");
    }

    public MessageBuilder setCc(Address cc) {
        return this.setAddressList("Cc", cc);
    }

    public MessageBuilder setCc(Address ... cc) {
        return this.setAddressList("Cc", cc);
    }

    public MessageBuilder setCc(Collection<? extends Address> cc) {
        return this.setAddressList("Cc", cc);
    }

    public AddressList getBcc() {
        return this.getAddressList("Bcc");
    }

    public MessageBuilder setBcc(Address bcc) {
        return this.setAddressList("Bcc", bcc);
    }

    public MessageBuilder setBcc(Address ... bcc) {
        return this.setAddressList("Bcc", bcc);
    }

    public MessageBuilder setBcc(Collection<? extends Address> bcc) {
        return this.setAddressList("Bcc", bcc);
    }

    public AddressList getReplyTo() {
        return this.getAddressList("Reply-To");
    }

    public MessageBuilder setReplyTo(Address replyTo) {
        return this.setAddressList("Reply-To", replyTo);
    }

    public MessageBuilder setReplyTo(Address ... replyTo) {
        return this.setAddressList("Reply-To", replyTo);
    }

    public MessageBuilder setReplyTo(Collection<? extends Address> replyTo) {
        return this.setAddressList("Reply-To", replyTo);
    }

    private Mailbox getMailbox(String fieldName) {
        MailboxField field = (MailboxField)this.obtainField(fieldName);
        return field != null ? field.getMailbox() : null;
    }

    private MessageBuilder setMailbox(String fieldName, Mailbox mailbox) {
        if (mailbox == null) {
            this.removeFields(fieldName);
        } else {
            this.setField(Fields.mailbox(fieldName, mailbox));
        }
        return this;
    }

    private MessageBuilder setMailbox(String fieldName, String mailbox) throws ParseException {
        if (mailbox == null) {
            this.removeFields(fieldName);
        } else {
            this.setField(Fields.mailbox(fieldName, DefaultAddressParser.DEFAULT.parseMailbox(mailbox)));
        }
        return this;
    }

    private MailboxList getMailboxList(String fieldName) {
        MailboxListField field = (MailboxListField)this.obtainField(fieldName);
        return field != null ? field.getMailboxList() : null;
    }

    private MessageBuilder setMailboxList(String fieldName, Mailbox mailbox) {
        return this.setMailboxList(fieldName, mailbox == null ? null : Collections.singleton(mailbox));
    }

    private MessageBuilder setMailboxList(String fieldName, String mailbox) throws ParseException {
        return this.setMailboxList(fieldName, mailbox == null ? null : DefaultAddressParser.DEFAULT.parseMailbox(mailbox));
    }

    private MessageBuilder setMailboxList(String fieldName, Mailbox ... mailboxes) {
        return this.setMailboxList(fieldName, mailboxes == null ? null : Arrays.asList(mailboxes));
    }

    private List<Mailbox> parseMailboxes(String ... mailboxes) throws ParseException {
        if (mailboxes == null || mailboxes.length == 0) {
            return null;
        }
        ArrayList<Mailbox> list = new ArrayList<Mailbox>();
        for (String mailbox : mailboxes) {
            list.add(DefaultAddressParser.DEFAULT.parseMailbox(mailbox));
        }
        return list;
    }

    private MessageBuilder setMailboxList(String fieldName, String ... mailboxes) throws ParseException {
        return this.setMailboxList(fieldName, this.parseMailboxes(mailboxes));
    }

    private MessageBuilder setMailboxList(String fieldName, Collection<Mailbox> mailboxes) {
        if (mailboxes == null || mailboxes.isEmpty()) {
            this.removeFields(fieldName);
        } else {
            this.setField(Fields.mailboxList(fieldName, mailboxes));
        }
        return this;
    }

    private AddressList getAddressList(String fieldName) {
        AddressListField field = (AddressListField)this.obtainField(fieldName);
        return field != null ? field.getAddressList() : null;
    }

    private MessageBuilder setAddressList(String fieldName, Address address) {
        return this.setAddressList(fieldName, address == null ? null : Collections.singleton(address));
    }

    private MessageBuilder setAddressList(String fieldName, String address) throws ParseException {
        return this.setAddressList(fieldName, (Address)(address == null ? null : DefaultAddressParser.DEFAULT.parseMailbox(address)));
    }

    private MessageBuilder setAddressList(String fieldName, Address ... addresses) {
        return this.setAddressList(fieldName, addresses == null ? null : Arrays.asList(addresses));
    }

    private List<Address> parseAddresses(String ... addresses) throws ParseException {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        ArrayList<Address> list = new ArrayList<Address>();
        for (String address : addresses) {
            list.add(DefaultAddressParser.DEFAULT.parseAddress(address));
        }
        return list;
    }

    private MessageBuilder setAddressList(String fieldName, String ... addresses) throws ParseException {
        return this.setAddressList(fieldName, this.parseAddresses(addresses));
    }

    private MessageBuilder setAddressList(String fieldName, Collection<? extends Address> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            this.removeFields(fieldName);
        } else {
            this.setField(Fields.addressList(fieldName, addresses));
        }
        return this;
    }

    public MessageBuilder copy(Message other) {
        if (other == null) {
            return this;
        }
        this.clearFields();
        Header otherHeader = other.getHeader();
        if (otherHeader != null) {
            List<Field> otherFields = otherHeader.getFields();
            for (Field field : otherFields) {
                this.addField(field);
            }
        }
        Body body = null;
        Body otherBody = other.getBody();
        if (otherBody instanceof Message) {
            body = MessageBuilder.createCopy((Message)otherBody).build();
        } else if (otherBody instanceof Multipart) {
            body = MultipartBuilder.createCopy((Multipart)otherBody).build();
        } else if (otherBody instanceof SingleBody) {
            body = ((SingleBody)otherBody).copy();
        }
        this.setBody(body);
        return this;
    }

    public MessageBuilder parse(InputStream is) throws IOException {
        BodyDescriptorBuilder currentBodyDescBuilder;
        DecodeMonitor currentMonitor;
        MimeConfig currentConfig = this.config != null ? this.config : MimeConfig.DEFAULT;
        boolean strict = currentConfig.isStrictParsing();
        DecodeMonitor decodeMonitor = this.monitor != null ? this.monitor : (currentMonitor = strict ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
        BodyDescriptorBuilder bodyDescriptorBuilder = this.bodyDescBuilder != null ? this.bodyDescBuilder : (currentBodyDescBuilder = new DefaultBodyDescriptorBuilder(null, this.fieldParser != null ? this.fieldParser : (strict ? DefaultFieldParser.getParser() : LenientFieldParser.getParser()), currentMonitor));
        BodyFactory currentBodyFactory = this.bodyFactory != null ? this.bodyFactory : new BasicBodyFactory(!strict);
        MimeStreamParser parser = new MimeStreamParser(currentConfig, currentMonitor, currentBodyDescBuilder);
        MessageImpl message = new MessageImpl();
        parser.setContentHandler((ContentHandler)new ParserStreamContentHandler(message, currentBodyFactory));
        parser.setContentDecoding(!this.rawContent);
        if (this.flatMode) {
            parser.setFlat();
        }
        try {
            parser.parse(is);
        }
        catch (MimeException e) {
            throw new MimeIOException(e);
        }
        this.clearFields();
        List<Field> fields = message.getHeader().getFields();
        for (Field field : fields) {
            this.addField(field);
        }
        this.setBody(message.getBody());
        return this;
    }

    public Message build() {
        MessageImpl message = new MessageImpl();
        HeaderImpl header = new HeaderImpl();
        message.setHeader(header);
        if (!this.containsField("MIME-Version")) {
            header.setField(Fields.version("1.0"));
        }
        for (Field field : this.getFields()) {
            header.addField(field);
        }
        if (!this.containsField("Date")) {
            header.setField(Fields.date(new Date()));
        }
        message.setBody(this.getBody());
        return message;
    }
}

