/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.SimpleContentHandler;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.MemoryStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.util.ContentUtil;

public class LongMultipartReadBench {
    public static void main(String[] args) throws Exception {
        byte[] content = LongMultipartReadBench.loadMessage("long-multipart.msg");
        if (content == null) {
            System.err.println("Test message not found");
            return;
        }
        int testNumber = args.length > 0 ? Integer.parseInt(args[0]) : 0;
        Test test = LongMultipartReadBench.createTest(testNumber);
        if (test == null) {
            System.err.println("No such test: " + testNumber);
            return;
        }
        int repetitions = args.length > 1 ? Integer.parseInt(args[1]) : 25000;
        System.out.println("Multipart message read.");
        System.out.println("No of repetitions: " + repetitions);
        System.out.println("Content length: " + content.length);
        System.out.println("Test: " + test.getClass().getSimpleName());
        System.out.print("Warmup... ");
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < 1500L) {
            test.run(content, 10);
        }
        System.out.println("done");
        System.out.println("--------------------------------");
        long start = System.currentTimeMillis();
        test.run(content, repetitions);
        long finish = System.currentTimeMillis();
        double seconds = (double)(finish - start) / 1000.0;
        double mb = (double)(content.length * repetitions) / 1024.0 / 1024.0;
        System.out.printf("Execution time: %f sec\n", seconds);
        System.out.printf("%.2f messages/sec\n", (double)repetitions / seconds);
        System.out.printf("%.2f mb/sec\n", mb / seconds);
    }

    private static Test createTest(int testNumber) {
        switch (testNumber) {
            case 0: {
                return new MimeTokenStreamTest();
            }
            case 1: {
                return new AbstractContentHandlerTest();
            }
            case 2: {
                return new SimpleContentHandlerTest();
            }
            case 3: {
                return new MessageTest();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadMessage(String resourceName) throws IOException {
        ClassLoader cl = LongMultipartReadBench.class.getClassLoader();
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        InputStream instream = cl.getResourceAsStream(resourceName);
        if (instream == null) {
            return null;
        }
        try {
            ContentUtil.copy((InputStream)instream, (OutputStream)outstream);
        }
        finally {
            instream.close();
        }
        return outstream.toByteArray();
    }

    private static final class MessageTest
    implements Test {
        private MessageTest() {
        }

        @Override
        public void run(byte[] content, int repetitions) throws Exception {
            DefaultStorageProvider.setInstance((StorageProvider)new MemoryStorageProvider());
            DefaultMessageBuilder builder = new DefaultMessageBuilder();
            for (int i = 0; i < repetitions; ++i) {
                builder.parseMessage((InputStream)new ByteArrayInputStream(content));
            }
        }
    }

    private static final class SimpleContentHandlerTest
    implements Test {
        private SimpleContentHandlerTest() {
        }

        @Override
        public void run(byte[] content, int repetitions) throws Exception {
            SimpleContentHandler contentHandler = new SimpleContentHandler(){

                public void body(BodyDescriptor bd, InputStream is) throws IOException {
                    byte[] b = new byte[4096];
                    while (is.read(b) != -1) {
                    }
                }

                public void headers(Header header) {
                }
            };
            for (int i = 0; i < repetitions; ++i) {
                MimeStreamParser parser = new MimeStreamParser();
                parser.setContentDecoding(true);
                parser.setContentHandler((ContentHandler)contentHandler);
                parser.parse((InputStream)new ByteArrayInputStream(content));
            }
        }
    }

    private static final class AbstractContentHandlerTest
    implements Test {
        private AbstractContentHandlerTest() {
        }

        @Override
        public void run(byte[] content, int repetitions) throws Exception {
            AbstractContentHandler contentHandler = new AbstractContentHandler(){};
            for (int i = 0; i < repetitions; ++i) {
                MimeStreamParser parser = new MimeStreamParser();
                parser.setContentHandler((ContentHandler)contentHandler);
                parser.parse((InputStream)new ByteArrayInputStream(content));
            }
        }
    }

    private static final class MimeTokenStreamTest
    implements Test {
        private MimeTokenStreamTest() {
        }

        @Override
        public void run(byte[] content, int repetitions) throws Exception {
            MimeTokenStream stream = new MimeTokenStream();
            for (int i = 0; i < repetitions; ++i) {
                stream.parse((InputStream)new ByteArrayInputStream(content));
                EntityState state = stream.getState();
                while (state != EntityState.T_END_OF_STREAM) {
                    state = stream.next();
                }
            }
        }
    }

    private static interface Test {
        public void run(byte[] var1, int var2) throws Exception;
    }
}

