/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class RemoveMimeHeaderByPrefix
extends GenericMailet {
    public static final String PREFIX = "prefix";
    private String prefix;

    public void init() throws MessagingException {
        this.prefix = this.getInitParameter(PREFIX);
        if (Strings.isNullOrEmpty((String)this.prefix)) {
            throw new MessagingException("Expecting prefix not to be empty or null with RemoveMimeHeaderByPrefix");
        }
    }

    public String getMailetInfo() {
        return "RemoveMimeHeaderByPrefix Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        List<String> headerNamesToRemove = this.headerNamesStartingByPrefix(mail);
        for (String headerName : headerNamesToRemove) {
            mail.getMessage().removeHeader(headerName);
        }
        if (!headerNamesToRemove.isEmpty()) {
            mail.getMessage().saveChanges();
        }
        this.removeSpecific(mail);
    }

    protected void removeSpecific(Mail mail) {
        mail.getPerRecipientSpecificHeaders().getRecipientsWithSpecificHeaders().stream().collect(Collectors.toList()).forEach(recipient -> mail.getPerRecipientSpecificHeaders().getHeadersForRecipient(recipient).removeIf(next -> next.getName().startsWith(this.prefix)));
    }

    private List<String> headerNamesStartingByPrefix(Mail mail) throws MessagingException {
        ImmutableList.Builder headerToRemove = ImmutableList.builder();
        List<Header> headers = new MimeMessageUtils(mail.getMessage()).toHeaderList();
        for (Header header : headers) {
            if (!header.getName().startsWith(this.prefix)) continue;
            headerToRemove.add((Object)header.getName());
        }
        return headerToRemove.build();
    }
}

