/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.model.MessageIdDto;
import org.apache.mailet.ArbitrarySerializable;
import org.apache.mailet.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeValue<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeValue.class);
    private final T value;
    private final Serializer<T> serializer;

    public static AttributeValue<Boolean> of(Boolean value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Boolean>(value, Serializer.BOOLEAN_SERIALIZER);
    }

    public static AttributeValue<String> of(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<String>(value, Serializer.STRING_SERIALIZER);
    }

    public static AttributeValue<Integer> of(Integer value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Integer>(value, Serializer.INT_SERIALIZER);
    }

    public static AttributeValue<Long> of(Long value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Long>(value, Serializer.LONG_SERIALIZER);
    }

    public static AttributeValue<Float> of(Float value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Float>(value, Serializer.FLOAT_SERIALIZER);
    }

    public static AttributeValue<Double> of(Double value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Double>(value, Serializer.DOUBLE_SERIALIZER);
    }

    public static AttributeValue<MessageIdDto> of(MessageIdDto value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<MessageIdDto>(value, Serializer.MESSAGE_ID_DTO_SERIALIZER);
    }

    public static <T extends ArbitrarySerializable<T>> AttributeValue<T> of(T value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        return new AttributeValue<T>(value, new Serializer.ArbitrarySerializableSerializer());
    }

    public static AttributeValue<URL> of(URL value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<URL>(value, Serializer.URL_SERIALIZER);
    }

    public static <T> AttributeValue<Optional<AttributeValue<T>>> of(Optional<AttributeValue<T>> value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        return new AttributeValue<Optional<AttributeValue<T>>>(value, new Serializer.OptionalSerializer());
    }

    public static AttributeValue<Collection<AttributeValue<?>>> of(Collection<AttributeValue<?>> value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        return new AttributeValue(value, new Serializer.CollectionSerializer());
    }

    public static AttributeValue<Map<String, AttributeValue<?>>> of(Map<String, AttributeValue<?>> value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        return new AttributeValue(value, new Serializer.MapSerializer());
    }

    public static AttributeValue<Serializable> ofSerializable(Serializable value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Serializable>(value, new Serializer.FSTSerializer());
    }

    public static AttributeValue<?> ofAny(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        if (value instanceof Boolean) {
            return AttributeValue.of((Boolean)value);
        }
        if (value instanceof String) {
            return AttributeValue.of((String)value);
        }
        if (value instanceof Integer) {
            return AttributeValue.of((Integer)value);
        }
        if (value instanceof Long) {
            return AttributeValue.of((Long)value);
        }
        if (value instanceof Float) {
            return AttributeValue.of((Float)value);
        }
        if (value instanceof Double) {
            return AttributeValue.of((Double)value);
        }
        if (value instanceof Collection) {
            return AttributeValue.of((Collection)value);
        }
        if (value instanceof Map) {
            return AttributeValue.of((Map)value);
        }
        if (value instanceof MessageIdDto) {
            return AttributeValue.of((MessageIdDto)value);
        }
        if (value instanceof ArbitrarySerializable) {
            return AttributeValue.of((ArbitrarySerializable)value);
        }
        if (value instanceof URL) {
            return AttributeValue.of((URL)value);
        }
        if (value instanceof Optional) {
            return AttributeValue.of((Optional)value);
        }
        if (value instanceof Serializable) {
            return AttributeValue.ofSerializable((Serializable)value);
        }
        throw new IllegalArgumentException(value.getClass().toString() + " should at least be Serializable");
    }

    public static AttributeValue<?> fromJsonString(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode tree = objectMapper.readTree(json);
        return AttributeValue.fromJson(tree);
    }

    public static Optional<AttributeValue<?>> optionalFromJsonString(String json) {
        try {
            return Optional.of(AttributeValue.fromJsonString(json));
        }
        catch (IOException e) {
            LOGGER.error("Error while deserializing '" + json + "'", (Throwable)e);
            return Optional.empty();
        }
    }

    public static AttributeValue<?> fromJson(JsonNode input) {
        return Optional.ofNullable(input).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).flatMap(AttributeValue::deserialize).map(AttributeValue::ofAny).orElseThrow(() -> new IllegalStateException("unable to deserialize " + input.toString()));
    }

    public static Optional<?> deserialize(ObjectNode fields) {
        Preconditions.checkNotNull((Object)fields);
        Optional<JsonNode> maybeSerializer = Optional.ofNullable(fields.get("serializer"));
        Optional<JsonNode> maybeValue = Optional.ofNullable(fields.get("value"));
        return maybeSerializer.flatMap(serializer -> maybeValue.flatMap(value -> AttributeValue.findSerializerAndDeserialize(serializer, value)));
    }

    public static Optional<?> findSerializerAndDeserialize(JsonNode serializer, JsonNode value) {
        return Serializer.Registry.find(serializer.asText()).flatMap(s -> s.deserialize(value));
    }

    private AttributeValue(T value, Serializer<T> serializer) {
        this.value = value;
        this.serializer = serializer;
    }

    public T value() {
        return this.value;
    }

    public <U> Optional<U> valueAs(Class<U> type) {
        return AttributeValue.tryToCast(type, this.value);
    }

    private static <U> Optional<U> tryToCast(Class<U> type, Object value) {
        if (type.isInstance(value)) {
            return Optional.of(type.cast(value));
        }
        return Optional.empty();
    }

    public AttributeValue<T> duplicate() {
        return AttributeValue.fromJson(this.toJson());
    }

    public JsonNode toJson() {
        ObjectNode serialized = JsonNodeFactory.instance.objectNode();
        serialized.put("serializer", this.serializer.getName());
        serialized.replace("value", this.serializer.serialize(this.value));
        return serialized;
    }

    public T getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof AttributeValue) {
            AttributeValue that = (AttributeValue)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.serializer, that.serializer);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.serializer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("serializer", (Object)this.serializer.getName()).toString();
    }
}

