/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import java.util.Optional;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.Mail;

public class AttributeUtils {
    public static <T> Optional<T> getValueAndCastFromMail(Mail mail, AttributeName name, Class<T> type) {
        return AttributeUtils.getAttributeValueFromMail(mail, name).flatMap(value -> AttributeUtils.tryToCast(type, value));
    }

    public static Optional<?> getAttributeValueFromMail(Mail mail, AttributeName name) {
        return mail.getAttribute(name).map(AttributeUtils::getAttributeValue);
    }

    public static Object getAttributeValue(Attribute attribute) {
        return attribute.getValue().getValue();
    }

    private static <T> Optional<T> tryToCast(Class<T> type, Object value) {
        if (type.isInstance(value)) {
            return Optional.of(type.cast(value));
        }
        return Optional.empty();
    }
}

