/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.ai.classic;

import java.io.IOException;
import java.io.Reader;
import java.util.stream.IntStream;

public abstract class Tokenizer {
    private String header = "";

    protected void doTokenize(Reader stream) throws IOException {
        Object token;
        while ((token = this.nextToken(stream)) != null) {
            boolean endingLine = false;
            if (((String)token).length() > 0 && ((String)token).charAt(((String)token).length() - 1) == '\n') {
                endingLine = true;
                token = ((String)token).substring(0, ((String)token).length() - 1);
            }
            if (((String)token).length() > 0 && this.header.length() + ((String)token).length() < 90 && !this.allDigits((String)token)) {
                if (((String)token).equals("From:") || ((String)token).equals("Return-Path:") || ((String)token).equals("Subject:") || ((String)token).equals("To:")) {
                    this.header = token;
                    if (!endingLine) continue;
                }
                token = this.header + (String)token;
                this.next((String)token);
            }
            if (!endingLine) continue;
            this.header = "";
        }
    }

    protected abstract void next(String var1);

    private boolean allDigits(String s) {
        return IntStream.range(0, s.length()).allMatch(i -> Character.isDigit(s.charAt(i)));
    }

    private String nextToken(Reader reader) throws IOException {
        int i;
        StringBuilder token = new StringBuilder();
        boolean previousWasDigit = false;
        boolean tokenCharFound = false;
        if (!reader.ready()) {
            return null;
        }
        while ((i = reader.read()) != -1) {
            String tokenString;
            char ch = (char)i;
            if (ch == ':' && ((tokenString = token.toString() + ":").equals("From:") || tokenString.equals("Return-Path:") || tokenString.equals("Subject:") || tokenString.equals("To:"))) {
                return tokenString;
            }
            if (Character.isLetter(ch) || ch == '-' || ch == '$' || ch == '\u20ac' || ch == '!' || ch == '\'') {
                tokenCharFound = true;
                previousWasDigit = false;
                token.append(ch);
                continue;
            }
            if (Character.isDigit(ch)) {
                tokenCharFound = true;
                previousWasDigit = true;
                token.append(ch);
                continue;
            }
            if (previousWasDigit && (ch == '.' || ch == ',')) {
                reader.mark(1);
                previousWasDigit = false;
                i = reader.read();
                if (i == -1) break;
                char ch2 = (char)i;
                if (Character.isDigit(ch2)) {
                    tokenCharFound = true;
                    previousWasDigit = true;
                    token.append(ch);
                    token.append(ch2);
                    continue;
                }
                reader.reset();
                break;
            }
            if (ch == '\r') continue;
            if (ch == '\n') {
                tokenCharFound = true;
                previousWasDigit = false;
                token.append(ch);
                break;
            }
            if (!tokenCharFound) continue;
        }
        if (tokenCharFound) {
            return token.toString();
        }
        return null;
    }
}

