/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.ai.classic;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.ai.classic.BayesianAnalyzer;
import org.apache.james.ai.classic.JDBCUtil;
import org.apache.james.ai.classic.SqlResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JDBCBayesianAnalyzer
extends BayesianAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCBayesianAnalyzer.class);
    public static final String DATABASE_LOCK = "database lock";
    private final JDBCUtil theJDBCUtil = new JDBCUtil();
    private final SqlResources sqlQueries = new SqlResources();
    private String sqlFileName;
    private Map<String, String> sqlParameters = new HashMap<String, String>();
    private static long lastDatabaseUpdateTime;

    public static long getLastDatabaseUpdateTime() {
        return lastDatabaseUpdateTime;
    }

    public static void touchLastDatabaseUpdateTime() {
        lastDatabaseUpdateTime = System.currentTimeMillis();
    }

    public String getSqlFileName() {
        return this.sqlFileName;
    }

    public void setSqlFileName(String sqlFileName) {
        this.sqlFileName = sqlFileName;
    }

    public Map<String, String> getSqlParameters() {
        return this.sqlParameters;
    }

    public void setSqlParameters(Map<String, String> sqlParameters) {
        this.sqlParameters = sqlParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHamNSpam(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectHamTokens", true));
            rs = pstmt.executeQuery();
            Map<String, Integer> ham = this.getHamTokenCounts();
            while (rs.next()) {
                String token = rs.getString(1);
                int count = rs.getInt(2);
                if (count <= 1) continue;
                ham.put(token, count);
            }
            LOGGER.debug("Ham tokens count: {}", (Object)ham.size());
            rs.close();
            pstmt.close();
            pstmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectSpamTokens", true));
            rs = pstmt.executeQuery();
            Map<String, Integer> spam = this.getSpamTokenCounts();
            while (rs.next()) {
                String token = rs.getString(1);
                int count = rs.getInt(2);
                if (count <= 1) continue;
                spam.put(token, count);
            }
            LOGGER.debug("Spam tokens count: {}", (Object)spam.size());
            rs.close();
            pstmt.close();
            pstmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectMessageCounts", true));
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.setHamMessageCount(rs.getInt(1));
                this.setSpamMessageCount(rs.getInt(2));
            }
            rs.close();
            pstmt.close();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {
                    LOGGER.error("Failed to close statement after selecting spam tokens.", (Throwable)se);
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException se) {
                    LOGGER.error("Failed to close statement selecting message counts.", (Throwable)se);
                }
                pstmt = null;
            }
        }
    }

    public void updateHamTokens(Connection conn) throws SQLException {
        this.updateTokens(conn, this.getHamTokenCounts(), this.sqlQueries.getSqlString("insertHamToken", true), this.sqlQueries.getSqlString("updateHamToken", true));
        this.setMessageCount(conn, this.sqlQueries.getSqlString("updateHamMessageCounts", true), this.getHamMessageCount());
    }

    public void updateSpamTokens(Connection conn) throws SQLException {
        this.updateTokens(conn, this.getSpamTokenCounts(), this.sqlQueries.getSqlString("insertSpamToken", true), this.sqlQueries.getSqlString("updateSpamToken", true));
        this.setMessageCount(conn, this.sqlQueries.getSqlString("updateSpamMessageCounts", true), this.getSpamMessageCount());
    }

    public void resetData(Connection conn) throws SQLException {
        this.deleteData(conn, this.sqlQueries.getSqlString("deleteHamTokens", true));
        this.deleteData(conn, this.sqlQueries.getSqlString("deleteSpamTokens", true));
        this.deleteData(conn, this.sqlQueries.getSqlString("deleteMessageCounts", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageCount(Connection conn, String sqlStatement, int count) throws SQLException {
        Statement init = null;
        Statement update = null;
        try {
            init = conn.prepareStatement(this.sqlQueries.getSqlString("initializeMessageCounts", true));
            update = conn.prepareStatement(sqlStatement);
            update.setInt(1, count);
            if (update.executeUpdate() == 0) {
                init.executeUpdate();
                update.executeUpdate();
            }
        }
        finally {
            if (init != null) {
                try {
                    init.close();
                }
                catch (SQLException ignore) {
                    LOGGER.error("Failed to close statement after initializing message count.", (Throwable)ignore);
                }
            }
            if (update != null) {
                try {
                    update.close();
                }
                catch (SQLException ignore) {
                    LOGGER.error("Failed to close statement after setting message count.", (Throwable)ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTokens(Connection conn, Map<String, Integer> tokens, String insertSqlStatement, String updateSqlStatement) throws SQLException {
        PreparedStatement insert = null;
        PreparedStatement update = null;
        try {
            insert = conn.prepareStatement(insertSqlStatement);
            update = conn.prepareStatement(updateSqlStatement);
            for (Map.Entry<String, Integer> entry : tokens.entrySet()) {
                update.setInt(1, entry.getValue());
                update.setString(2, entry.getKey());
                if (update.executeUpdate() != 0) continue;
                insert.setString(1, entry.getKey());
                insert.setInt(2, entry.getValue());
                insert.executeUpdate();
            }
        }
        finally {
            if (insert != null) {
                try {
                    insert.close();
                }
                catch (SQLException ignore) {
                    LOGGER.error("Failed to close statement after updating tokens.", (Throwable)ignore);
                }
                insert = null;
            }
            if (update != null) {
                try {
                    update.close();
                }
                catch (SQLException ignore) {
                    LOGGER.error("Failed to close statement after updating tokens.", (Throwable)ignore);
                }
                update = null;
            }
        }
    }

    public void initSqlQueries(Connection conn, Document sqlConfiguration) throws Exception {
        try {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            this.sqlQueries.init(sqlConfiguration, JDBCBayesianAnalyzer.class.getName(), conn, this.getSqlParameters());
            this.checkTables(conn);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    private void checkTables(Connection conn) throws SQLException {
        boolean dbUpdated = false;
        dbUpdated = this.createTable(conn, "hamTableName", "createHamTable");
        dbUpdated = this.createTable(conn, "spamTableName", "createSpamTable");
        dbUpdated = this.createTable(conn, "messageCountsTableName", "createMessageCountsTable");
        if (conn != null && dbUpdated && !conn.getAutoCommit()) {
            conn.commit();
            dbUpdated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(Connection conn, String tableNameSqlStringName, String createSqlStringName) throws SQLException {
        String tableName = this.sqlQueries.getSqlString(tableNameSqlStringName, true);
        DatabaseMetaData dbMetaData = conn.getMetaData();
        if (this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
            return false;
        }
        PreparedStatement createStatement = null;
        try {
            createStatement = conn.prepareStatement(this.sqlQueries.getSqlString(createSqlStringName, true));
            createStatement.execute();
            LOGGER.debug("Created table '{}' using sqlResources string '{}'.", (Object)tableName, (Object)createSqlStringName);
            this.theJDBCUtil.closeJDBCStatement(createStatement);
        }
        catch (Throwable throwable) {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteData(Connection conn, String deleteSqlStatement) throws SQLException {
        PreparedStatement delete = null;
        try {
            delete = conn.prepareStatement(deleteSqlStatement);
            delete.executeUpdate();
        }
        finally {
            if (delete != null) {
                try {
                    delete.close();
                }
                catch (SQLException ignore) {
                    LOGGER.error("Failed to close statement after deleting ham statement. ", (Throwable)ignore);
                }
                delete = null;
            }
        }
    }
}

