/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.ai.classic;

import java.sql.SQLException;
import org.apache.james.ai.classic.BayesianAnalysis;
import org.apache.james.ai.classic.JDBCBayesianAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CorpusLoaderThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorpusLoaderThread.class);
    private final BayesianAnalysis analysis;

    CorpusLoaderThread(BayesianAnalysis analysis) {
        super("BayesianAnalysis Corpus Loader");
        this.analysis = analysis;
    }

    @Override
    public void run() {
        LOGGER.info("CorpusLoader thread started: will wake up every 600000 ms");
        try {
            Thread.sleep(600000L);
            while (true) {
                if (this.analysis.getLastCorpusLoadTime() < JDBCBayesianAnalyzer.getLastDatabaseUpdateTime()) {
                    LOGGER.info("Reloading Corpus ...");
                    try {
                        this.analysis.loadData(this.analysis.datasource.getConnection());
                        LOGGER.info("Corpus reloaded");
                    }
                    catch (SQLException se) {
                        LOGGER.error("SQLException: ", (Throwable)se);
                    }
                }
                if (!Thread.interrupted()) {
                    Thread.sleep(600000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ex) {
            this.interrupt();
        }
    }
}

