/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.route;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.rspamd.client.RspamdClientConfiguration;
import org.apache.james.rspamd.client.RspamdHttpClient;
import org.apache.james.rspamd.task.FeedHamToRspamdTask;
import org.apache.james.rspamd.task.FeedSpamToRspamdTask;
import org.apache.james.rspamd.task.RunningOptions;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.ParametersExtractor;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class FeedMessageRoute
implements Routes {
    public static final String BASE_PATH = "/rspamd";
    private static final String REPORT_SPAM_PARAM = "reportSpam";
    private static final String REPORT_HAM_PARAM = "reportHam";
    private final TaskManager taskManager;
    private final MailboxManager mailboxManager;
    private final MessageIdManager messageIdManager;
    private final MailboxSessionMapperFactory mapperFactory;
    private final UsersRepository usersRepository;
    private final RspamdHttpClient rspamdHttpClient;
    private final RspamdClientConfiguration rspamdConfiguration;
    private final JsonTransformer jsonTransformer;
    private final Clock clock;

    @Inject
    public FeedMessageRoute(TaskManager taskManager, MailboxManager mailboxManager, UsersRepository usersRepository, RspamdHttpClient rspamdHttpClient, JsonTransformer jsonTransformer, Clock clock, MessageIdManager messageIdManager, MailboxSessionMapperFactory mapperFactory, RspamdClientConfiguration rspamdConfiguration) {
        this.taskManager = taskManager;
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
        this.rspamdHttpClient = rspamdHttpClient;
        this.jsonTransformer = jsonTransformer;
        this.clock = clock;
        this.messageIdManager = messageIdManager;
        this.mapperFactory = mapperFactory;
        this.rspamdConfiguration = rspamdConfiguration;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        TaskFromRequest feedMessageTaskRequest = this::feedMessageTaskFromRequest;
        service.post(BASE_PATH, feedMessageTaskRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public Task feedMessageTaskFromRequest(Request request) {
        Preconditions.checkArgument((boolean)Optional.ofNullable(request.queryParams("action")).filter(action -> action.equals(REPORT_SPAM_PARAM) || action.equals(REPORT_HAM_PARAM)).isPresent(), (Object)String.format("'action' is missing or must be '%s' or '%s'", REPORT_SPAM_PARAM, REPORT_HAM_PARAM));
        return Optional.ofNullable(request.queryParams("action")).filter(action -> action.equals(REPORT_SPAM_PARAM)).map(any -> new FeedSpamToRspamdTask(this.mailboxManager, this.usersRepository, this.messageIdManager, this.mapperFactory, this.rspamdHttpClient, this.getRunningOptions(request), this.clock, this.rspamdConfiguration)).orElse(new FeedHamToRspamdTask(this.mailboxManager, this.usersRepository, this.messageIdManager, this.mapperFactory, this.rspamdHttpClient, this.getRunningOptions(request), this.clock, this.rspamdConfiguration));
    }

    private RunningOptions getRunningOptions(Request request) {
        Optional<Long> periodInSecond = this.getPeriod(request);
        int messagesPerSecond = this.getMessagesPerSecond(request).orElse(10);
        double samplingProbability = this.getSamplingProbability(request).orElse(1.0);
        Optional<Boolean> classifiedAsSpam = this.getClassifiedAsSpam(request);
        Duration rspamdTimeout = ParametersExtractor.extractDuration((Request)request, (String)"rspamdTimeout").orElse(RunningOptions.DEFAULT_RSPAMD_TIMEOUT);
        return new RunningOptions(periodInSecond, messagesPerSecond, samplingProbability, classifiedAsSpam, rspamdTimeout);
    }

    private Optional<Long> getPeriod(Request req) {
        return Optional.ofNullable(req.queryParams("period")).filter(Predicate.not(String::isEmpty)).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.SECONDS).toSeconds()).map(period -> {
            Preconditions.checkArgument((period > 0L ? 1 : 0) != 0, (Object)"'period' must be strictly positive");
            return period;
        });
    }

    private Optional<Integer> getMessagesPerSecond(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("messagesPerSecond")).map(Integer::parseInt).map(messagesPerSecond -> {
                Preconditions.checkArgument((messagesPerSecond > 0 ? 1 : 0) != 0, (Object)"'messagesPerSecond' must be strictly positive");
                return messagesPerSecond;
            });
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'messagesPerSecond' must be numeric");
        }
    }

    private Optional<Double> getSamplingProbability(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("samplingProbability")).map(Double::parseDouble).map(samplingProbability -> {
                Preconditions.checkArgument((samplingProbability >= 0.0 && samplingProbability <= 1.0 ? 1 : 0) != 0, (Object)"'samplingProbability' must be greater than or equal to 0.0 and smaller than or equal to 1.0");
                return samplingProbability;
            });
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'samplingProbability' must be numeric");
        }
    }

    private Optional<Boolean> getClassifiedAsSpam(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("classifiedAsSpam")).map(Boolean::parseBoolean);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'classifiedAsSpam' must be a boolean (true|false)");
        }
    }
}

