/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.module;

import com.google.inject.Inject;
import java.time.Clock;
import java.util.Set;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.rspamd.client.RspamdClientConfiguration;
import org.apache.james.rspamd.client.RspamdHttpClient;
import org.apache.james.rspamd.task.FeedHamToRspamdTask;
import org.apache.james.rspamd.task.FeedHamToRspamdTaskAdditionalInformationDTO;
import org.apache.james.rspamd.task.FeedHamToRspamdTaskDTO;
import org.apache.james.rspamd.task.FeedSpamToRspamdTask;
import org.apache.james.rspamd.task.FeedSpamToRspamdTaskAdditionalInformationDTO;
import org.apache.james.rspamd.task.FeedSpamToRspamdTaskDTO;
import org.apache.james.server.task.json.TaskExtensionModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.user.api.UsersRepository;

public class RspamdTaskExtensionModule
implements TaskExtensionModule {
    private final TaskDTOModule<FeedSpamToRspamdTask, FeedSpamToRspamdTaskDTO> feedSpamTaskDTOModule;
    private final TaskDTOModule<FeedHamToRspamdTask, FeedHamToRspamdTaskDTO> feedHamTaskDTOModule;

    @Inject
    public RspamdTaskExtensionModule(MailboxManager mailboxManager, UsersRepository usersRepository, MessageIdManager messageIdManager, MailboxSessionMapperFactory mapperFactory, RspamdHttpClient rspamdHttpClient, Clock clock, RspamdClientConfiguration rspamdConfiguration) {
        this.feedSpamTaskDTOModule = FeedSpamToRspamdTaskDTO.module(mailboxManager, usersRepository, messageIdManager, mapperFactory, rspamdHttpClient, clock, rspamdConfiguration);
        this.feedHamTaskDTOModule = FeedHamToRspamdTaskDTO.module(mailboxManager, usersRepository, messageIdManager, mapperFactory, rspamdHttpClient, clock, rspamdConfiguration);
    }

    public Set<TaskDTOModule<? extends Task, ? extends TaskDTO>> taskDTOModules() {
        return Set.of(this.feedSpamTaskDTOModule, this.feedHamTaskDTOModule);
    }

    public Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>> taskAdditionalInformationDTOModules() {
        return Set.of(FeedSpamToRspamdTaskAdditionalInformationDTO.SERIALIZATION_MODULE, FeedHamToRspamdTaskAdditionalInformationDTO.SERIALIZATION_MODULE);
    }
}

