/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.protocol;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.james.mpt.api.ProtocolInteractor;
import org.apache.james.mpt.protocol.ProtocolSession;

public class ProtocolSessionBuilder {
    public static final String LOG = "LOG";
    public static final String AWAIT = "AWAIT";
    public static final String WAIT = "WAIT";
    public static final String SERVER_CONTINUATION_TAG = "S: \\+ Ok";
    public static final String CLIENT_TAG = "C:";
    public static final String SERVER_TAG = "S:";
    public static final String OPEN_UNORDERED_BLOCK_TAG = "SUB {";
    public static final String CLOSE_UNORDERED_BLOCK_TAG = "}";
    public static final String COMMENT_TAG = "#";
    public static final String SESSION_TAG = "SESSION:";
    public static final String REINIT = "REINIT";
    public static final String TIMER = "TIMER";
    private final Properties variables = new Properties();

    public void setVariable(String name, String value) {
        this.variables.put(name, value);
    }

    public ProtocolInteractor buildProtocolSession(String fileName) throws Exception {
        ProtocolSession session = new ProtocolSession();
        this.addTestFile(fileName, session);
        return session;
    }

    public ProtocolInteractor buildProtocolSession(String scriptName, Reader reader) throws Exception {
        ProtocolSession session = new ProtocolSession();
        this.addProtocolLines(scriptName, reader, (ProtocolInteractor)session);
        return session;
    }

    public void addTestFile(String fileName, ProtocolInteractor session) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is == null) {
            throw new Exception("Test Resource '" + fileName + "' not found.");
        }
        this.addProtocolLines(fileName, is, session);
    }

    public void addProtocolLines(String scriptName, InputStream is, ProtocolInteractor session) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.doAddProtocolLines(session, scriptName, reader);
    }

    public void addProtocolLines(String scriptName, Reader reader, ProtocolInteractor session) throws Exception {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.doAddProtocolLines(session, scriptName, bufferedReader);
    }

    private void doAddProtocolLines(ProtocolInteractor session, String scriptName, BufferedReader reader) throws Exception {
        String line;
        int sessionNumber = -1;
        int lineNumber = -1;
        String lastClientMsg = "";
        while ((line = reader.readLine()) != null) {
            line = this.substituteVariables(line);
            String location = scriptName + ":" + lineNumber;
            if (line.startsWith("\\+")) {
                session.cont(sessionNumber);
            } else if (line.startsWith(CLIENT_TAG)) {
                String clientMsg = "";
                if (line.length() > 3) {
                    clientMsg = line.substring(3);
                }
                session.cl(sessionNumber, clientMsg);
                lastClientMsg = clientMsg;
            } else if (line.startsWith(SERVER_TAG)) {
                String serverMsg = "";
                if (line.length() > 3) {
                    serverMsg = line.substring(3);
                }
                session.sl(sessionNumber, serverMsg, location, lastClientMsg);
            } else if (line.startsWith(OPEN_UNORDERED_BLOCK_TAG)) {
                ArrayList<String> unorderedLines = new ArrayList<String>(5);
                line = reader.readLine();
                while (!line.startsWith(CLOSE_UNORDERED_BLOCK_TAG)) {
                    if (!line.startsWith(SERVER_TAG)) {
                        throw new Exception("Only 'S: ' lines are permitted inside a 'SUB {' block.");
                    }
                    String serverMsg = line.substring(3);
                    unorderedLines.add(serverMsg);
                    line = reader.readLine();
                    ++lineNumber;
                }
                session.sub(sessionNumber, unorderedLines, location, lastClientMsg);
            } else if (!line.startsWith(COMMENT_TAG) && line.trim().length() != 0) {
                if (line.startsWith(SESSION_TAG)) {
                    String number = line.substring(SESSION_TAG.length()).trim();
                    if (number.length() == 0) {
                        throw new Exception("No session number specified");
                    }
                    sessionNumber = Integer.parseInt(number);
                } else {
                    String prefix = line;
                    if (line.length() > 3) {
                        prefix = line.substring(0, 3);
                    }
                    throw new Exception("Invalid line prefix: " + prefix);
                }
            }
            ++lineNumber;
        }
    }

    private String substituteVariables(String line) {
        if (this.variables.size() > 0) {
            StringBuilder builder = new StringBuilder(line);
            int start = 0;
            int end = 0;
            while (start >= 0 && end >= 0 && (start = builder.indexOf("${", end)) >= 0 && (end = builder.indexOf(CLOSE_UNORDERED_BLOCK_TAG, start)) >= 0) {
                String name = builder.substring(start + 2, end);
                String value = this.variables.getProperty(name);
                if (value == null) continue;
                builder.replace(start, end + 1, value);
                int variableLength = end - start + 2;
                end += value.length() - variableLength;
            }
            line = builder.toString();
        }
        return line;
    }
}

