/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.protocol;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.james.mpt.protocol.ProtocolSession;
import org.apache.james.mpt.protocol.ProtocolSessionBuilder;

public class FileProtocolSessionBuilder
extends ProtocolSessionBuilder {
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERR = "ERR";
    private static final int TIMER_COMMAND_START = "TIMER".length() + 1;
    private static final int TIMER_COMMAND_END = TIMER_COMMAND_START + 5;

    @Override
    public ProtocolSession buildProtocolSession(String fileName) throws Exception {
        ProtocolSession session = new ProtocolSession();
        this.addTestFile(fileName, session);
        return session;
    }

    public void addTestFile(String fileName, ProtocolSession session) throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream(fileName);){
            if (is == null) {
                throw new Exception("Test Resource '" + fileName + "' not found.");
            }
            this.addProtocolLinesFromStream(is, session, fileName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addProtocolLinesFromStream(InputStream is, ProtocolSession session, String fileName) throws Exception {
        int sessionNumber = -1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String next;
            int lineNumber = -1;
            String lastClientMsg = "";
            while ((next = reader.readLine()) != null) {
                String location = fileName + ":" + lineNumber;
                if ("S: \\+ Ok".equals(next)) {
                    session.cont(sessionNumber);
                } else if (next.startsWith("C:")) {
                    String clientMsg = "";
                    if (next.length() > 3) {
                        clientMsg = next.substring(3);
                    }
                    session.cl(sessionNumber, clientMsg);
                    lastClientMsg = clientMsg;
                } else if (next.startsWith("S:")) {
                    String serverMsg = "";
                    if (next.length() > 3) {
                        serverMsg = next.substring(3);
                    }
                    session.sl(sessionNumber, serverMsg, location, lastClientMsg);
                } else if (next.startsWith("WAIT")) {
                    if (next.length() <= 5) throw new Exception("Invalid line length on WAIT instruction : " + next);
                    session.wait(sessionNumber, Long.parseLong(next.substring(5)));
                } else if (next.startsWith("LOG")) {
                    String logInstruction = next.substring(4);
                    if (logInstruction.startsWith(DEBUG)) {
                        session.log(sessionNumber, ProtocolSession.LolLevel.Debug, logInstruction.substring(6));
                    } else if (logInstruction.startsWith(INFO)) {
                        session.log(sessionNumber, ProtocolSession.LolLevel.Info, logInstruction.substring(5));
                    } else if (logInstruction.startsWith(WARN)) {
                        session.log(sessionNumber, ProtocolSession.LolLevel.Warn, logInstruction.substring(5));
                    } else {
                        if (!logInstruction.startsWith(ERR)) throw new Exception("Unrecognized log level for " + next);
                        session.log(sessionNumber, ProtocolSession.LolLevel.Err, logInstruction.substring(4));
                    }
                } else if (next.startsWith("REINIT")) {
                    session.reinit(sessionNumber);
                } else if (next.startsWith("AWAIT")) {
                    session.await(sessionNumber);
                } else if (next.startsWith("SUB {")) {
                    ArrayList<String> unorderedLines = new ArrayList<String>(5);
                    next = reader.readLine();
                    if (next == null) {
                        throw new Exception("Readline doesn't contain any data, but must not be 'null' (linenumber=" + lineNumber);
                    }
                    while (!next.startsWith("}")) {
                        if (!next.startsWith("S:")) {
                            throw new Exception("Only 'S: ' lines are permitted inside a 'SUB {' block.");
                        }
                        String serverMsg = next.substring(3);
                        unorderedLines.add(serverMsg);
                        next = reader.readLine();
                        ++lineNumber;
                        if (next != null) continue;
                        throw new Exception("Readline doesn't contain any data, but must not be 'null' (linenumber=" + lineNumber);
                    }
                    session.sub(sessionNumber, unorderedLines, location, lastClientMsg);
                } else if (!next.startsWith("#") && next.trim().length() != 0) {
                    if (next.startsWith("SESSION:")) {
                        String number = next.substring("SESSION:".length()).trim();
                        if (number.length() == 0) {
                            throw new Exception("No session number specified");
                        }
                        sessionNumber = Integer.parseInt(number);
                    } else if (next.startsWith("TIMER")) {
                        ProtocolSession.TimerCommand timerCommand = ProtocolSession.TimerCommand.from(next.substring(TIMER_COMMAND_START, TIMER_COMMAND_END));
                        String timerName = next.substring(TIMER_COMMAND_END + 1);
                        session.timer(timerCommand, timerName);
                    } else {
                        String prefix = next;
                        if (next.length() <= 3) throw new Exception("Invalid line prefix: " + prefix);
                        prefix = next.substring(0, 3);
                        throw new Exception("Invalid line prefix: " + prefix);
                    }
                }
                ++lineNumber;
            }
            return;
        }
    }
}

