/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import javax.inject.Inject;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.mailbox.events.EventDeadLetters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDeadLettersHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDeadLettersHealthCheck.class);
    private static final ComponentName COMPONENT_NAME = new ComponentName("EventDeadLettersHealthCheck");
    private final EventDeadLetters eventDeadLetters;

    @Inject
    EventDeadLettersHealthCheck(EventDeadLetters eventDeadLetters) {
        this.eventDeadLetters = eventDeadLetters;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Result check() {
        try {
            boolean containEvents = (Boolean)this.eventDeadLetters.containEvents().block();
            if (containEvents) {
                return Result.degraded((ComponentName)COMPONENT_NAME, (String)"EventDeadLetters contain events. This might indicate transient failure on mailbox event processing.");
            }
            return Result.healthy((ComponentName)COMPONENT_NAME);
        }
        catch (Exception e) {
            LOGGER.error("Error checking EventDeadLettersHealthCheck", (Throwable)e);
            return Result.unhealthy((ComponentName)COMPONENT_NAME, (String)e.getMessage());
        }
    }
}

