/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.FetchRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.FetchResponseBuilder;
import org.apache.james.imap.processor.fetch.MimePathImpl;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageRangeException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.UnsupportedCriteriaException;
import org.apache.james.mailbox.util.FetchGroupImpl;
import org.apache.james.mime4j.field.address.parser.ParseException;

public class FetchProcessor
extends AbstractMailboxProcessor<FetchRequest> {
    private int batchSize;

    public FetchProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, int batchSize) {
        super(FetchRequest.class, next, mailboxManager, factory);
        this.batchSize = batchSize;
    }

    @Override
    protected void doProcess(FetchRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        boolean useUids = request.isUseUids();
        IdRange[] idSet = request.getIdSet();
        FetchData fetch = request.getFetch();
        try {
            MessageManager mailbox = this.getSelectedMailbox(session);
            if (mailbox == null) {
                throw new MailboxException("Session not in SELECTED state");
            }
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
            ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
            for (int i = 0; i < idSet.length; ++i) {
                MessageRange messageSet = this.messageRange(session.getSelected(), idSet[i], useUids);
                if (messageSet == null) continue;
                MessageRange normalizedMessageSet = this.normalizeMessageRange(session.getSelected(), messageSet);
                MessageRange batchedMessageSet = MessageRange.range((long)normalizedMessageSet.getUidFrom(), (long)normalizedMessageSet.getUidTo(), (int)this.batchSize);
                ranges.add(batchedMessageSet);
            }
            this.processMessageRanges(session, mailbox, ranges, fetch, useUids, mailboxSession, responder);
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            this.okComplete(command, tag, responder);
        }
        catch (UnsupportedCriteriaException e) {
            this.no(command, tag, responder, HumanReadableText.UNSUPPORTED_SEARCH_CRITERIA);
        }
        catch (MessageRangeException e) {
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            this.no(command, tag, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    protected void processMessageRanges(final ImapSession session, final MessageManager mailbox, List<MessageRange> ranges, final FetchData fetch, final boolean useUids, MailboxSession mailboxSession, final ImapProcessor.Responder responder) throws MailboxException {
        final FetchResponseBuilder builder = new FetchResponseBuilder(new EnvelopeBuilder(session.getLog()));
        MessageResult.FetchGroup resultToFetch = this.getFetchGroup(fetch);
        for (int i = 0; i < ranges.size(); ++i) {
            mailbox.getMessages(ranges.get(i), resultToFetch, mailboxSession, new MessageManager.MessageCallback(){

                public void onMessages(Iterator<MessageResult> it) throws MailboxException {
                    while (it.hasNext()) {
                        MessageResult result = it.next();
                        try {
                            FetchResponse response = builder.build(fetch, result, mailbox, session, useUids);
                            responder.respond((ImapResponseMessage)response);
                        }
                        catch (ParseException e) {
                            session.getLog().debug("Unable to parse message with uid " + result.getUid(), (Throwable)e);
                        }
                        catch (MessageRangeException e) {
                            session.getLog().debug("Unable to find message with uid " + result.getUid(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    protected MessageResult.FetchGroup getFetchGroup(FetchData fetch) {
        Collection bodyElements;
        FetchGroupImpl result = new FetchGroupImpl();
        if (fetch.isEnvelope()) {
            result.or(256);
        }
        if (fetch.isBody() || fetch.isBodyStructure()) {
            result.or(1);
        }
        if ((bodyElements = fetch.getBodyElements()) != null) {
            for (BodyFetchElement element : bodyElements) {
                int sectionType = element.getSectionType();
                int[] path = element.getPath();
                boolean isBase = path == null || path.length == 0;
                switch (sectionType) {
                    case 5: {
                        if (isBase) {
                            this.addContent(result, path, isBase, 512);
                            break;
                        }
                        this.addContent(result, path, isBase, 4096);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.addContent(result, path, isBase, 256);
                        break;
                    }
                    case 1: {
                        this.addContent(result, path, isBase, 2048);
                        break;
                    }
                    case 0: {
                        this.addContent(result, path, isBase, 1024);
                        break;
                    }
                }
            }
        }
        return result;
    }

    private void addContent(FetchGroupImpl result, int[] path, boolean isBase, int content) {
        if (isBase) {
            result.or(content);
        } else {
            MimePathImpl mimePath = new MimePathImpl(path);
            result.addPartContent((MessageResult.MimePath)mimePath, content);
        }
    }
}

