/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.InputStreamContent;

final class ContentBodyElement
implements FetchResponse.BodyElement {
    private final String name;
    private final Content content;

    public ContentBodyElement(String name, Content content) {
        this.name = name;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public long size() {
        return this.content.size();
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        this.content.writeTo(channel);
    }

    public InputStream getInputStream() throws IOException {
        if (this.content instanceof InputStreamContent) {
            return ((InputStreamContent)this.content).getInputStream();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(Channels.newChannel(out));
        return new ByteArrayInputStream(out.toByteArray());
    }
}

