/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Map;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.StoreRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageRangeException;

public class StoreProcessor
extends AbstractMailboxProcessor<StoreRequest> {
    public StoreProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(StoreRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(StoreRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        boolean replace;
        boolean value;
        IdRange[] idSet = request.getIdSet();
        Flags flags = request.getFlags();
        boolean useUids = request.isUseUids();
        boolean silent = request.isSilent();
        boolean isSignedPlus = request.isSignedPlus();
        boolean isSignedMinus = request.isSignedMinus();
        if (isSignedMinus) {
            value = false;
            replace = false;
        } else if (isSignedPlus) {
            value = true;
            replace = false;
        } else {
            replace = true;
            value = true;
        }
        try {
            MessageManager mailbox = this.getSelectedMailbox(session);
            for (int i = 0; i < idSet.length; ++i) {
                SelectedMailbox selected = session.getSelected();
                MessageRange messageSet = this.messageRange(selected, idSet[i], useUids);
                if (messageSet == null) continue;
                MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
                Map flagsByUid = mailbox.setFlags(flags, value, replace, messageSet, mailboxSession);
                if (selected.hasNewApplicableFlags()) {
                    this.flags(responder, selected);
                    this.permanentFlags(responder, mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT), selected);
                    selected.resetNewApplicableFlags();
                }
                if (silent) continue;
                for (Map.Entry entry : flagsByUid.entrySet()) {
                    long uid = (Long)entry.getKey();
                    int msn = selected.msn(uid);
                    if (msn == -1) {
                        throw new MailboxException("No message found with uid " + uid);
                    }
                    Flags resultFlags = (Flags)entry.getValue();
                    Long resultUid = useUids ? Long.valueOf(uid) : null;
                    if (selected.isRecent(uid)) {
                        resultFlags.add(Flags.Flag.RECENT);
                    }
                    FetchResponse response = new FetchResponse(msn, resultFlags, resultUid, null, null, null, null, null, null);
                    responder.respond((ImapResponseMessage)response);
                }
            }
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            this.okComplete(command, tag, responder);
        }
        catch (MessageRangeException e) {
            session.getLog().debug("Store failed", (Throwable)e);
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            session.getLog().debug("Store failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.SAVE_FAILED);
        }
    }
}

