/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LsubRequest;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxQuery;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionException;
import org.apache.james.mailbox.SubscriptionManager;

public class LSubProcessor
extends AbstractSubscriptionProcessor<LsubRequest> {
    public LSubProcessor(ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory) {
        super(LsubRequest.class, next, mailboxManager, subscriptionManager, factory);
    }

    private void listSubscriptions(ImapSession session, ImapProcessor.Responder responder, String referenceName, String mailboxName) throws SubscriptionException, MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        Collection mailboxes = this.getSubscriptionManager().subscriptions(mailboxSession);
        String finalReferencename = referenceName;
        if (mailboxName.charAt(0) == '#') {
            finalReferencename = "";
        }
        boolean isRelative = (finalReferencename + mailboxName).charAt(0) != '#';
        MailboxPath basePath = null;
        basePath = isRelative ? new MailboxPath("#private", mailboxSession.getUser().getUserName(), finalReferencename) : this.buildFullPath(session, finalReferencename);
        MailboxQuery expression = new MailboxQuery(basePath, mailboxName, mailboxSession.getPathDelimiter());
        ArrayList<String> mailboxResponses = new ArrayList<String>();
        for (String mailbox : mailboxes) {
            this.respond(responder, expression, mailbox, true, mailboxes, mailboxResponses, mailboxSession.getPathDelimiter());
        }
    }

    private void respond(ImapProcessor.Responder responder, MailboxQuery expression, String mailboxName, boolean originalSubscription, Collection<String> mailboxes, Collection<String> mailboxResponses, char delimiter) {
        if (expression.isExpressionMatch(mailboxName)) {
            if (!mailboxResponses.contains(mailboxName)) {
                LSubResponse response = new LSubResponse(mailboxName, !originalSubscription, delimiter);
                responder.respond((ImapResponseMessage)response);
                mailboxResponses.add(mailboxName);
            }
        } else {
            String parentMailbox;
            int lastDelimiter = mailboxName.lastIndexOf(delimiter);
            if (lastDelimiter > 0 && !mailboxes.contains(parentMailbox = mailboxName.substring(0, lastDelimiter))) {
                this.respond(responder, expression, parentMailbox, false, mailboxes, mailboxResponses, delimiter);
            }
        }
    }

    private void respondWithHierarchyDelimiter(ImapProcessor.Responder responder, char delimiter) {
        LSubResponse response = new LSubResponse("", true, delimiter);
        responder.respond((ImapResponseMessage)response);
    }

    @Override
    protected void doProcessRequest(LsubRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String referenceName = request.getBaseReferenceName();
        String mailboxPattern = request.getMailboxPattern();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        try {
            if (mailboxPattern.length() == 0) {
                this.respondWithHierarchyDelimiter(responder, mailboxSession.getPathDelimiter());
            } else {
                this.listSubscriptions(session, responder, referenceName, mailboxPattern);
            }
            this.okComplete(command, tag, responder);
        }
        catch (SubscriptionException e) {
            session.getLog().debug("LSub failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_LSUB_FAILURE);
        }
        catch (MailboxException e) {
            session.getLog().debug("LSub failed", (Throwable)e);
            HumanReadableText displayTextKey = HumanReadableText.GENERIC_LSUB_FAILURE;
            this.no(command, tag, responder, displayTextKey);
        }
    }
}

