/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.DeleteRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;

public class DeleteProcessor
extends AbstractMailboxProcessor<DeleteRequest> {
    public DeleteProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(DeleteRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(DeleteRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = this.buildFullPath(session, request.getMailboxName());
        try {
            SelectedMailbox selected = session.getSelected();
            if (selected != null && selected.getPath().equals((Object)mailboxPath)) {
                session.deselect();
            }
            MailboxManager mailboxManager = this.getMailboxManager();
            mailboxManager.deleteMailbox(mailboxPath, ImapSessionUtils.getMailboxSession((ImapSession)session));
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, responder);
        }
        catch (MailboxNotFoundException e) {
            session.getLog().debug("Delete failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
        }
        catch (MailboxException e) {
            session.getLog().debug("Delete failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

