/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.AppendRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.slf4j.Logger;

public class AppendProcessor
extends AbstractMailboxProcessor<AppendRequest> {
    public AppendProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory) {
        super(AppendRequest.class, next, mailboxManager, statusResponseFactory);
    }

    @Override
    protected void doProcess(AppendRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        InputStream messageIn = request.getMessage();
        Date datetime = request.getDatetime();
        Flags flags = request.getFlags();
        try {
            MailboxPath mailboxPath = this.buildFullPath(session, mailboxName);
            MailboxManager mailboxManager = this.getMailboxManager();
            MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, ImapSessionUtils.getMailboxSession((ImapSession)session));
            this.appendToMailbox(messageIn, datetime, flags, session, tag, command, mailbox, responder, mailboxPath);
        }
        catch (MailboxNotFoundException e) {
            this.consume(messageIn);
            session.getLog().debug("Append failed", (Throwable)e);
            this.tryCreate(session, tag, command, responder, e);
        }
        catch (MailboxException e) {
            this.consume(messageIn);
            session.getLog().debug("Append failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void consume(InputStream in) {
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void tryCreate(ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, MailboxNotFoundException e) {
        Logger logger = session.getLog();
        if (logger.isDebugEnabled()) {
            logger.debug("Cannot open mailbox: ", (Throwable)e);
        }
        this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
    }

    private void appendToMailbox(InputStream message, Date datetime, Flags flagsToBeSet, ImapSession session, String tag, ImapCommand command, MessageManager mailbox, ImapProcessor.Responder responder, MailboxPath mailboxPath) {
        try {
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
            SelectedMailbox selectedMailbox = session.getSelected();
            MailboxManager mailboxManager = this.getMailboxManager();
            boolean isSelectedMailbox = selectedMailbox != null && selectedMailbox.getPath().equals((Object)mailboxPath);
            long uid = mailbox.appendMessage(message, datetime, mailboxSession, !isSelectedMailbox, flagsToBeSet);
            if (isSelectedMailbox) {
                selectedMailbox.addRecent(uid);
            }
            Long uidValidity = mailboxManager.getMailbox(mailboxPath, mailboxSession).getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_UNSEEN).getUidValidity();
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, StatusResponse.ResponseCode.appendUid((long)uidValidity, (IdRange[])new IdRange[]{new IdRange(uid)}), responder);
        }
        catch (MailboxNotFoundException e) {
            this.tryCreate(session, tag, command, responder, e);
        }
        catch (MailboxException e) {
            session.getLog().debug("Unable to append message", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.SAVE_FAILED);
        }
    }
}

