/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.BadCredentialsException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxExistsException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;

public abstract class AbstractAuthProcessor<M extends ImapRequest>
extends AbstractMailboxProcessor<M> {
    private static final String ATTRIBUTE_NUMBER_OF_FAILURES = "org.apache.james.imap.processor.imap4rev1.NUMBER_OF_FAILURES";
    private static final int MAX_FAILURES = 3;

    public AbstractAuthProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(acceptableClass, next, mailboxManager, factory);
    }

    protected void doAuth(String userid, String passwd, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, HumanReadableText failed) {
        try {
            boolean authFailure = false;
            if (userid == null) {
                authFailure = true;
            }
            if (!authFailure) {
                MailboxManager mailboxManager = this.getMailboxManager();
                try {
                    MailboxSession mailboxSession = mailboxManager.login(userid, passwd, session.getLog());
                    session.authenticated();
                    session.setAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY", (Object)mailboxSession);
                    MailboxPath inboxPath = this.buildFullPath(session, "INBOX");
                    if (mailboxManager.mailboxExists(inboxPath, mailboxSession)) {
                        session.getLog().debug("INBOX exists. No need to create it.");
                    } else {
                        try {
                            session.getLog().debug("INBOX does not exist. Creating it.");
                            mailboxManager.createMailbox(inboxPath, mailboxSession);
                        }
                        catch (MailboxExistsException e) {
                            session.getLog().debug("Mailbox created by concurrent call. Safe to ignore this exception.");
                        }
                    }
                    this.okComplete(command, tag, responder);
                }
                catch (BadCredentialsException e) {
                    authFailure = true;
                }
            }
            if (authFailure) {
                Integer currentNumberOfFailures = (Integer)session.getAttribute(ATTRIBUTE_NUMBER_OF_FAILURES);
                int failures = currentNumberOfFailures == null ? 1 : currentNumberOfFailures + 1;
                if (failures < 3) {
                    session.setAttribute(ATTRIBUTE_NUMBER_OF_FAILURES, (Object)failures);
                    this.no(command, tag, responder, failed);
                } else {
                    session.getLog().info("Too many authentication failures. Closing connection.");
                    this.bye(responder, HumanReadableText.TOO_MANY_FAILURES);
                    session.logout();
                }
            }
        }
        catch (MailboxException e) {
            session.getLog().debug("Login failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

