/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.base;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.MessagingImapCommandParser;

public abstract class AbstractImapCommandParser
implements MessagingImapCommandParser {
    private final ImapCommand command;
    private StatusResponseFactory statusResponseFactory;

    public AbstractImapCommandParser(ImapCommand command) {
        this.command = command;
    }

    public ImapCommand getCommand() {
        return this.command;
    }

    @Override
    public final StatusResponseFactory getStatusResponseFactory() {
        return this.statusResponseFactory;
    }

    @Override
    public final void setStatusResponseFactory(StatusResponseFactory statusResponseFactory) {
        this.statusResponseFactory = statusResponseFactory;
    }

    @Override
    public final ImapMessage parse(ImapRequestLineReader request, String tag, ImapSession session) {
        StatusResponse result;
        if (!this.command.validForState(session.getState())) {
            result = this.statusResponseFactory.taggedNo(tag, this.command, HumanReadableText.INVALID_COMMAND);
        } else {
            try {
                result = this.decode(this.command, request, tag, session);
            }
            catch (DecodingException e) {
                if (session.getLog().isDebugEnabled()) {
                    session.getLog().debug("Cannot parse protocol ", (Throwable)e);
                }
                result = this.statusResponseFactory.taggedBad(tag, this.command, e.getKey());
            }
        }
        return result;
    }

    protected abstract ImapMessage decode(ImapCommand var1, ImapRequestLineReader var2, String var3, ImapSession var4) throws DecodingException;
}

