/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec;

import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.james.crowdsec.client.CrowdsecClientConfiguration;
import org.apache.james.crowdsec.client.CrowdsecHttpClient;
import org.apache.james.crowdsec.model.CrowdsecDecision;
import reactor.core.publisher.Mono;

class CrowdsecService {
    private final CrowdsecHttpClient crowdsecHttpClient;

    @Inject
    public CrowdsecService(CrowdsecClientConfiguration configuration) {
        this.crowdsecHttpClient = new CrowdsecHttpClient(configuration);
    }

    public Mono<List<CrowdsecDecision>> findBanDecisions(InetSocketAddress remoteAddress) {
        return this.crowdsecHttpClient.getCrowdsecDecisions().map(decisions -> decisions.stream().filter(decision -> this.isBanned((CrowdsecDecision)decision, remoteAddress.getAddress().getHostAddress())).collect(Collectors.toList()));
    }

    private boolean isBanned(CrowdsecDecision decision, String ip) {
        if (decision.getScope().equals("Ip") && ip.contains(decision.getValue())) {
            return true;
        }
        return decision.getScope().equals("Range") && this.belongsToNetwork(decision.getValue(), ip);
    }

    private boolean belongsToNetwork(String bannedRange, String ip) {
        SubnetUtils subnetUtils = new SubnetUtils(bannedRange);
        subnetUtils.setInclusiveHostCount(true);
        return subnetUtils.getInfo().isInRange(ip);
    }
}

