/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.james.crowdsec.CrowdsecService;
import org.apache.james.crowdsec.model.CrowdsecDecision;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdsecSMTPConnectHandler
implements ConnectHandler<SMTPSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrowdsecSMTPConnectHandler.class);
    public static final Response NOOP = new Response(){

        public String getRetCode() {
            return "";
        }

        public List<CharSequence> getLines() {
            return Collections.emptyList();
        }

        public boolean isEndSession() {
            return false;
        }
    };
    private final CrowdsecService crowdsecService;

    @Inject
    public CrowdsecSMTPConnectHandler(CrowdsecService service) {
        this.crowdsecService = service;
    }

    public Response onConnect(SMTPSession session) {
        String ip = session.getRemoteAddress().getAddress().getHostAddress();
        return (Response)this.crowdsecService.findBanDecisions(session.getRemoteAddress()).map(decisions -> {
            if (!decisions.isEmpty()) {
                decisions.forEach(d -> this.logBanned((CrowdsecDecision)d, ip));
                return Response.DISCONNECT;
            }
            return NOOP;
        }).block();
    }

    private boolean logBanned(CrowdsecDecision decision, String ip) {
        if (decision.getScope().equals("Ip")) {
            LOGGER.info("Ip {} is banned by crowdsec for {}. Full decision was {} ", new Object[]{decision.getValue(), decision.getDuration(), decision});
            return true;
        }
        if (decision.getScope().equals("Range")) {
            LOGGER.info("Ip {} belongs to range {} banned by crowdsec for {}. Full decision was {} ", new Object[]{ip, decision.getValue(), decision.getDuration(), decision});
            return true;
        }
        return false;
    }
}

