/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec;

import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import org.apache.james.crowdsec.CrowdsecUtils;
import org.apache.james.crowdsec.client.CrowdsecClientConfiguration;
import org.apache.james.crowdsec.client.CrowdsecHttpClient;
import org.apache.james.crowdsec.exception.CrowdsecException;
import org.apache.james.imap.api.ConnectionCheck;
import org.reactivestreams.Publisher;

public class CrowdsecImapConnectionCheck
implements ConnectionCheck {
    private final CrowdsecHttpClient client;

    @Inject
    public CrowdsecImapConnectionCheck(CrowdsecClientConfiguration crowdsecClientConfiguration) {
        this.client = new CrowdsecHttpClient(crowdsecClientConfiguration);
    }

    public Publisher<Void> validate(InetSocketAddress remoteAddress) {
        String ip = remoteAddress.getAddress().getHostAddress();
        return this.client.getCrowdsecDecisions().filter(decisions -> decisions.stream().anyMatch(decision -> CrowdsecUtils.isBanned(decision, ip))).handle((crowdsecDecisions, synchronousSink) -> synchronousSink.error((Throwable)new CrowdsecException("Ip " + ip + " is not allowed to connect to IMAP server by Crowdsec")));
    }
}

