/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.crowdsec.CrowdsecService;
import org.apache.james.crowdsec.client.CrowdsecClientConfiguration;
import org.apache.james.crowdsec.model.CrowdsecDecision;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;

public class CrowdsecEhloHook
implements HeloHook {
    private final CrowdsecService crowdsecService;

    @Inject
    public CrowdsecEhloHook(CrowdsecClientConfiguration configuration) {
        this.crowdsecService = new CrowdsecService(configuration);
    }

    public HookResult doHelo(SMTPSession session, String helo) {
        return (HookResult)this.crowdsecService.findBanDecisions(session.getRemoteAddress()).map(this::apply).block();
    }

    private HookResult apply(List<CrowdsecDecision> decisions) {
        return decisions.stream().findFirst().map(banned -> HookResult.DENY).orElse(HookResult.DECLINED);
    }
}

