/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.impl.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorException;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.util.NodeContextImpl;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorDocViewParserHandler
implements DocViewParserHandler {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull Integer> nodePathsAndLineNumbers = new HashMap<String, Integer>();
    @NotNull
    private final Path filePath;
    @NotNull
    private final Path basePath;
    private final Map<String, DocumentViewXmlValidator> validators;
    @NotNull
    private final List<ValidationViolation> violations;
    @NotNull
    private final ValidationMessageSeverity severity;
    private final ValueFactory valueFactory;
    private NameResolver nameResolver;
    public static final String MESSAGE_INVALID_STRING_SERIALIZATION = "Invalid string serialization for type '%s' given in property '%s' : '%s'. This string cannot be converted to the specified type!";
    private static final Logger log = LoggerFactory.getLogger(ValidatorDocViewParserHandler.class);

    public ValidatorDocViewParserHandler(@NotNull ValidationMessageSeverity severity, @NotNull Map<String, DocumentViewXmlValidator> docViewValidators, @NotNull Path filePath, @NotNull Path basePath) {
        this.filePath = filePath;
        this.basePath = basePath;
        this.validators = docViewValidators;
        this.violations = new LinkedList<ValidationViolation>();
        this.valueFactory = new SimpleValueFactory();
        this.severity = severity;
    }

    public void setNameResolver(NameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int lineNumber, int columnNumber) throws IOException, RepositoryException {
        this.validatePropertyValues(docViewNode.getProperties(), nodePath, lineNumber, columnNumber);
        this.callValidators(true, nodePath, docViewNode, parentDocViewNode, lineNumber, columnNumber);
        if (!docViewNode.getProperties().isEmpty()) {
            this.nodePathsAndLineNumbers.put(nodePath, lineNumber);
        }
    }

    public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int lineNumber, int columnNumber) throws IOException, RepositoryException {
        this.callValidators(false, nodePath, docViewNode, parentDocViewNode, lineNumber, columnNumber);
    }

    @NotNull
    public Map<String, Integer> getNodePaths() {
        return this.nodePathsAndLineNumbers;
    }

    @NotNull
    public List<ValidationViolation> getViolations() {
        return this.violations;
    }

    private void validatePropertyValues(Collection<DocViewProperty2> properties, String nodePath, int lineNumber, int columnNumber) {
        for (DocViewProperty2 property : properties) {
            if (property.getType() == 0) continue;
            for (String value : property.getStringValues()) {
                try {
                    this.valueFactory.createValue(value, property.getType());
                }
                catch (ValueFormatException e) {
                    String message;
                    try {
                        message = String.format(MESSAGE_INVALID_STRING_SERIALIZATION, PropertyType.nameFromValue((int)property.getType()), this.nameResolver.getJCRName(property.getName()), value);
                    }
                    catch (NamespaceException e1) {
                        message = String.format(MESSAGE_INVALID_STRING_SERIALIZATION, PropertyType.nameFromValue((int)property.getType()), property.getName(), value);
                    }
                    this.violations.add(new ValidationViolation("jackrabbit-docviewparser", this.severity, message, this.filePath, this.basePath, nodePath, lineNumber, columnNumber, null));
                }
            }
        }
    }

    private void callValidators(boolean isStart, String nodePath, DocViewNode2 docViewNode, Optional<DocViewNode2> parentDocViewNode, int lineNumber, int columnNumber) {
        this.violations.add(new ValidationViolation(ValidationMessageSeverity.DEBUG, "Validate node '" + docViewNode + "' " + (isStart ? "start" : "end")));
        for (Map.Entry<String, DocumentViewXmlValidator> entry : this.validators.entrySet()) {
            try {
                Collection<ValidationMessage> messages = isStart ? entry.getValue().validate(docViewNode, (NodeContext)new NodeContextImpl(nodePath, this.filePath, this.basePath, lineNumber, columnNumber, this::getJcrName), !parentDocViewNode.isPresent()) : entry.getValue().validateEnd(docViewNode, (NodeContext)new NodeContextImpl(nodePath, this.filePath, this.basePath, lineNumber, columnNumber, this::getJcrName), !parentDocViewNode.isPresent());
                if (messages == null || messages.isEmpty()) continue;
                this.violations.addAll(ValidationViolation.wrapMessages(entry.getKey(), messages, this.filePath, null, nodePath, lineNumber, columnNumber));
            }
            catch (RuntimeException e) {
                throw new ValidatorException(entry.getKey(), e, this.filePath, lineNumber, columnNumber, e);
            }
        }
    }

    private String getJcrName(Name name) {
        try {
            return this.nameResolver.getJCRName(name);
        }
        catch (NamespaceException e) {
            log.debug("Could not get qualified name for {}, falling back to expanded name", (Object)name, (Object)e);
            return name.toString();
        }
    }
}

