/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.impl.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorException;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.util.NodeContextImpl;
import org.jetbrains.annotations.NotNull;

public class ValidatorDocViewParserHandler
implements DocViewParserHandler {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull Integer> nodePathsAndLineNumbers = new HashMap<String, Integer>();
    @NotNull
    private final Path filePath;
    @NotNull
    private final Path basePath;
    private final Map<String, DocumentViewXmlValidator> validators;
    @NotNull
    private final List<ValidationViolation> violations;

    public ValidatorDocViewParserHandler(Map<String, DocumentViewXmlValidator> docViewValidators, @NotNull Path filePath, @NotNull Path basePath) {
        this.filePath = filePath;
        this.basePath = basePath;
        this.validators = docViewValidators;
        this.violations = new LinkedList<ValidationViolation>();
    }

    public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int lineNumber, int columnNumber) throws IOException, RepositoryException {
        this.callValidators(true, nodePath, docViewNode, parentDocViewNode, lineNumber, columnNumber);
        if (!docViewNode.getProperties().isEmpty()) {
            this.nodePathsAndLineNumbers.put(nodePath, lineNumber);
        }
    }

    public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int lineNumber, int columnNumber) throws IOException, RepositoryException {
        this.callValidators(false, nodePath, docViewNode, parentDocViewNode, lineNumber, columnNumber);
    }

    @NotNull
    public Map<String, Integer> getNodePaths() {
        return this.nodePathsAndLineNumbers;
    }

    @NotNull
    public List<ValidationViolation> getViolations() {
        return this.violations;
    }

    private void callValidators(boolean isStart, String nodePath, DocViewNode2 docViewNode, Optional<DocViewNode2> parentDocViewNode, int lineNumber, int columnNumber) {
        this.violations.add(new ValidationViolation(ValidationMessageSeverity.DEBUG, "Validate node '" + docViewNode + "' " + (isStart ? "start" : "end")));
        for (Map.Entry<String, DocumentViewXmlValidator> entry : this.validators.entrySet()) {
            try {
                Collection<ValidationMessage> messages = isStart ? entry.getValue().validate(docViewNode, (NodeContext)new NodeContextImpl(nodePath, this.filePath, this.basePath), !parentDocViewNode.isPresent()) : entry.getValue().validateEnd(docViewNode, (NodeContext)new NodeContextImpl(nodePath, this.filePath, this.basePath), !parentDocViewNode.isPresent());
                if (messages == null || messages.isEmpty()) continue;
                this.violations.addAll(ValidationViolation.wrapMessages(entry.getKey(), messages, this.filePath, null, nodePath, lineNumber, columnNumber));
            }
            catch (RuntimeException e) {
                throw new ValidatorException(entry.getKey(), e, this.filePath, lineNumber, columnNumber, e);
            }
        }
    }
}

