/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.JcrNodeTypeMetaData;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NamespaceExceptionInNodeName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JcrNodeTypeMetaDataImpl
implements JcrNodeTypeMetaData {
    static final String EXCEPTION_MESSAGE_INVALID_NAME = "Invalid %s '%s': %s";
    static final String CONSTRAINT_PROPERTY_VALUE = "Value constraint violation: %s";
    static final String CONSTRAINT_PROPERTY_PROTECTED = "Property is protected!";
    static final String CONSTRAINT_PROPERTY_AUTO_CREATED = "Property is auto-created and can not be manually added";
    static final String CONSTRAINT_PROPERTY_NOT_ALLOWED = "No applicable property definition found for name and type!";
    static final String CONSTRAINT_CHILD_NODE_AUTO_CREATED = "Node is auto-created and can not be manually added";
    static final String CONSTRAINT_CHILD_NODE_PROTECTED = "Node is protected and can not be manually added";
    static final String CONSTRAINT_MIXIN_TYPE_AS_PRIMARY_TYPE = "Given node type is a mixin and cannot be used as primary node type.";
    static final String CONSTRAINT_ABSTRACT_TYPE_AS_PRIMARY_TYPE = "Given node type is abstract and cannot be used as primary node type.";
    static final String CONSTRAINT_CHILD_NODE_NOT_ALLOWED = "Node type does not allow arbitrary child nodes and does not allow this specific name and node type either!";
    static final String MESSAGE_CHILD_NODE_NOT_ALLOWED = "Node '%s [%s]' is not allowed as child of node with %s: %s";
    static final String MESSAGE_PROPERTY_NOT_ALLOWED = "Property '%s' [%s] is not allowed in node with %s: %s";
    static final String MESSAGE_MANDATORY_CHILD_NODE_MISSING = "Mandatory child node missing: %s inside node with %s";
    static final String MESSAGE_MANDATORY_UNCONTAINED_CHILD_NODE_MISSING = "Mandatory child node missing: %s inside node with types [%s] (outside of filter rules)";
    static final String MESSAGE_MANDATORY_PROPERTY_MISSING = "Mandatory property '%s' missing in node with %s";
    static final String MESSAGE_MANDATORY_PROPERTY_WITH_WRONG_TYPE = "Mandatory property '%s' has type '%s' while it should have '%s' in node with %s";
    private static final Collection<Name> JCR_SYSTEM_PROPERTIES = Arrays.asList(NameConstants.JCR_PRIMARYTYPE, NameConstants.JCR_MIXINTYPES, NameConstants.JCR_UUID, NameConstants.JCR_BASEVERSION, NameConstants.JCR_PREDECESSORS, NameConstants.JCR_SUCCESSORS, NameConstants.JCR_VERSIONHISTORY, NameConstants.JCR_ISCHECKEDOUT, NameFactoryImpl.getInstance().create("http://jackrabbit.apache.org/oak/ns/1.0", "counter"));
    private static final Name NT_REP_POLICY = NameFactoryImpl.getInstance().create("internal", "Policy");
    private static final Name NT_REP_AUTHORIZABLE = NameFactoryImpl.getInstance().create("internal", "Authorizable");
    private static final QValueFactory QVALUE_FACTORY = QValueFactoryImpl.getInstance();
    @NotNull
    private final Name name;
    @NotNull
    private final NodeContext context;
    @Nullable
    private Name primaryNodeType;
    @Nullable
    private EffectiveNodeType effectiveNodeType;
    @NotNull
    private final Map<Name, Integer> propertyTypesByName;
    @NotNull
    private final Map<Name, JcrNodeTypeMetaDataImpl> childNodesByName;
    @Nullable
    private final JcrNodeTypeMetaDataImpl parentNode;
    private boolean isAuthenticationOrAuthorizationContext;
    private final boolean isImplicit;
    private boolean isValidationDone;
    private final boolean isIncremental;

    private JcrNodeTypeMetaDataImpl(boolean isIncremental, @NotNull NodeContext context, @NotNull Name name, @Nullable Name primaryNodeType, @Nullable EffectiveNodeType effectiveNodeType, JcrNodeTypeMetaDataImpl parentNode, boolean isAuthenticationOrAuthorizationContext, boolean isImplicit) {
        this.context = context;
        this.name = name;
        this.primaryNodeType = primaryNodeType;
        this.effectiveNodeType = effectiveNodeType;
        this.parentNode = parentNode;
        this.propertyTypesByName = new HashMap<Name, Integer>();
        this.childNodesByName = new HashMap<Name, JcrNodeTypeMetaDataImpl>();
        this.isAuthenticationOrAuthorizationContext = isAuthenticationOrAuthorizationContext;
        this.isImplicit = isImplicit;
        this.isValidationDone = false;
        this.isIncremental = isIncremental;
    }

    public String toString() {
        return "JcrNodeTypeMetaDataImpl [name=" + this.name + ", effectiveNodeType=" + this.effectiveNodeType + ", propertyTypesByName=" + this.propertyTypesByName + ", childNodes=" + this.childNodesByName.keySet() + ", isAuthenticationOrAuthorizationContext=" + this.isAuthenticationOrAuthorizationContext + "]";
    }

    @Override
    public void setUnknownNodeTypes() {
        this.primaryNodeType = null;
        this.effectiveNodeType = null;
    }

    @Override
    public void setNodeTypes(@NotNull NameResolver nameResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, boolean isFallbackPrimaryType, @NotNull String primaryType, String ... mixinTypes) throws IllegalNameException, ConstraintViolationException, NoSuchNodeTypeException, NamespaceException {
        List<Name> types = JcrNodeTypeMetaDataImpl.getTypes(nameResolver, primaryType, mixinTypes);
        if (this.effectiveNodeType == null || !isFallbackPrimaryType && !this.effectiveNodeType.includesNodeTypes(types.toArray(new Name[0]))) {
            this.primaryNodeType = types.get(0);
            this.effectiveNodeType = effectiveNodeTypeProvider.getEffectiveNodeType(types.toArray(new Name[0]));
            if (!this.isAuthenticationOrAuthorizationContext) {
                this.isAuthenticationOrAuthorizationContext = JcrNodeTypeMetaDataImpl.isAclOrAuthorizableNodeType(this.effectiveNodeType);
            }
        }
    }

    @Override
    public Name getPrimaryNodeType() {
        return this.primaryNodeType;
    }

    private static boolean isAclOrAuthorizableNodeType(EffectiveNodeType effectiveNodeType) {
        return effectiveNodeType.includesNodeType(NT_REP_AUTHORIZABLE) || effectiveNodeType.includesNodeType(NT_REP_POLICY);
    }

    @NotNull
    private static Name getQName(@NotNull NameResolver nameResolver, @NotNull String name, @NotNull NameType type) throws IllegalNameException, NamespaceException {
        try {
            Name qName = nameResolver.getQName(name);
            if (type != NameType.NODE_NAME && qName.getNamespaceURI().startsWith("http://unknown.prefix.")) {
                int posColon = name.indexOf(58);
                String prefix = name.substring(0, posColon);
                throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
            }
            return qName;
        }
        catch (NamespaceException e) {
            if (type == NameType.NODE_NAME) {
                throw new NamespaceExceptionInNodeName(String.format(EXCEPTION_MESSAGE_INVALID_NAME, type.getLabel(), name, e.getLocalizedMessage()), e);
            }
            throw new NamespaceException(String.format(EXCEPTION_MESSAGE_INVALID_NAME, type.getLabel(), name, e.getLocalizedMessage()), (Throwable)e);
        }
        catch (IllegalNameException e) {
            throw new IllegalNameException(String.format(EXCEPTION_MESSAGE_INVALID_NAME, type.getLabel(), name, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public JcrNodeTypeMetaData addImplicitChildNode(@NotNull NameResolver nameResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, @NotNull NodeContext nodeContext, @Nullable Name implicitNodeType) throws RepositoryException {
        JcrNodeTypeMetaDataImpl childNode = this.addChildNode(nameResolver, effectiveNodeTypeProvider, nodeTypeDefinitionProvider, itemDefinitionProvider, true, nodeContext, Text.getName((String)nodeContext.getNodePath()), implicitNodeType);
        return childNode;
    }

    @Override
    @NotNull
    public JcrNodeTypeMetaData addUnknownChildNode(@NotNull NameResolver nameResolver, @NotNull NodeContext context, @NotNull String name) throws IllegalNameException, NamespaceException {
        return this.addUnknownChildNode(context, JcrNodeTypeMetaDataImpl.getQName(nameResolver, name, NameType.NODE_NAME));
    }

    @NotNull
    private JcrNodeTypeMetaDataImpl addUnknownChildNode(@NotNull NodeContext context, @NotNull Name name) throws IllegalNameException {
        JcrNodeTypeMetaDataImpl childNode = new JcrNodeTypeMetaDataImpl(this.isIncremental, context, name, null, null, this, false, false);
        this.childNodesByName.put(name, childNode);
        return childNode;
    }

    @Override
    @NotNull
    public JcrNodeTypeMetaData addChildNode(@NotNull NameResolver nameResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, @NotNull NodeContext nodeContext, @NotNull String primaryType, String ... mixinTypes) throws IllegalNameException, RepositoryException, NamespaceExceptionInNodeName {
        List<Name> types = JcrNodeTypeMetaDataImpl.getTypes(nameResolver, primaryType, mixinTypes);
        String nodeName = Text.getName((String)nodeContext.getNodePath());
        JcrNodeTypeMetaDataImpl childNode = this.addChildNode(nameResolver, effectiveNodeTypeProvider, nodeTypeDefinitionProvider, itemDefinitionProvider, false, nodeContext, nodeName, types.toArray(new Name[0]));
        return childNode;
    }

    private static List<Name> getTypes(@NotNull NameResolver nameResolver, @NotNull String primaryType, String ... mixinTypes) throws IllegalNameException, NamespaceException {
        ArrayList<Name> types = new ArrayList<Name>();
        types.add(JcrNodeTypeMetaDataImpl.getQName(nameResolver, primaryType, NameType.PRIMARY_TYPE));
        if (mixinTypes != null) {
            for (String mixinType : mixinTypes) {
                types.add(JcrNodeTypeMetaDataImpl.getQName(nameResolver, mixinType, NameType.MIXIN_TYPE));
            }
        }
        return types;
    }

    @NotNull
    private JcrNodeTypeMetaDataImpl addChildNode(@NotNull NameResolver nameResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, boolean isImplicit, @NotNull NodeContext context, @NotNull String name, Name ... nodeTypes) throws ConstraintViolationException, NoSuchNodeTypeException, NamespaceExceptionInNodeName, NamespaceException, IllegalNameException {
        Name newPrimaryNodeType;
        EffectiveNodeType newEffectiveNodeType;
        Name qName = JcrNodeTypeMetaDataImpl.getQName(nameResolver, name, NameType.NODE_NAME);
        boolean isAuthenticationOrAuthorizationContext = false;
        if (nodeTypes != null) {
            newEffectiveNodeType = effectiveNodeTypeProvider.getEffectiveNodeType(nodeTypes);
            newPrimaryNodeType = nodeTypes[0];
            isAuthenticationOrAuthorizationContext = JcrNodeTypeMetaDataImpl.isAclOrAuthorizableNodeType(newEffectiveNodeType);
        } else {
            newEffectiveNodeType = null;
            newPrimaryNodeType = null;
        }
        if (!isAuthenticationOrAuthorizationContext) {
            isAuthenticationOrAuthorizationContext = this.isAuthenticationOrAuthorizationContext;
        }
        JcrNodeTypeMetaDataImpl newNode = new JcrNodeTypeMetaDataImpl(this.isIncremental, context, qName, newPrimaryNodeType, newEffectiveNodeType, this, isAuthenticationOrAuthorizationContext, isImplicit);
        this.childNodesByName.put(qName, newNode);
        return newNode;
    }

    private Optional<String> validateAgainstParentNodeType(@NotNull EffectiveNodeType parentEffectiveNodeType, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider) throws RepositoryException {
        if (this.effectiveNodeType == null || this.primaryNodeType == null) {
            return Optional.empty();
        }
        if (this.effectiveNodeType.includesNodeType(NT_REP_POLICY)) {
            return Optional.empty();
        }
        QNodeTypeDefinition primaryNodeTypeDefinition = nodeTypeDefinitionProvider.getNodeTypeDefinition(this.primaryNodeType);
        if (primaryNodeTypeDefinition.isAbstract()) {
            return Optional.of(CONSTRAINT_ABSTRACT_TYPE_AS_PRIMARY_TYPE);
        }
        if (primaryNodeTypeDefinition.isMixin()) {
            return Optional.of(CONSTRAINT_MIXIN_TYPE_AS_PRIMARY_TYPE);
        }
        try {
            QNodeDefinition applicableParentNodeDefinition = itemDefinitionProvider.getQNodeDefinition(parentEffectiveNodeType, this.name, this.primaryNodeType);
            if (!this.isAuthenticationOrAuthorizationContext && applicableParentNodeDefinition.isProtected()) {
                return Optional.of(CONSTRAINT_CHILD_NODE_PROTECTED);
            }
            if (applicableParentNodeDefinition.isAutoCreated()) {
                return Optional.of(CONSTRAINT_CHILD_NODE_AUTO_CREATED);
            }
        }
        catch (ConstraintViolationException e) {
            return Optional.of(CONSTRAINT_CHILD_NODE_NOT_ALLOWED);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Collection<ValidationMessage> finalizeValidation(@NotNull NamePathResolver namePathResolver, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, @NotNull ValidationMessageSeverity severity, @NotNull ValidationMessageSeverity severityForDefaultNodeTypeViolations, @NotNull WorkspaceFilter filter) throws NamespaceException {
        if (!this.isValidationDone) {
            LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
            if (!this.isIncremental) {
                messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Validate children and mandatory properties of " + this.getQualifiedPath(namePathResolver)));
                messages.addAll(this.validateChildNodes(namePathResolver, nodeTypeDefinitionProvider, itemDefinitionProvider, severity, severityForDefaultNodeTypeViolations, filter));
                messages.addAll(this.validateMandatoryProperties(namePathResolver, severity, severityForDefaultNodeTypeViolations));
            }
            this.childNodesByName.clear();
            this.isValidationDone = true;
            messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Remove node information of children of " + this.getQualifiedPath(namePathResolver)));
            return messages;
        }
        return Collections.singletonList(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Already finalized validation of " + this.getQualifiedPath(namePathResolver)));
    }

    private Collection<ValidationMessage> validateChildNodes(@NotNull NamePathResolver namePathResolver, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, @NotNull ValidationMessageSeverity severity, @NotNull ValidationMessageSeverity severityForDefaultNodeTypeViolations, @NotNull WorkspaceFilter filter) {
        if (this.effectiveNodeType == null) {
            return Collections.emptyList();
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        for (JcrNodeTypeMetaDataImpl childNode : this.childNodesByName.values()) {
            try {
                Optional<String> constraintViolation = childNode.validateAgainstParentNodeType(this.effectiveNodeType, nodeTypeDefinitionProvider, itemDefinitionProvider);
                if (!constraintViolation.isPresent()) continue;
                messages.add(new ValidationMessage(this.isImplicit ? severityForDefaultNodeTypeViolations : severity, String.format(MESSAGE_CHILD_NODE_NOT_ALLOWED, namePathResolver.getJCRName(childNode.name), namePathResolver.getJCRName(childNode.primaryNodeType), this.getEffectiveNodeTypeLabel((NameResolver)namePathResolver, this.effectiveNodeType), constraintViolation.get()), childNode.context));
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Could not validate child node " + childNode.name + " against parent node definition", e);
            }
        }
        for (QNodeDefinition mandatoryNodeType : this.effectiveNodeType.getMandatoryQNodeDefinitions()) {
            if (mandatoryNodeType.isAutoCreated()) continue;
            boolean foundRequiredChildNode = false;
            for (JcrNodeTypeMetaDataImpl child : this.childNodesByName.values()) {
                foundRequiredChildNode = child.fulfillsNodeDefinition(mandatoryNodeType);
            }
            if (foundRequiredChildNode || mandatoryNodeType.getName().equals(NameConstants.ANY_NAME)) continue;
            PathBuilder pathBuilder = new PathBuilder(this.getPath());
            pathBuilder.addLast(mandatoryNodeType.getName());
            try {
                if (filter.contains(namePathResolver.getJCRPath(pathBuilder.getPath()))) {
                    messages.add(new ValidationMessage(this.isImplicit ? severityForDefaultNodeTypeViolations : severity, String.format(MESSAGE_MANDATORY_CHILD_NODE_MISSING, JcrNodeTypeMetaDataImpl.getNodeDefinitionLabel((NameResolver)namePathResolver, mandatoryNodeType), this.getEffectiveNodeTypeLabel((NameResolver)namePathResolver, this.effectiveNodeType))));
                    continue;
                }
                messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, String.format(MESSAGE_MANDATORY_UNCONTAINED_CHILD_NODE_MISSING, JcrNodeTypeMetaDataImpl.getNodeDefinitionLabel((NameResolver)namePathResolver, mandatoryNodeType), this.getEffectiveNodeTypeLabel((NameResolver)namePathResolver, this.effectiveNodeType)), this.context));
            }
            catch (NamespaceException | MalformedPathException e) {
                throw new IllegalStateException("Could not give out node types and name for " + mandatoryNodeType, e);
            }
        }
        return messages;
    }

    private String getEffectiveNodeTypeLabel(NameResolver nameResolver, EffectiveNodeType nodeType) throws NamespaceException {
        String types = JcrNodeTypeMetaDataImpl.joinAsQualifiedJcrName(nameResolver, nodeType.getMergedNodeTypes());
        String label = this.isImplicit ? String.format("potential default types [%s]", types) : String.format("types [%s]", types);
        return label;
    }

    private static String getNodeDefinitionLabel(NameResolver nameResolver, QNodeDefinition nodeDefinition) throws NamespaceException {
        return nameResolver.getJCRName(nodeDefinition.getName()) + " [" + JcrNodeTypeMetaDataImpl.joinAsQualifiedJcrName(nameResolver, nodeDefinition.getRequiredPrimaryTypes()) + "]";
    }

    private static String joinAsQualifiedJcrName(NameResolver nameResolver, Name[] names) throws NamespaceException {
        StringBuilder types = new StringBuilder();
        String delimiter = "";
        for (Name name : names) {
            types.append(delimiter).append(nameResolver.getJCRName(name));
            delimiter = ", ";
        }
        return types.toString();
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull ? extends JcrNodeTypeMetaData> getChildren() {
        return this.childNodesByName.values();
    }

    @Override
    @NotNull
    public JcrNodeTypeMetaData getOrCreateNode(NamePathResolver nameResolver, @NotNull NodeContext nodeContext, String path) throws RepositoryException {
        return this.getNode(nameResolver, nodeContext, path, true).get();
    }

    @Override
    public Optional<JcrNodeTypeMetaData> getNode(NamePathResolver nameResolver, String path) throws RepositoryException {
        return this.getNode(nameResolver, null, path, false);
    }

    private Optional<JcrNodeTypeMetaData> getNode(NamePathResolver nameResolver, @Nullable NodeContext nodeContext, String path, boolean shouldCreateIfMissing) throws RepositoryException {
        Path qPath = nameResolver.getQPath(path);
        Path qRelativePath = this.getPath().computeRelativePath(qPath);
        JcrNodeTypeMetaDataImpl currentNode = this;
        for (Path.Element element : qRelativePath.getElements()) {
            if (!element.denotesParent()) break;
            currentNode = currentNode.parentNode;
        }
        qRelativePath = currentNode.getPath().computeRelativePath(qPath);
        for (Path.Element element : qRelativePath.getElements()) {
            if (element.denotesCurrent()) continue;
            JcrNodeTypeMetaDataImpl childNode = currentNode.childNodesByName.get(element.getName());
            if (childNode == null) {
                if (shouldCreateIfMissing) {
                    if (nodeContext == null) {
                        throw new IllegalArgumentException("Node context must be given in case node is created but is null");
                    }
                    childNode = currentNode.addUnknownChildNode(nodeContext, element.getName());
                } else {
                    return Optional.empty();
                }
            }
            currentNode = childNode;
        }
        return Optional.of(currentNode);
    }

    private Collection<ValidationMessage> validateMandatoryProperties(@NotNull NamePathResolver nameResolver, @NotNull ValidationMessageSeverity severity, @NotNull ValidationMessageSeverity severityForDefaultNodeTypeViolations) {
        if (this.effectiveNodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (QPropertyDefinition mandatoryPropertyDefinition : this.effectiveNodeType.getMandatoryQPropertyDefinitions()) {
            if (mandatoryPropertyDefinition.isAutoCreated() || JCR_SYSTEM_PROPERTIES.contains(mandatoryPropertyDefinition.getName())) continue;
            try {
                if (!this.propertyTypesByName.containsKey(mandatoryPropertyDefinition.getName())) {
                    messages.add(new ValidationMessage(this.isImplicit ? severityForDefaultNodeTypeViolations : severity, String.format(MESSAGE_MANDATORY_PROPERTY_MISSING, nameResolver.getJCRName(mandatoryPropertyDefinition.getName()), this.getEffectiveNodeTypeLabel((NameResolver)nameResolver, this.effectiveNodeType)), this.context));
                    continue;
                }
                int actualPropertyType = this.propertyTypesByName.get(mandatoryPropertyDefinition.getName());
                if (mandatoryPropertyDefinition.getRequiredType() == actualPropertyType) continue;
                messages.add(new ValidationMessage(this.isImplicit ? severityForDefaultNodeTypeViolations : severity, String.format(MESSAGE_MANDATORY_PROPERTY_WITH_WRONG_TYPE, nameResolver.getJCRName(mandatoryPropertyDefinition.getName()), PropertyType.nameFromValue((int)actualPropertyType), PropertyType.nameFromValue((int)mandatoryPropertyDefinition.getRequiredType()), this.getEffectiveNodeTypeLabel((NameResolver)nameResolver, this.effectiveNodeType)), this.context));
            }
            catch (NamespaceException e) {
                throw new IllegalStateException("Could not give out parent node types or property names for " + mandatoryPropertyDefinition, e);
            }
        }
        return messages;
    }

    @Override
    public Collection<ValidationMessage> addProperty(@NotNull NodeContext nodeContext, @NotNull NamePathResolver namePathResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, @NotNull ValidationMessageSeverity severity, @NotNull ValidationMessageSeverity severityForDefaultNodeTypeViolations, String name, boolean isMultiValue, Value ... values) throws RepositoryException {
        Name qName;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!isMultiValue && values.length > 1) {
            throw new IllegalArgumentException("isMultiValue is only supposed to be false if exactly one value is passed but " + values.length + " values were passed!");
        }
        if (values.length == 0) {
            return messages;
        }
        try {
            qName = namePathResolver.getQName(name);
        }
        catch (NamespaceException | IllegalNameException e) {
            throw new IllegalNameException("Invalid property name " + name, e);
        }
        this.propertyTypesByName.put(qName, values[0].getType());
        Optional<String> constraintViolation = this.validatePropertyConstraints(namePathResolver, effectiveNodeTypeProvider, nodeTypeDefinitionProvider, itemDefinitionProvider, qName, values, this.isAuthenticationOrAuthorizationContext, isMultiValue);
        if (constraintViolation.isPresent()) {
            messages.add(new ValidationMessage(this.isImplicit ? severityForDefaultNodeTypeViolations : severity, String.format(MESSAGE_PROPERTY_NOT_ALLOWED, namePathResolver.getJCRName(qName), PropertyType.nameFromValue((int)values[0].getType()), this.getEffectiveNodeTypeLabel((NameResolver)namePathResolver, this.effectiveNodeType), constraintViolation.get()), nodeContext));
        }
        return messages;
    }

    @NotNull
    private Optional<String> validatePropertyConstraints(@NotNull NamePathResolver namePathResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull NodeTypeDefinitionProvider nodeTypeDefinitionProvider, @NotNull ItemDefinitionProvider itemDefinitionProvider, Name name, Value[] values, boolean allowProtected, boolean isMultiValue) throws RepositoryException {
        QPropertyDefinition applicablePropertyDefinition;
        if (this.effectiveNodeType == null) {
            return Optional.empty();
        }
        try {
            applicablePropertyDefinition = JcrNodeTypeMetaDataImpl.getPropertyDefinition(name, values[0].getType(), this.effectiveNodeType, itemDefinitionProvider, isMultiValue);
        }
        catch (ConstraintViolationException t) {
            return Optional.of(CONSTRAINT_PROPERTY_NOT_ALLOWED);
        }
        if (applicablePropertyDefinition.isProtected() && !allowProtected && !JCR_SYSTEM_PROPERTIES.contains(name)) {
            return Optional.of(CONSTRAINT_PROPERTY_PROTECTED);
        }
        for (Value value : values) {
            try {
                QValue qValue = ValueFormat.getQValue((Value)value, (NamePathResolver)namePathResolver, (QValueFactory)QVALUE_FACTORY);
                ValueConstraint.checkValueConstraints((QPropertyDefinition)applicablePropertyDefinition, (QValue[])new QValue[]{qValue});
            }
            catch (ConstraintViolationException e) {
                return Optional.of(String.format(CONSTRAINT_PROPERTY_VALUE, e.getLocalizedMessage()));
            }
        }
        return Optional.empty();
    }

    private static QPropertyDefinition getPropertyDefinition(Name name, int type, EffectiveNodeType effectiveNodeType, ItemDefinitionProvider itemDefinitionProvider, boolean isMultiValue) throws NoSuchNodeTypeException, ConstraintViolationException {
        QPropertyDefinition def;
        try {
            def = itemDefinitionProvider.getQPropertyDefinition(effectiveNodeType.getAllNodeTypes(), name, type, isMultiValue);
        }
        catch (ConstraintViolationException e) {
            if (type != 0) {
                def = itemDefinitionProvider.getQPropertyDefinition(effectiveNodeType.getAllNodeTypes(), name, 0, isMultiValue);
            }
            throw e;
        }
        return def;
    }

    private boolean fulfillsNodeDefinition(QNodeDefinition nodeDefinition) {
        if (!nodeDefinition.getName().equals(NameConstants.ANY_NAME) && !nodeDefinition.getName().equals(this.name)) {
            return false;
        }
        for (Name requiredType : nodeDefinition.getRequiredPrimaryTypes()) {
            if (this.effectiveNodeType.includesNodeType(requiredType)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static JcrNodeTypeMetaDataImpl createRoot(boolean isIncremental, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider) throws ConstraintViolationException, NoSuchNodeTypeException {
        return new JcrNodeTypeMetaDataImpl(isIncremental, new NodeContext(){

            @Override
            @NotNull
            public String getNodePath() {
                return "";
            }

            @Override
            @NotNull
            public @NotNull @NotNull java.nio.file.Path getFilePath() {
                return Paths.get("", new String[0]);
            }

            @Override
            public @NotNull java.nio.file.Path getBasePath() {
                return Paths.get("", new String[0]);
            }
        }, NameConstants.ROOT, NameConstants.REP_ROOT, effectiveNodeTypeProvider.getEffectiveNodeType(new Name[]{NameConstants.REP_ROOT, NameConstants.REP_ACCESS_CONTROLLABLE, NameConstants.REP_REPO_ACCESS_CONTROLLABLE}), null, false, false);
    }

    private Path getPath() {
        if (this.parentNode == null) {
            return PathFactoryImpl.getInstance().getRootPath();
        }
        PathBuilder pathBuilder = new PathBuilder(this.parentNode.getPath());
        pathBuilder.addLast(this.name);
        try {
            return pathBuilder.getPath();
        }
        catch (MalformedPathException e) {
            throw new IllegalStateException("Could not create path from parent and name", e);
        }
    }

    @Override
    public String getQualifiedPath(NamePathResolver resolver) throws NamespaceException {
        return resolver.getJCRPath(this.getPath());
    }

    private static enum NameType {
        NODE_NAME("node name"),
        PRIMARY_TYPE("primary type"),
        MIXIN_TYPE("mixin type");

        private final String label;

        private NameType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

