/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.impl.util;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorException;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.util.NodeContextImpl;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentViewXmlContentHandler
extends DefaultHandler
implements NamespaceResolver {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull Integer> nodePathsAndLineNumbers;
    private String rootNodeName;
    private String rootNodeParentPath;
    @NotNull
    private final Path filePath;
    @NotNull
    private final Path basePath;
    private Locator locator;
    private Deque<String> elementNameStack;
    private Deque<DocViewNode> nodeStack;
    private Deque<String> nodePathStack;
    private final Map<String, DocumentViewXmlValidator> validators;
    private final Map<String, String> namespaceRegistry;
    @NotNull
    private List<ValidationViolation> violations;
    public static final String PARSE_VIOLATION_MESSAGE_STRING = "Error while parsing element '%s': %s . Check all attribute values. They must stick to the grammar [ \"{\" type \"}\" ] ( value | \"[\" [ value { \",\" value } ] \"]\" while type is one of: String, Binary, Long, Double, Date, Boolean, Name, Path, Reference, WeakReference, URI, Decimal";

    @NotNull
    public List<ValidationViolation> getViolations() {
        return this.violations;
    }

    public DocumentViewXmlContentHandler(@NotNull Path filePath, @NotNull Path basePath, String rootNodePath, Map<String, DocumentViewXmlValidator> documentViewXmlValidators) {
        this.filePath = filePath;
        this.basePath = basePath;
        if (rootNodePath.equals("/")) {
            rootNodePath = "";
        }
        if (rootNodePath.endsWith("/")) {
            throw new IllegalArgumentException("rootPath must not end with \"/\" but is " + rootNodePath);
        }
        if (rootNodePath.contains("\\")) {
            throw new IllegalArgumentException("rootPath must not contain backslashes, only forward slashes should be used as separator!");
        }
        this.nodePathsAndLineNumbers = new HashMap<String, Integer>();
        this.rootNodeName = Text.getName((String)rootNodePath);
        this.rootNodeParentPath = Text.getRelativeParent((String)rootNodePath, (int)1);
        if (this.rootNodeParentPath.equals("/")) {
            this.rootNodeParentPath = "";
        }
        this.elementNameStack = new LinkedList<String>();
        this.nodeStack = new LinkedList<DocViewNode>();
        this.nodePathStack = new LinkedList<String>();
        this.validators = documentViewXmlValidators;
        this.violations = new LinkedList<ValidationViolation>();
        this.namespaceRegistry = new HashMap<String, String>();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceRegistry.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceRegistry.remove(prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        throw new UnsupportedOperationException("Only resolving from prefix to URI is supported, but not vice-versa");
    }

    public String getURI(String prefix) throws NamespaceException {
        if (prefix.isEmpty()) {
            return "";
        }
        return this.namespaceRegistry.get(prefix);
    }

    private Name getExpandedName(String name) throws IllegalNameException, NamespaceException {
        return NameParser.parse((String)name, (NamespaceResolver)this, (NameFactory)NameFactoryImpl.getInstance());
    }

    private String getNormalizedName(String name) {
        int idx = (name = ISO9075.decode((String)name)).lastIndexOf(91);
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        return name;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private DocViewNode getDocViewNode(Name name, String label, Attributes attributes) {
        HashMap<String, DocViewProperty> propertyMap = new HashMap<String, DocViewProperty>();
        String uuid = null;
        String primary = null;
        String[] mixins = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Name pName = NameFactoryImpl.getInstance().create(attributes.getURI(i), ISO9075.decode((String)attributes.getLocalName(i)));
            DocViewProperty property = DocViewProperty.parse((String)pName.toString(), (String)attributes.getValue(i));
            propertyMap.put(property.name, property);
            if (pName.equals(NameConstants.JCR_UUID)) {
                uuid = property.values[0];
                continue;
            }
            if (pName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                primary = property.values[0];
                continue;
            }
            if (!pName.equals(NameConstants.JCR_MIXINTYPES)) continue;
            mixins = property.values;
        }
        return new DocViewNode(name.toString(), label, uuid, propertyMap, mixins, primary);
    }

    @NotNull
    public Map<String, Integer> getNodePaths() {
        return this.nodePathsAndLineNumbers;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.nodeStack.isEmpty()) {
            return;
        }
        DocViewNode node = this.nodeStack.pop();
        this.elementNameStack.pop();
        String nodePath = this.nodePathStack.pop();
        if (node == null || nodePath == null) {
            throw new IllegalStateException("Seems that the XML is not well formed");
        }
        this.violations.add(new ValidationViolation(ValidationMessageSeverity.DEBUG, "Validate node '" + node + "' end"));
        for (Map.Entry<String, DocumentViewXmlValidator> entry : this.validators.entrySet()) {
            try {
                Collection<ValidationMessage> messages = entry.getValue().validateEnd(node, new NodeContextImpl(nodePath, this.filePath, this.basePath), this.elementNameStack.size() < 1);
                if (messages == null || messages.isEmpty()) continue;
                this.violations.addAll(ValidationViolation.wrapMessages(entry.getKey(), messages, this.filePath, null, nodePath.toString(), this.locator.getLineNumber(), this.locator.getColumnNumber()));
            }
            catch (RuntimeException e) {
                throw new ValidatorException(entry.getKey(), e, this.filePath, this.locator.getLineNumber(), this.locator.getColumnNumber(), e);
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

