/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrACLManagement;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessControlValidator
implements DocumentViewXmlValidator {
    protected static final JcrACLManagement ACL_MANAGEMENT = new JcrACLManagement();
    protected static final String MESSAGE_IGNORED_ACCESS_CONTROL_LIST = "Found an access control list, but it is never considered during installation as the property 'acHandling' is set to '%s'!";
    protected static final String MESSAGE_INEFFECTIVE_ACCESS_CONTROL_LIST = "Found no access control list, but there is supposed to be one contained as the property 'acHandling' is set to '%s'!";
    private final ValidationMessageSeverity severity;
    private final AccessControlHandling accessControlHandling;
    private boolean hasFoundACLNode;

    public AccessControlValidator(ValidationMessageSeverity severity, AccessControlHandling accessControlHandling) {
        this.severity = severity;
        this.accessControlHandling = accessControlHandling;
        this.hasFoundACLNode = false;
    }

    @Override
    public Collection<ValidationMessage> done() {
        if (!this.hasFoundACLNode && this.accessControlHandling != AccessControlHandling.IGNORE && this.accessControlHandling != AccessControlHandling.CLEAR) {
            return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_INEFFECTIVE_ACCESS_CONTROL_LIST, this.accessControlHandling)));
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        if (node.primary != null && ACL_MANAGEMENT.isACLNodeType(node.primary)) {
            this.hasFoundACLNode = true;
            if (this.accessControlHandling == AccessControlHandling.IGNORE || this.accessControlHandling == AccessControlHandling.CLEAR) {
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_IGNORED_ACCESS_CONTROL_LIST, this.accessControlHandling)));
            }
        }
        return null;
    }
}

