/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.input.NullInputStream;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MemoryArchive;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeInstaller;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageExistsException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.Version;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.JcrRegisteredPackage;
import org.apache.jackrabbit.vault.util.InputStreamPump;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageRegistry
extends AbstractPackageRegistry {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageRegistry.class);
    private static final String DEFAULT_NODETYPES = "nodetypes.cnd";
    private static final String[] FOLDER_TYPES = new String[]{"sling:Folder", "nt:folder", "nt:unstructured", null};
    private final Session session;
    @Nullable
    private PackageEventDispatcher dispatcher;
    private final Node[] packRoots;
    private final String[] packRootPaths;
    private PackageRegistry baseRegistry = null;

    public JcrPackageRegistry(@NotNull Session session, String ... roots) {
        this(session, null, false, true, IdConflictPolicy.FAIL, roots);
    }

    public JcrPackageRegistry(@NotNull Session session, @Nullable AbstractPackageRegistry.SecurityConfig securityConfig, boolean isStrict, boolean overwritePrimaryTypesOfFoldersByDefault, IdConflictPolicy defaultIdConflictPolicy, String ... roots) {
        super(securityConfig, isStrict, overwritePrimaryTypesOfFoldersByDefault, defaultIdConflictPolicy);
        this.session = session;
        this.packRootPaths = roots == null || roots.length == 0 ? new String[]{"/etc/packages"} : roots;
        this.packRoots = new Node[this.packRootPaths.length];
        this.initNodeTypes();
    }

    public void setBaseRegistry(@Nullable PackageRegistry baseRegisry) {
        this.baseRegistry = baseRegisry;
    }

    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void dispatch(@NotNull PackageEvent.Type type, @NotNull PackageId id, @Nullable PackageId[] related) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.dispatch(type, id, related);
    }

    private void initNodeTypes() {
        try {
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:Package");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:HierarchyNode");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:FullCoverage");
            return;
        }
        catch (RepositoryException repositoryException) {
            try (InputStream in = JcrPackageManagerImpl.class.getResourceAsStream(DEFAULT_NODETYPES);){
                if (in == null) {
                    throw new InternalError("Could not load nodetypes.cnd resource.");
                }
                NodeTypeInstaller installer = ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(this.session);
                CNDReader types = ServiceProviderFactory.getProvider().getCNDReader();
                types.read(new InputStreamReader(in, "utf8"), DEFAULT_NODETYPES, null);
                installer.install(null, types);
            }
            catch (Throwable e) {
                log.warn("Error while registering nodetypes. Package installation might not work correctly.", e);
            }
            return;
        }
    }

    @NotNull
    public String[] getPackRootPaths() {
        return this.packRootPaths;
    }

    @Nullable
    public Node getPrimaryPackageRoot(boolean autoCreate) throws RepositoryException {
        if (this.packRoots[0] == null) {
            if (this.session.nodeExists(this.packRootPaths[0])) {
                this.packRoots[0] = this.session.getNode(this.packRootPaths[0]);
            } else if (autoCreate) {
                if (this.session.hasPendingChanges()) {
                    throw new RepositoryException("Unwilling to create package root folder while session has transient changes.");
                }
                this.packRoots[0] = JcrUtils.getOrCreateByPath((String)this.packRootPaths[0], (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (Session)this.session, (boolean)true);
            }
        }
        return this.packRoots[0];
    }

    @NotNull
    public List<Node> getPackageRoots() throws RepositoryException {
        ArrayList<Node> roots = new ArrayList<Node>(this.packRootPaths.length);
        for (int i = 0; i < this.packRootPaths.length; ++i) {
            if (this.packRoots[i] == null && this.session.nodeExists(this.packRootPaths[i])) {
                this.packRoots[i] = this.session.getNode(this.packRootPaths[i]);
            }
            if (this.packRoots[i] == null) continue;
            roots.add(this.packRoots[i]);
        }
        return roots;
    }

    @Override
    @Nullable
    public RegisteredPackage open(@NotNull PackageId id) throws IOException {
        try {
            Node node = this.getPackageNode(id);
            if (node == null && this.baseRegistry != null) {
                return this.baseRegistry.open(id);
            }
            return node == null ? null : new JcrRegisteredPackage(this.open(node, false));
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public JcrPackage openJcrPackage(@NotNull PackageId id) throws RepositoryException {
        Node node = this.getPackageNode(id);
        return node == null ? null : this.open(node, false);
    }

    @Override
    public boolean contains(@NotNull PackageId id) throws IOException {
        try {
            boolean result;
            boolean bl = result = this.getPackageNode(id) != null;
            if (!result && this.baseRegistry != null) {
                result = this.baseRegistry.contains(id);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    private Node getPackageNode(@NotNull PackageId id) throws RepositoryException {
        String relPath = JcrPackageRegistry.getRelativeInstallationPath(id);
        for (String pfx : this.packRootPaths) {
            String[] exts;
            String path = pfx + "/" + relPath;
            for (String ext : exts = new String[]{"", ".zip", ".jar"}) {
                if (!this.session.nodeExists(path + ext)) continue;
                return this.session.getNode(path + ext);
            }
        }
        return null;
    }

    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageImpl pack = new JcrPackageImpl(this, node);
        try {
            if (pack.isValid()) {
                return pack;
            }
            if (allowInvalid && node.isNodeType("nt:hierarchyNode") && node.hasProperty("jcr:content/jcr:data")) {
                return pack;
            }
            pack.close();
            return null;
        }
        catch (RepositoryException e) {
            pack.close();
            throw e;
        }
    }

    @Override
    public PackageId resolve(Dependency dependency, boolean onlyInstalled) throws IOException {
        try {
            PackageId bestId = null;
            for (Node root : this.getPackageRoots()) {
                if (!root.hasNode(dependency.getGroup())) continue;
                Node groupNode = root.getNode(dependency.getGroup());
                NodeIterator iter = groupNode.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    if (".snapshot".equals(child.getName())) continue;
                    try (JcrPackageImpl pack = new JcrPackageImpl(this, child);){
                        PackageId id;
                        if (!pack.isValid() || onlyInstalled && !pack.isInstalled() || !dependency.matches(id = pack.getDefinition().getId()) || bestId != null && id.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                        bestId = id;
                    }
                }
            }
            if (bestId == null && this.baseRegistry != null) {
                bestId = this.baseRegistry.resolve(dependency, onlyInstalled);
            }
            return bestId;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    @NotNull
    public PackageId register(@NotNull InputStream in, boolean replace) throws IOException, PackageExistsException {
        JcrPackage pkg = this.upload(in, replace);
        try {
            PackageId packageId = pkg.getPackage().getId();
            if (pkg != null) {
                pkg.close();
            }
            return packageId;
        }
        catch (Throwable throwable) {
            try {
                if (pkg != null) {
                    try {
                        pkg.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    @NotNull
    public PackageId register(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        try (ZipVaultPackage pack = new ZipVaultPackage(file, false, true);){
            JcrPackage pkg = this.upload(pack, replace);
            try {
                PackageId packageId = pkg.getPackage().getId();
                if (pkg != null) {
                    pkg.close();
                }
                return packageId;
            }
            catch (Throwable throwable) {
                try {
                    if (pkg != null) {
                        try {
                            pkg.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    @Override
    @NotNull
    public PackageId registerExternal(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        throw new UnsupportedOperationException("linking files to repository persistence is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrPackage upload(InputStream in, boolean replace) throws RepositoryException, IOException, PackageExistsException {
        Binary bin;
        MemoryArchive archive = new MemoryArchive(true);
        try (InputStreamPump pump = new InputStreamPump(in, archive);){
            bin = this.session.getValueFactory().createBinary((InputStream)pump);
        }
        try {
            JcrPackage jcrPackage = this.upload(archive, bin, replace);
            return jcrPackage;
        }
        finally {
            archive.close();
            bin.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrPackage upload(@NotNull ZipVaultPackage pkg, boolean replace) throws RepositoryException, IOException, PackageExistsException {
        Binary binary;
        FileInputStream input;
        File file = pkg.getFile();
        if (file != null) {
            input = new FileInputStream(file);
            try {
                binary = this.session.getValueFactory().createBinary((InputStream)input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        input = new NullInputStream(0L);
        try {
            binary = this.session.getValueFactory().createBinary((InputStream)input);
        }
        finally {
            ((InputStream)input).close();
        }
        try {
            JcrPackage jcrPackage = this.upload(pkg.getArchive(), binary, replace);
            return jcrPackage;
        }
        finally {
            binary.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JcrPackage upload(@NotNull Archive archive, Binary binary, boolean replace) throws RepositoryException, IOException, PackageExistsException {
        if (archive.getJcrRoot() == null) {
            String msg = "Given archive is not a content package. Missing 'jcr_root'.";
            log.error(msg);
            throw new IOException(msg);
        }
        PackageId pid = archive.getMetaInf().getPackageProperties().getId();
        if (pid == null) {
            pid = JcrPackageRegistry.createRandomPid();
        }
        if (!pid.isValid()) {
            throw new RepositoryException("Unable to create package. Illegal package name.");
        }
        String path = this.getInstallationPath(pid) + ".zip";
        String parentPath = Text.getRelativeParent((String)path, (int)1);
        String name = Text.getName((String)path);
        Node parent = this.mkdir(parentPath, false);
        JcrPackageDefinitionImpl.State state = null;
        if (parent.hasNode(name)) {
            if (!pid.getVersion().isSnapshot()) {
                try (JcrPackageImpl oldPackage = new JcrPackageImpl(this, parent.getNode(name));){
                    JcrPackageDefinitionImpl oldDef = (JcrPackageDefinitionImpl)oldPackage.getDefinition();
                    if (oldDef != null) {
                        Calendar newCreateDate = archive.getMetaInf().getPackageProperties().getCreated();
                        Calendar oldCreatedDate = oldDef.getCreated();
                        if (newCreateDate != null && oldCreatedDate != null && oldCreatedDate.compareTo(newCreateDate) == 0) {
                            state = oldDef.getState();
                        }
                    }
                }
            }
            if (replace) {
                parent.getNode(name).remove();
            } else {
                throw new PackageExistsException("Package already exists: " + pid).setId(pid);
            }
        }
        JcrPackage jcrPack = null;
        try {
            jcrPack = this.createNew(parent, pid, binary, archive);
            JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)jcrPack.getDefinition();
            if (state != null && def != null) {
                def.setState(state);
            }
            this.dispatch(PackageEvent.Type.UPLOAD, pid, null);
            JcrPackage jcrPackage = jcrPack;
            return jcrPackage;
        }
        finally {
            if (jcrPack == null) {
                this.session.refresh(false);
            } else {
                this.session.save();
            }
        }
    }

    public Node mkdir(String path, boolean autoSave) throws RepositoryException {
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        String parentPath = Text.getRelativeParent((String)path, (int)1);
        if (path == null || "/".equals(path) && parentPath.equals(path)) {
            throw new RepositoryException("could not create intermediate nodes");
        }
        Node parent = this.mkdir(parentPath, autoSave);
        Node node = null;
        RepositoryException lastError = null;
        for (int i = 0; node == null && i < FOLDER_TYPES.length; ++i) {
            try {
                node = parent.addNode(Text.getName((String)path), FOLDER_TYPES[i]);
                continue;
            }
            catch (RepositoryException e) {
                lastError = e;
            }
        }
        if (node == null) {
            if (lastError != null) {
                throw lastError;
            }
            throw new RepositoryException("Unable to create path: " + path);
        }
        if (autoSave) {
            parent.getSession().save();
        }
        return node;
    }

    public JcrPackage create(String group, String name, String version) throws RepositoryException, IOException {
        String ext = Text.getName((String)name, (char)'.');
        if ("zip".equals(ext) || "jar".equals(ext)) {
            name = name.substring(0, name.length() - 4);
        }
        if (!PackageId.isValid(group, name, version)) {
            throw new RepositoryException("Unable to create package. Illegal package name.");
        }
        PackageId pid = new PackageId(group, name, version);
        Node folder = this.mkdir(Text.getRelativeParent((String)this.getInstallationPath(pid), (int)1), false);
        return this.createNew(folder, pid, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JcrPackage createNew(@NotNull Node parent, @NotNull PackageId pid, @Nullable VaultPackage pack, boolean autoSave) throws RepositoryException, IOException {
        Binary binary;
        FileInputStream input;
        File file;
        File file2 = file = pack != null ? pack.getFile() : null;
        if (file != null) {
            input = new FileInputStream(file);
            try {
                binary = parent.getSession().getValueFactory().createBinary((InputStream)input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        input = new NullInputStream(0L);
        try {
            binary = parent.getSession().getValueFactory().createBinary((InputStream)input);
        }
        finally {
            ((InputStream)input).close();
        }
        try {
            JcrPackage jcrPack = this.createNew(parent, pid, binary, pack != null ? pack.getArchive() : null);
            if (autoSave) {
                parent.getSession().save();
            }
            JcrPackage jcrPackage = jcrPack;
            return jcrPackage;
        }
        finally {
            binary.dispose();
        }
    }

    @NotNull
    private JcrPackage createNew(@NotNull Node parent, @NotNull PackageId pid, @NotNull Binary binary, @Nullable Archive archive) throws RepositoryException, IOException {
        Node node = parent.addNode(Text.getName((String)(this.getInstallationPath(pid) + ".zip")), "nt:file");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("vlt:Package");
        Node defNode = content.addNode("vlt:definition");
        JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
        def.set("name", pid.getName(), false);
        def.set("group", pid.getGroup(), false);
        def.set("version", pid.getVersionString(), false);
        def.touch(null, false);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:mimeType", "application/zip");
        content.setProperty("jcr:data", binary);
        def.unwrap(archive, false);
        this.dispatch(PackageEvent.Type.CREATE, pid, null);
        return new JcrPackageImpl(this, node);
    }

    @Override
    public void remove(@NotNull PackageId id) throws IOException, NoSuchPackageException {
        try (JcrRegisteredPackage pkg = (JcrRegisteredPackage)this.open(id);){
            if (pkg == null) {
                throw new NoSuchPackageException().setId(id);
            }
            try (JcrPackage pack = pkg.getJcrPackage();){
                try (JcrPackage snap = pack.getSnapshot();){
                    if (snap != null) {
                        snap.getNode().remove();
                    }
                }
                pack.getNode().remove();
            }
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
        this.dispatch(PackageEvent.Type.REMOVE, id, null);
    }

    public JcrPackage rename(JcrPackage pack, String group, String name, String version) throws PackageException, RepositoryException {
        if (!pack.isValid()) {
            throw new PackageException("Package is not valid.");
        }
        if (pack.getSize() > 0L && !pack.getDefinition().isUnwrapped()) {
            throw new PackageException("Package definition not unwrapped.");
        }
        if (!PackageId.isValid(group, name, version)) {
            throw new RepositoryException("Unable to rename package. Illegal package name.");
        }
        JcrPackageDefinition def = pack.getDefinition();
        PackageId id = def.getId();
        PackageId newId = new PackageId(group == null ? id.getGroup() : group, name == null ? id.getName() : name, version == null ? id.getVersion() : Version.create(version));
        String dstPath = this.getInstallationPath(newId) + ".zip";
        if (id.equals(newId) && pack.getNode().getPath().equals(dstPath)) {
            log.debug("Package id not changed. won't rename.");
            return pack;
        }
        def.setId(newId, false);
        if (!pack.getNode().getPath().equals(dstPath)) {
            if (this.session.nodeExists(dstPath)) {
                throw new PackageException("Node at " + dstPath + " already exists.");
            }
            this.mkdir(Text.getRelativeParent((String)dstPath, (int)1), false);
            this.session.move(pack.getNode().getPath(), dstPath);
        }
        this.session.save();
        Node newNode = this.session.getNode(dstPath);
        this.dispatch(PackageEvent.Type.RENAME, id, new PackageId[]{newId});
        return this.open(newNode, false);
    }

    @Override
    @NotNull
    public Set<PackageId> packages() throws IOException {
        try {
            TreeSet<PackageId> packages = new TreeSet<PackageId>();
            for (Node pRoot : this.getPackageRoots()) {
                this.listPackages(pRoot, packages);
            }
            return packages;
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    private void listPackages(Node root, Set<PackageId> packages) throws RepositoryException {
        NodeIterator iter = root.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (".snapshot".equals(child.getName())) continue;
            try (JcrPackageImpl pack = new JcrPackageImpl(this, child);){
                if (pack.isValid()) {
                    JcrPackageDefinition jDef = pack.getDefinition();
                    if (jDef == null || !jDef.getId().isValid()) continue;
                    packages.add(jDef.getId());
                    continue;
                }
                if (!child.hasNodes()) continue;
                this.listPackages(child, packages);
            }
        }
    }

    public String getInstallationPath(PackageId id) {
        return this.packRootPaths[0] + "/" + JcrPackageRegistry.getRelativeInstallationPath(id);
    }

    @Override
    public void installPackage(@NotNull Session session, @NotNull RegisteredPackage pkg, @NotNull ImportOptions opts, boolean extract) throws IOException, PackageException {
        JcrRegisteredPackage registeredPackage = (JcrRegisteredPackage)pkg;
        try (JcrPackage jcrPkg = registeredPackage.getJcrPackage();){
            if (extract) {
                jcrPkg.extract(opts);
            } else {
                jcrPkg.install(opts);
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void uninstallPackage(@NotNull Session session, @NotNull RegisteredPackage pkg, @NotNull ImportOptions opts) throws IOException, PackageException {
        try (JcrPackage jcrPkg = ((JcrRegisteredPackage)pkg).getJcrPackage();){
            jcrPkg.uninstall(opts);
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }
}

