/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.AbstractAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicyBuilder;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalBasedAccessControlEntry;

public class PrincipalBasedAccessControlList
extends JackrabbitAccessControlPolicy {
    private final String principalName;
    private final List<PrincipalBasedAccessControlEntry> entries = new ArrayList<PrincipalBasedAccessControlEntry>();

    private PrincipalBasedAccessControlList(String principalName, List<PrincipalBasedAccessControlEntry> entries) {
        this.entries.addAll(entries);
        this.principalName = principalName;
    }

    @Override
    public List<String> apply(Session session, AccessControlHandling aclHandling, String accessControlledPath) throws RepositoryException {
        Principal principal;
        if (aclHandling == AccessControlHandling.IGNORE) {
            return Collections.emptyList();
        }
        if (aclHandling == AccessControlHandling.MERGE_PRESERVE) {
            log.debug("MERGE_PRESERVE for principal-based access control list is equivalent to IGNORE.");
            return Collections.emptyList();
        }
        JackrabbitAccessControlManager acMgr = PrincipalBasedAccessControlList.getAccessControlManager(session);
        PrincipalAccessControlList acl = this.getPolicy(acMgr, PrincipalAccessControlList.class, principal = this.getPrincipal(session, this.principalName, accessControlledPath));
        if (acl != null && aclHandling == AccessControlHandling.OVERWRITE) {
            acMgr.removePolicy(acl.getPath(), (AccessControlPolicy)acl);
            acl = null;
        }
        if (acl == null) {
            acl = this.getApplicablePolicy(acMgr, PrincipalAccessControlList.class, principal);
        }
        for (PrincipalBasedAccessControlEntry entry : this.entries) {
            Map.Entry<Map<String, Value>, Map<String, Value[]>> restrictions = entry.separateRestrictions((JackrabbitAccessControlList)acl);
            acl.addEntry(entry.effectivePath, entry.getPrivileges((AccessControlManager)acMgr), restrictions.getKey(), restrictions.getValue());
        }
        acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        String path = acl.getPath() == null ? "/rep:repoPolicy" : ("/".equals(acl.getPath()) ? "/rep:principalPolicy" : acl.getPath() + "/" + "rep:principalPolicy");
        return Collections.singletonList(path);
    }

    public static final class Builder
    implements JackrabbitAccessControlPolicyBuilder<PrincipalBasedAccessControlList> {
        private final List<PrincipalBasedAccessControlEntry> entries = new ArrayList<PrincipalBasedAccessControlEntry>();
        private final String principalName;

        public Builder(String principalName) {
            this.principalName = principalName;
        }

        @Override
        public void addEntry(AbstractAccessControlEntry entry) {
            if (!(entry instanceof PrincipalBasedAccessControlEntry)) {
                throw new IllegalStateException("Only entries of type PrincipalBasedAccessControlEntry are supported");
            }
            this.entries.add((PrincipalBasedAccessControlEntry)entry);
        }

        @Override
        public PrincipalBasedAccessControlList build() {
            return new PrincipalBasedAccessControlList(this.principalName, this.entries);
        }
    }
}

