/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlEntryBuilder;
import org.apache.jackrabbit.vault.util.UncheckedRepositoryException;

public class AbstractAccessControlEntry {
    final Collection<String> privileges;
    final Map<String, Value[]> restrictions;

    protected AbstractAccessControlEntry(JackrabbitAccessControlEntry entry) throws RepositoryException {
        this(Arrays.stream(entry.getPrivileges()).map(Privilege::getName).collect(Collectors.toList()), Arrays.stream(entry.getRestrictionNames()).collect(Collectors.toMap(rn -> rn, rn -> {
            try {
                return entry.getRestrictions(rn);
            }
            catch (RepositoryException e) {
                throw new UncheckedRepositoryException(e);
            }
        })));
    }

    Map.Entry<Map<String, Value>, Map<String, Value[]>> separateRestrictions(JackrabbitAccessControlList list) throws RepositoryException {
        HashMap svRestrictions = new HashMap();
        HashMap mvRestrictions = new HashMap();
        try {
            Map<Boolean, List<String>> restrictionNamesMap = this.restrictions.keySet().stream().collect(Collectors.partitioningBy(r -> {
                try {
                    return list.isMultiValueRestriction(r);
                }
                catch (RepositoryException e) {
                    throw new UncheckedRepositoryException(e);
                }
            }));
            restrictionNamesMap.get(Boolean.TRUE).stream().forEach(restrictionName -> mvRestrictions.put(restrictionName, this.restrictions.get(restrictionName)));
            restrictionNamesMap.get(Boolean.FALSE).stream().forEach(restrictionName -> svRestrictions.put(restrictionName, this.restrictions.get(restrictionName)[0]));
        }
        catch (UncheckedRepositoryException e) {
            throw e.getCause();
        }
        return new AbstractMap.SimpleEntry<Map<String, Value>, Map<String, Value[]>>(svRestrictions, mvRestrictions);
    }

    protected AbstractAccessControlEntry(Collection<String> privileges, Map<String, Value[]> restrictions) {
        this.privileges = new HashSet<String>(privileges);
        this.restrictions = new HashMap<String, Value[]>(restrictions);
    }

    Privilege[] getPrivileges(AccessControlManager acMgr) throws RepositoryException {
        return AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])this.privileges.toArray(new String[0]));
    }

    protected static abstract class Builder<T extends AbstractAccessControlEntry>
    implements JackrabbitAccessControlEntryBuilder<T> {
        final Collection<String> privileges;
        final Map<String, Value[]> restrictions;

        Builder(Collection<String> privileges) {
            this.privileges = new HashSet<String>(privileges);
            this.restrictions = new HashMap<String, Value[]>();
        }

        @Override
        public void addRestriction(String restrictionName, Value[] values) {
            this.restrictions.put(restrictionName, values);
        }
    }
}

