/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitUserManagement;
import org.apache.jackrabbit.vault.util.UncheckedRepositoryException;
import org.jetbrains.annotations.NotNull;

public class JackrabbitACLManagement
implements ACLManagement {
    public static final String NT_REP_CUG_POLICY = "rep:CugPolicy";
    public static final String REP_CUG_POLICY = "rep:cugPolicy";
    public static final String REP_POLICY = "rep:policy";
    public static final String REP_PRINCIPAL_POLICY = "rep:principalPolicy";
    public static final String NT_REP_PRINCIPAL_POLICY = "rep:PrincipalPolicy";
    public static final String NT_REP_AUTHORIZABLE_FOLDER = "rep:AuthorizableFolder";
    public static final String REP_REPO_POLICY = "rep:repoPolicy";
    public static final String NT_REP_POLICY = "rep:Policy";
    public static final String NT_REP_ACL = "rep:ACL";
    public static final String NT_REP_ACE = "rep:ACE";
    public static final String NT_REP_GRANT_ACE = "rep:GrantACE";
    public static final String NT_REP_DENY_ACE = "rep:DenyACE";
    public static final String NT_REP_RESTRICTIONS = "rep:Restrictions";
    public static final String MIX_REP_ACCESS_CONTROLLABLE = "rep:AccessControllable";
    public static final String MIX_REP_REPO_ACCESS_CONTROLLABLE = "rep:RepoAccessControllable";
    public static final String MIX_REP_CUG_MIXIN = "rep:CugMixin";
    public static final String MIX_REP_PRINCIPAL_BASED_MIXIN = "rep:PrincipalBasedMixin";
    private final UserManagement userManagement = new JackrabbitUserManagement();

    @Override
    public boolean isACLNodeType(String name) {
        return name.equals(NT_REP_ACL) || name.equals(NT_REP_CUG_POLICY) || name.equals(NT_REP_PRINCIPAL_POLICY);
    }

    @Override
    public boolean isAccessControllableMixin(String name) {
        return name.equals(MIX_REP_ACCESS_CONTROLLABLE) || name.equals(MIX_REP_REPO_ACCESS_CONTROLLABLE) || name.equals(MIX_REP_CUG_MIXIN) || name.equals(MIX_REP_PRINCIPAL_BASED_MIXIN);
    }

    @Override
    public boolean isACLNode(Node node) throws RepositoryException {
        return node.isNodeType(NT_REP_POLICY);
    }

    @Override
    public boolean ensureAccessControllable(Node node, String policyPrimaryType) throws RepositoryException {
        boolean modified = false;
        if (NT_REP_ACL.equals(policyPrimaryType)) {
            if (!node.isNodeType(MIX_REP_ACCESS_CONTROLLABLE)) {
                node.addMixin(MIX_REP_ACCESS_CONTROLLABLE);
                modified = true;
            }
            if (JackrabbitACLManagement.isRootNode(node) && !node.isNodeType(MIX_REP_REPO_ACCESS_CONTROLLABLE)) {
                node.addMixin(MIX_REP_REPO_ACCESS_CONTROLLABLE);
                modified = true;
            }
        } else if (NT_REP_CUG_POLICY.equals(policyPrimaryType)) {
            if (!node.isNodeType(MIX_REP_CUG_MIXIN)) {
                node.addMixin(MIX_REP_CUG_MIXIN);
                modified = true;
            }
        } else if (NT_REP_PRINCIPAL_POLICY.equals(policyPrimaryType) && !node.isNodeType(MIX_REP_PRINCIPAL_BASED_MIXIN)) {
            node.addMixin(MIX_REP_PRINCIPAL_BASED_MIXIN);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clearACL(Node node) throws RepositoryException {
        AccessControlManager ac = node.getSession().getAccessControlManager();
        String pPath = node.getPath();
        for (AccessControlPolicy p : ac.getPolicies(pPath)) {
            ac.removePolicy(pPath, p);
        }
        if (JackrabbitACLManagement.isRootNode(node)) {
            for (AccessControlPolicy p : ac.getPolicies(null)) {
                ac.removePolicy(null, p);
            }
        }
    }

    private static boolean isRootNode(Node node) throws RepositoryException {
        return node.getDepth() == 0;
    }

    private boolean isAuthorizable(Node node) throws RepositoryException {
        return this.userManagement.isAuthorizableNodeType(node.getPrimaryNodeType().getName());
    }

    private boolean isAuthorizableFolder(Node node) throws RepositoryException {
        return node.isNodeType(NT_REP_AUTHORIZABLE_FOLDER);
    }

    private boolean areAuthorizablesAllowed(Node node) throws RepositoryException {
        return this.isAuthorizableFolder(node) || this.isAuthorizable(node);
    }

    @Override
    @NotNull
    public Map<String, List<? extends AccessControlPolicy>> getPrincipalAcls(Node node) throws RepositoryException {
        if (!this.areAuthorizablesAllowed(node)) {
            return Collections.emptyMap();
        }
        JackrabbitSession jrSession = (JackrabbitSession)node.getSession();
        AccessControlManager acMgr = jrSession.getAccessControlManager();
        if (!(acMgr instanceof JackrabbitAccessControlManager)) {
            throw new RepositoryException("The access control manager returned is no JackrabbitAccessControlManager, this is probably not a Jackrabbit/Oak repository");
        }
        JackrabbitAccessControlManager jrAcMgr = (JackrabbitAccessControlManager)acMgr;
        PrincipalAccessControlPolicyCollector policiesCollector = new PrincipalAccessControlPolicyCollector(jrAcMgr);
        try {
            this.findPrincipalsRecursively(jrSession.getUserManager(), node, policiesCollector);
            return policiesCollector.getPoliciesPerPrincipal();
        }
        catch (UncheckedRepositoryException e) {
            throw e.getCause();
        }
    }

    private void findPrincipalsRecursively(UserManager userMgr, Node node, Consumer<Principal> principalConsumer) throws RepositoryException {
        if (this.isAuthorizable(node)) {
            Authorizable authorizable = userMgr.getAuthorizableByPath(node.getPath());
            if (authorizable != null) {
                principalConsumer.accept(authorizable.getPrincipal());
            }
        } else if (this.isAuthorizableFolder(node)) {
            for (Node child : JcrUtils.in((Iterator)node.getNodes())) {
                this.findPrincipalsRecursively(userMgr, child, principalConsumer);
            }
        }
    }

    private static final class PrincipalAccessControlPolicyCollector
    implements Consumer<Principal> {
        private final JackrabbitAccessControlManager jrAcMgr;
        private final Map<String, List<? extends AccessControlPolicy>> policiesPerPrincipal;

        public PrincipalAccessControlPolicyCollector(JackrabbitAccessControlManager jrAcMgr) {
            this.jrAcMgr = jrAcMgr;
            this.policiesPerPrincipal = new HashMap<String, List<? extends AccessControlPolicy>>();
        }

        public Map<String, List<? extends AccessControlPolicy>> getPoliciesPerPrincipal() {
            return this.policiesPerPrincipal;
        }

        @Override
        public void accept(Principal principal) {
            try {
                List<JackrabbitAccessControlPolicy> policies = Arrays.asList(this.jrAcMgr.getPolicies(principal));
                if (!policies.isEmpty()) {
                    this.policiesPerPrincipal.put(principal.getName(), policies);
                }
            }
            catch (RepositoryException e) {
                throw new UncheckedRepositoryException(e);
            }
        }
    }
}

