/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.io.AbstractExporter;
import org.apache.jackrabbit.vault.fs.io.ExportInfo;
import org.apache.jackrabbit.vault.util.PathUtil;

public class PlatformExporter
extends AbstractExporter {
    private final File localParent;
    private boolean pruneMissing;

    public PlatformExporter(File localFile) {
        this.localParent = localFile;
    }

    public boolean pruneMissing() {
        return this.pruneMissing;
    }

    public void setPruneMissing(boolean pruneMissing) {
        this.pruneMissing = pruneMissing;
    }

    @Override
    public void open() throws IOException, RepositoryException {
        this.scan(new File(this.localParent, "jcr_root"));
    }

    @Override
    public void close() throws IOException {
        if (this.pruneMissing) {
            this.exportInfo.getEntries().values().stream().filter(e -> e.type == ExportInfo.Type.RMDIR).map(e -> e.path).sorted(Comparator.comparingInt(String::length)).forEachOrdered(path -> {
                File file = new File((String)path);
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                    this.track("D", PathUtil.getRelativePath(this.localParent.getAbsolutePath(), path));
                }
            });
            this.exportInfo.getEntries().values().stream().filter(e -> e.type == ExportInfo.Type.DELETE).map(e -> e.path).forEach(path -> {
                File file = new File((String)path);
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                    this.track("D", PathUtil.getRelativePath(this.localParent.getAbsolutePath(), path));
                }
            });
        }
    }

    private void scan(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (".svn".equals(name) || ".vlt".equals(name)) continue;
            if (file.isDirectory()) {
                this.exportInfo.update(ExportInfo.Type.RMDIR, file.getPath());
                this.scan(file);
                continue;
            }
            this.exportInfo.update(ExportInfo.Type.DELETE, file.getPath());
        }
    }

    @Override
    public void createDirectory(VaultFile file, String relPath) throws RepositoryException, IOException {
        File dir = new File(this.localParent, this.getPlatformFilePath(file, relPath));
        this.mkdirs(dir);
        this.exportInfo.update(ExportInfo.Type.MKDIR, dir.getPath());
    }

    @Override
    public void createDirectory(String relPath) throws IOException {
        File dir = new File(this.localParent, relPath);
        this.mkdirs(dir);
        this.exportInfo.update(ExportInfo.Type.MKDIR, dir.getPath());
    }

    @Override
    public void writeFile(VaultFile file, String relPath) throws RepositoryException, IOException {
        File local = new File(this.localParent, this.getPlatformFilePath(file, relPath));
        if (!local.getParentFile().exists()) {
            this.mkdirs(local.getParentFile());
        }
        if (local.exists()) {
            this.exportInfo.update(ExportInfo.Type.UPDATE, local.getPath());
            this.track("U", PathUtil.getRelativeFilePath(this.localParent.getAbsolutePath(), local.getAbsolutePath()));
        } else {
            this.exportInfo.update(ExportInfo.Type.ADD, local.getPath());
            this.track("A", PathUtil.getRelativeFilePath(this.localParent.getAbsolutePath(), local.getAbsolutePath()));
        }
        Artifact a = file.getArtifact();
        switch (a.getPreferredAccess()) {
            case NONE: {
                throw new RepositoryException("Artifact has no content.");
            }
            case SPOOL: {
                try (FileOutputStream out = new FileOutputStream(local);){
                    a.spool(out);
                    break;
                }
            }
            case STREAM: {
                InputStream in = a.getInputStream();
                try {
                    try (FileOutputStream out = new FileOutputStream(local);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    if (in == null) break;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
                break;
            }
        }
        if (a.getLastModified() >= 0L) {
            local.setLastModified(a.getLastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(InputStream in, String relPath) throws IOException {
        try {
            File local = new File(this.localParent, relPath);
            if (!local.getParentFile().exists()) {
                this.mkdirs(local.getParentFile());
            }
            if (local.exists()) {
                this.exportInfo.update(ExportInfo.Type.UPDATE, local.getPath());
                this.track("U", PathUtil.getRelativeFilePath(this.localParent.getAbsolutePath(), local.getAbsolutePath()));
            } else {
                this.exportInfo.update(ExportInfo.Type.ADD, local.getPath());
                this.track("A", PathUtil.getRelativeFilePath(this.localParent.getAbsolutePath(), local.getAbsolutePath()));
            }
            Files.copy(in, local.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            in.close();
        }
    }

    private void mkdirs(File dir) throws IOException {
        if (!dir.exists()) {
            dir.mkdirs();
            this.track("A", PathUtil.getRelativeFilePath(this.localParent.getAbsolutePath(), dir.getAbsolutePath()));
        }
    }
}

