/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewImporter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.AbstractAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlEntryBuilder;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicyBuilder;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalBasedAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalBasedAccessControlList;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalSetAccessControlPolicy;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.ResourceBasedAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.ResourceBasedAccessControlList;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.UncheckedRepositoryException;
import org.apache.jackrabbit.vault.util.UncheckedValueFormatException;
import org.slf4j.Logger;

public class JackrabbitACLImporter
implements DocViewAdapter {
    private static final Name NAME_REP_EFFECTIVE_PATH = NameFactoryImpl.getInstance().create("internal", "effectivePath");
    private static final Name NAME_REP_PRINCIPAL_NAMES = NameFactoryImpl.getInstance().create("internal", "principalNames");
    private static final Logger log = DocViewImporter.log;
    private final Session session;
    private final AccessControlHandling aclHandling;
    private final String accessControlledPath;
    private final NamePathResolver resolver;
    private static final Set<Name> NON_RESTRICTION_PROPERTY_NAMES = new HashSet<Name>(Arrays.asList(NameConstants.REP_PRINCIPAL_NAME, NameConstants.JCR_PRIMARYTYPE, NameConstants.JCR_MIXINTYPES, NameConstants.REP_PRIVILEGES));
    private JackrabbitAccessControlPolicyBuilder<?> policyBuilder;
    private JackrabbitAccessControlEntryBuilder<? extends AbstractAccessControlEntry> entryBuilder;
    private final Deque<State> states = new LinkedList<State>();

    public JackrabbitACLImporter(Node accessControlledNode, AccessControlHandling aclHandling) throws RepositoryException {
        this(accessControlledNode.getSession(), accessControlledNode.getPath(), aclHandling);
    }

    public JackrabbitACLImporter(Session session, AccessControlHandling aclHandling) throws RepositoryException {
        this(session, null, aclHandling);
    }

    private JackrabbitACLImporter(Session session, String path, AccessControlHandling aclHandling) throws RepositoryException {
        if (aclHandling == AccessControlHandling.CLEAR || aclHandling == AccessControlHandling.IGNORE) {
            throw new RepositoryException("Error while reading access control content: unsupported AccessControlHandling: " + (Object)((Object)aclHandling));
        }
        this.accessControlledPath = path;
        this.session = session;
        this.aclHandling = aclHandling;
        this.states.push(State.INITIAL);
        this.resolver = new DefaultNamePathResolver(session);
    }

    @Override
    public void startNode(DocViewNode2 node) throws RepositoryException, IOException {
        State state = this.states.peek();
        try {
            switch (state) {
                case INITIAL: {
                    String primaryType = node.getPrimaryType().orElseThrow(() -> new IllegalStateException("Error while reading access control content: Missing 'jcr:primaryType'"));
                    if ("rep:ACL".equals(primaryType)) {
                        this.policyBuilder = new ResourceBasedAccessControlList.Builder();
                        state = State.RESOURCE_BASED_ACL;
                        break;
                    }
                    if ("rep:CugPolicy".equals(primaryType)) {
                        Collection<String> principalNames = node.getPropertyValues(NAME_REP_PRINCIPAL_NAMES);
                        this.policyBuilder = new PrincipalSetAccessControlPolicy.Builder(principalNames);
                        state = State.PRINCIPAL_SET_POLICY;
                        break;
                    }
                    if ("rep:PrincipalPolicy".equals(primaryType)) {
                        String principalName = node.getPropertyValue(NameConstants.REP_PRINCIPAL_NAME).orElseThrow(() -> new IllegalStateException("mandatory property 'rep:principalName' missing on principal policy node"));
                        this.policyBuilder = new PrincipalBasedAccessControlList.Builder(principalName);
                        state = State.PRINCIPAL_BASED_ACL;
                        break;
                    }
                    throw new IOException("Error while reading access control content: Expected rep:ACL, rep:PrincipalPolicy or rep:CugPolicy primary type but found: " + node.getPrimaryType().toString());
                }
                case RESOURCE_BASED_ACL: 
                case PRINCIPAL_BASED_ACL: 
                case RESOURCE_BASED_ACE: 
                case PRINCIPAL_BASED_ACE: 
                case RESTRICTION: {
                    state = this.startEntryNode(node, state);
                    break;
                }
                case PRINCIPAL_SET_POLICY: {
                    throw new IOException("Error while reading access control content: Unexpected node: " + node.getPrimaryType().orElse("") + " for state " + (Object)((Object)state));
                }
            }
        }
        catch (UncheckedRepositoryException e) {
            throw e.getCause();
        }
        this.states.push(state);
    }

    private State startEntryNode(DocViewNode2 node, State state) throws IOException {
        State newState;
        switch (state) {
            case RESOURCE_BASED_ACL: {
                boolean allow;
                String primaryType = node.getPrimaryType().orElseThrow(() -> new IllegalStateException("mandatory property 'jcr:primaryType' missing on ace node"));
                if ("rep:GrantACE".equals(primaryType)) {
                    allow = true;
                } else if ("rep:DenyACE".equals(primaryType)) {
                    allow = false;
                } else {
                    throw new IOException("Unexpected node ACE type inside resource based ACL: " + node.getPrimaryType());
                }
                String principalName = node.getPropertyValue(NameConstants.REP_PRINCIPAL_NAME).orElseThrow(() -> new IllegalStateException("mandatory property 'rep:principalName' missing"));
                Collection<String> privileges = node.getPropertyValues(NameConstants.REP_PRIVILEGES);
                this.entryBuilder = new ResourceBasedAccessControlEntry.Builder(privileges, allow, principalName);
                this.extractRestrictions(node).entrySet().stream().forEach(entry -> this.entryBuilder.addRestriction((String)entry.getKey(), (Value[])entry.getValue()));
                newState = State.RESOURCE_BASED_ACE;
                break;
            }
            case PRINCIPAL_BASED_ACL: {
                if (!"rep:PrincipalEntry".equals(node.getPrimaryType().orElseThrow(() -> new IllegalStateException("mandatory property 'jcr:primaryType' missing on principal policy node")))) {
                    throw new IOException("Unexpected node ACE type inside principal based ACL: " + node.getPrimaryType());
                }
                Collection<String> privileges = node.getPropertyValues(NameConstants.REP_PRIVILEGES);
                String v = node.getPropertyValue(NAME_REP_EFFECTIVE_PATH).orElseThrow(() -> new IllegalStateException("mandatory property 'rep:effectivePath ' missing on principal entry node"));
                String effectivePath = v.isEmpty() ? null : v;
                this.entryBuilder = new PrincipalBasedAccessControlEntry.Builder(privileges, effectivePath);
                newState = State.PRINCIPAL_BASED_ACE;
                break;
            }
            case RESOURCE_BASED_ACE: 
            case PRINCIPAL_BASED_ACE: {
                if (!"rep:Restrictions".equals(node.getPrimaryType().orElseThrow(() -> new IllegalStateException("mandatory property 'jcr:primaryType' missing on principal policy node")))) {
                    throw new IllegalArgumentException("Unexpected restriction type inside principal or resource based ACE: " + node.getPrimaryType());
                }
                this.extractRestrictions(node).entrySet().stream().forEach(entry -> this.entryBuilder.addRestriction((String)entry.getKey(), (Value[])entry.getValue()));
                newState = State.RESTRICTION;
                break;
            }
            case RESTRICTION: {
                throw new IOException("Restriction nodes are not supposed to have any children but found " + node.toString());
            }
            default: {
                throw new IllegalArgumentException("This method must not be called with state " + (Object)((Object)state));
            }
        }
        return newState;
    }

    private Map<String, Value[]> extractRestrictions(DocViewNode2 node) {
        return node.getProperties().stream().filter(p -> !NON_RESTRICTION_PROPERTY_NAMES.contains(p.getName())).collect(Collectors.toMap(p -> {
            try {
                return this.resolver.getJCRName(p.getName());
            }
            catch (NamespaceException e) {
                throw new IllegalStateException("Cannot retrieve qualified name for " + p.getName().toString(), e);
            }
        }, p -> {
            try {
                return p.getValues(this.session.getValueFactory()).toArray(new Value[0]);
            }
            catch (ValueFormatException e) {
                throw new UncheckedValueFormatException(e);
            }
            catch (RepositoryException e) {
                throw new UncheckedRepositoryException(e);
            }
        }));
    }

    @Override
    public void endNode() {
        State state = this.states.pop();
        switch (state) {
            case RESOURCE_BASED_ACE: 
            case PRINCIPAL_BASED_ACE: {
                this.policyBuilder.addEntry(this.entryBuilder.build());
                break;
            }
        }
    }

    @Override
    public List<String> close() throws RepositoryException {
        if (this.states.peek() != State.INITIAL) {
            log.error("Unexpected end state: {}", (Object)this.states.peek());
        }
        Object policy = this.policyBuilder.build();
        return ((JackrabbitAccessControlPolicy)policy).apply(this.session, this.aclHandling, this.accessControlledPath);
    }

    private static enum State {
        INITIAL,
        RESOURCE_BASED_ACL,
        PRINCIPAL_BASED_ACL,
        PRINCIPAL_SET_POLICY,
        RESOURCE_BASED_ACE,
        PRINCIPAL_BASED_ACE,
        RESTRICTION;

    }
}

