/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrincipalSetPolicy;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.AbstractAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicyBuilder;

public class PrincipalSetAccessControlPolicy
extends JackrabbitAccessControlPolicy {
    private final Collection<String> principalNames;

    public PrincipalSetAccessControlPolicy(Collection<String> principalNames) {
        this.principalNames = new HashSet<String>(principalNames);
    }

    @Override
    public List<String> apply(Session session, AccessControlHandling aclHandling, String accessControlledPath) throws RepositoryException {
        if (aclHandling == AccessControlHandling.IGNORE) {
            return Collections.emptyList();
        }
        JackrabbitAccessControlManager acMgr = PrincipalSetAccessControlPolicy.getAccessControlManager(session);
        PrincipalSetPolicy psPolicy = this.getPolicy(acMgr, PrincipalSetPolicy.class, accessControlledPath);
        if (psPolicy != null) {
            Set existingPrincipals = psPolicy.getPrincipals();
            if (aclHandling == AccessControlHandling.OVERWRITE) {
                psPolicy.removePrincipals(existingPrincipals.toArray(new Principal[existingPrincipals.size()]));
            }
        } else {
            psPolicy = this.getApplicablePolicy(acMgr, PrincipalSetPolicy.class, accessControlledPath);
        }
        Principal[] principals = (Principal[])this.principalNames.stream().map(name -> this.getPrincipal((String)name)).toArray(Principal[]::new);
        psPolicy.addPrincipals(principals);
        acMgr.setPolicy(accessControlledPath, (AccessControlPolicy)psPolicy);
        String path = "/".equals(accessControlledPath) ? "/rep:cugPolicy" : accessControlledPath + "/" + "rep:cugPolicy";
        return Collections.singletonList(path);
    }

    public static final class Builder
    implements JackrabbitAccessControlPolicyBuilder<JackrabbitAccessControlPolicy> {
        private final Collection<String> principalNames;

        public Builder(Collection<String> principalNames) {
            this.principalNames = new HashSet<String>(principalNames);
        }

        @Override
        public void addEntry(AbstractAccessControlEntry entry) {
            throw new UnsupportedOperationException("This policy type does not support entries");
        }

        @Override
        public PrincipalSetAccessControlPolicy build() {
            return new PrincipalSetAccessControlPolicy(this.principalNames);
        }
    }
}

