/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EffectiveNodeType {
    @NotNull
    private final List<NodeType> nodeTypes;

    public static EffectiveNodeType ofNode(@NotNull Node node) throws RepositoryException {
        return EffectiveNodeType.ofPrimaryTypeAndMixins(node.getPrimaryNodeType(), node.getMixinNodeTypes());
    }

    public static EffectiveNodeType ofPrimaryTypeAndMixins(@NotNull NodeType primaryType, NodeType ... mixinTypes) {
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        types.add(primaryType);
        Arrays.stream(mixinTypes).forEach(types::add);
        return new EffectiveNodeType(types);
    }

    private EffectiveNodeType(@NotNull List<NodeType> nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public int hashCode() {
        return Objects.hash(this.nodeTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EffectiveNodeType other = (EffectiveNodeType)obj;
        return Objects.equals(this.nodeTypes, other.nodeTypes);
    }

    public String toString() {
        return "EffectiveNodeType [" + this.nodeTypes + "]";
    }

    public Optional<PropertyDefinition> getApplicablePropertyDefinition(@NotNull String name, boolean isMultiple, int type) {
        return this.getApplicablePropertyDefinition(pd -> !(isMultiple && isMultiple != pd.isMultiple() || type != pd.getRequiredType() && 0 != type && 0 != pd.getRequiredType()), name);
    }

    public Optional<PropertyDefinition> getApplicablePropertyDefinition(Predicate<PropertyDefinition> predicate, @NotNull String name) {
        List propertyDefinitions = this.nodeTypes.stream().flatMap(nt -> Arrays.stream(nt.getPropertyDefinitions())).collect(Collectors.toList());
        Optional<PropertyDefinition> namedPropertyDef = EffectiveNodeType.getApplicableItemDefinition(propertyDefinitions, predicate, name);
        if (!namedPropertyDef.isPresent()) {
            return EffectiveNodeType.getApplicableItemDefinition(propertyDefinitions, predicate, null);
        }
        return namedPropertyDef;
    }

    public Optional<NodeDefinition> getApplicableChildNodeDefinition(@NotNull String name, NodeType ... types) {
        return this.getApplicableChildNodeDefinition((NodeDefinition nd) -> Arrays.stream(nd.getRequiredPrimaryTypeNames()).allMatch(requiredPrimaryType -> Arrays.stream(types).anyMatch(providedType -> providedType.isNodeType(requiredPrimaryType))), name);
    }

    public Optional<NodeDefinition> getApplicableChildNodeDefinition(@NotNull Predicate<NodeDefinition> predicate, @NotNull String name) {
        List nodeDefinitions = this.nodeTypes.stream().flatMap(nt -> Arrays.stream(nt.getChildNodeDefinitions())).collect(Collectors.toList());
        Optional<NodeDefinition> namedNodeDef = EffectiveNodeType.getApplicableItemDefinition(nodeDefinitions, predicate, name);
        if (!namedNodeDef.isPresent()) {
            return EffectiveNodeType.getApplicableItemDefinition(nodeDefinitions, predicate, null);
        }
        return namedNodeDef;
    }

    private static <T extends ItemDefinition> Optional<T> getApplicableItemDefinition(List<T> itemDefinitions, Predicate<T> predicate, @Nullable String name) {
        Predicate<ItemDefinition> namePredicate = name != null ? pd -> name.equals(pd.getName()) : pd -> "*".equals(pd.getName());
        return itemDefinitions.stream().filter(predicate).filter(namePredicate).findFirst();
    }

    public Optional<String> getDefaultPrimaryChildNodeTypeName(@NotNull Node parent, @NotNull String nodeName) throws RepositoryException {
        Optional<NodeDefinition> nodeDefinition = this.getApplicableChildNodeDefinition((NodeDefinition nd) -> nd.getDefaultPrimaryType() != null, nodeName);
        return nodeDefinition.map(NodeDefinition::getDefaultPrimaryTypeName);
    }
}

