/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class DocViewNode {
    @NotNull
    public final String name;
    @NotNull
    public final String label;
    @NotNull
    public final Map<String, DocViewProperty> props = new HashMap<String, DocViewProperty>();
    @Nullable
    public String uuid;
    @Nullable
    public final String[] mixins;
    @Nullable
    public final String primary;

    public DocViewNode(@NotNull String name, @NotNull String label, String uuid, Map<String, DocViewProperty> props, String[] mixins, String primary) {
        this.name = name;
        this.label = label;
        this.uuid = uuid;
        this.mixins = mixins;
        this.primary = primary;
        this.props.putAll(props);
    }

    public DocViewNode(@NotNull String name, @NotNull String label, Attributes attributes, NamePathResolver npResolver) throws NamespaceException {
        this.name = name;
        this.label = label;
        String uuid = null;
        String primary = null;
        String[] mixins = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getType(i).equals("CDATA")) continue;
            Name pName = NameFactoryImpl.getInstance().create(attributes.getURI(i), ISO9075.decode((String)attributes.getLocalName(i)));
            DocViewProperty info = DocViewProperty.parse(npResolver.getJCRName(pName), attributes.getValue(i));
            this.props.put(info.name, info);
            if (pName.equals(NameConstants.JCR_UUID)) {
                uuid = info.values[0];
                continue;
            }
            if (pName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                primary = info.values[0];
                continue;
            }
            if (!pName.equals(NameConstants.JCR_MIXINTYPES)) continue;
            mixins = info.values;
        }
        this.uuid = uuid;
        this.mixins = mixins;
        this.primary = primary;
    }

    public String[] getValues(String name) {
        DocViewProperty prop = this.props.get(name);
        return prop == null ? null : prop.values;
    }

    public String getValue(String name) {
        DocViewProperty prop = this.props.get(name);
        return prop == null ? null : prop.values[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + Arrays.hashCode(this.mixins);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.primary == null ? 0 : this.primary.hashCode());
        result = 31 * result + this.props.hashCode();
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocViewNode other = (DocViewNode)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (!Arrays.equals(this.mixins, other.mixins)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.primary == null ? other.primary != null : !this.primary.equals(other.primary)) {
            return false;
        }
        if (!this.props.equals(other.props)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return "DocViewNode [name=" + this.name + ", label=" + this.label + ", props=" + this.props + ", uuid=" + this.uuid + ", mixins=" + Arrays.toString(this.mixins) + ", primary=" + this.primary + "]";
    }
}

