/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSInstallState;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageStatus;
import org.jetbrains.annotations.NotNull;

class FSInstallStateCache
extends AbstractMap<PackageId, FSInstallState> {
    private static final String META_EXTENSION = ".xml";
    private final Map<PackageId, FSInstallState> cache = new ConcurrentHashMap<PackageId, FSInstallState>();
    private boolean isInitialized = false;
    private Map<Path, PackageId> pathIdMapping = new ConcurrentHashMap<Path, PackageId>();
    private final Path homeDir;

    public FSInstallStateCache(Path homeDir) throws IOException {
        this.homeDir = homeDir;
        Files.createDirectories(homeDir, new FileAttribute[0]);
    }

    private synchronized void load() throws IOException {
        HashMap cacheEntries = new HashMap();
        HashMap idMapping = new HashMap();
        try (Stream<Path> stream = Files.walk(this.homeDir, 10, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(META_EXTENSION)).forEach((? super T p) -> {
                PackageId id;
                FSInstallState state;
                try {
                    state = FSInstallState.fromFile(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (state != null && (id = state.getPackageId()) != null) {
                    cacheEntries.put(id, state);
                    idMapping.put(state.getFilePath(), id);
                }
            });
        }
        this.cache.putAll(cacheEntries);
        this.pathIdMapping.putAll(idMapping);
        this.isInitialized = true;
    }

    @Override
    public Set<Map.Entry<PackageId, FSInstallState>> entrySet() {
        if (!this.isInitialized) {
            try {
                this.load();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.cache.entrySet();
    }

    @NotNull
    private Path getPackageMetaDataFile(@NotNull PackageId id) {
        String path = AbstractPackageRegistry.getRelativeInstallationPath(id);
        return this.homeDir.resolve(path + META_EXTENSION);
    }

    @NotNull
    public Path getPackageFile(@NotNull PackageId id) {
        String path = AbstractPackageRegistry.getRelativeInstallationPath(id);
        return this.homeDir.resolve(path + ".zip");
    }

    public void updatePackageStatus(PackageId pid, FSPackageStatus targetStatus) throws IOException {
        FSInstallState state = this.get(pid);
        if (state == null) {
            throw new IllegalArgumentException("No package with pid " + pid + " registered");
        }
        Long installTime = state.getInstallationTime();
        if (FSPackageStatus.EXTRACTED == targetStatus) {
            installTime = Calendar.getInstance().getTimeInMillis();
        }
        FSInstallState targetState = new FSInstallState(pid, targetStatus, state.getFilePath()).withDependencies(state.getDependencies()).withSubPackages(state.getSubPackages()).withInstallTime(installTime).withSize(state.getSize()).withProperties(state.getProperties()).withExternal(state.isExternal());
        this.put(pid, targetState);
    }

    @Override
    public FSInstallState get(Object key) {
        FSInstallState state = (FSInstallState)super.get(key);
        if (state == null) {
            PackageId pid = (PackageId)key;
            Path metaFile = this.getPackageMetaDataFile(pid);
            try {
                state = FSInstallState.fromFile(metaFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (state != null) {
                this.cache.put(pid, state);
                this.pathIdMapping.put(state.getFilePath(), pid);
            }
        }
        return state;
    }

    @Override
    public FSInstallState put(PackageId key, FSInstallState value) {
        FSInstallState state = this.cache.put(key, value);
        try {
            value.save(this.getPackageMetaDataFile(key));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return state;
    }

    @Override
    public FSInstallState remove(Object key) {
        FSInstallState state = (FSInstallState)super.remove(key);
        if (state != null) {
            PackageId pid = (PackageId)key;
            Path metaData = this.getPackageMetaDataFile(pid);
            try {
                Files.delete(metaData);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return state;
    }

    public PackageId getIdForFile(Path file) {
        return this.pathIdMapping.get(file);
    }
}

