/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.ItemFilterSet;
import org.apache.jackrabbit.vault.fs.api.NodeNameList;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.PropertyValueArtifact;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.impl.io.JackrabbitACLImporter;
import org.apache.jackrabbit.vault.fs.impl.io.JcrSysViewTransformer;
import org.apache.jackrabbit.vault.fs.impl.io.NameSpace;
import org.apache.jackrabbit.vault.fs.impl.io.NodeStash;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrNamespaceHelper;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.EffectiveNodeType;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.util.RejectingEntityDefaultHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocViewSAXImporter
extends RejectingEntityDefaultHandler
implements NamespaceResolver {
    private static final String PROP_OAK_COUNTER = "oak:counter";
    static final Logger log = LoggerFactory.getLogger(DocViewSAXImporter.class);
    static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    static final Set<String> PROTECTED_PROPERTIES;
    private NameSpace nsStack = null;
    private final Session session;
    private final Node parentNode;
    private final String rootNodeName;
    private final int rootDepth;
    private StackElement stack;
    private final ItemFilterSet filter;
    private final WorkspaceFilter wspFilter;
    private Map<String, Map<String, BlobInfo>> binaries = new HashMap<String, Map<String, BlobInfo>>();
    private Set<String> hints = new HashSet<String>();
    private Set<String> preserveProperties = new HashSet<String>();
    private final DefaultNamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);
    private ImportInfoImpl importInfo = new ImportInfoImpl();
    private final ACLManagement aclManagement;
    private final UserManagement userManagement;
    private AccessControlHandling aclHandling = AccessControlHandling.IGNORE;
    private AccessControlHandling cugHandling = null;
    private final boolean snsSupported;
    private final JcrNamespaceHelper nsHelper;
    private final IdConflictPolicy idConflictPolicy;

    public DocViewSAXImporter(Node parentNode, String rootNodeName, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter, IdConflictPolicy idConflictPolicy) throws RepositoryException {
        this.filter = artifacts.getCoverage();
        this.wspFilter = wspFilter;
        this.parentNode = parentNode;
        this.rootDepth = parentNode.getDepth() + 1;
        this.session = parentNode.getSession();
        this.rootNodeName = rootNodeName;
        this.aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
        this.userManagement = ServiceProviderFactory.getProvider().getUserManagement();
        this.snsSupported = this.session.getRepository().getDescriptorValue("node.type.management.same.name.siblings.supported").getBoolean();
        this.nsHelper = new JcrNamespaceHelper(this.session, null);
        this.idConflictPolicy = idConflictPolicy;
        String rootPath = parentNode.getPath();
        if (!rootPath.equals("/")) {
            rootPath = rootPath + "/";
        }
        for (Artifact a : artifacts.values(ArtifactType.BINARY)) {
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.FILE)) {
            if (a.getSerializationType() == SerializationType.XML_DOCVIEW) continue;
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.HINT)) {
            this.hints.add(rootPath + a.getRelativePath());
        }
    }

    public AccessControlHandling getAclHandling() {
        return this.aclHandling;
    }

    public void setAclHandling(AccessControlHandling aclHandling) {
        this.aclHandling = aclHandling;
    }

    public AccessControlHandling getCugHandling() {
        return this.cugHandling;
    }

    public void setCugHandling(AccessControlHandling cugHandling) {
        this.cugHandling = cugHandling;
    }

    private void registerBinary(Artifact a, String rootPath) throws RepositoryException {
        String path = rootPath + a.getRelativePath();
        int idx = -1;
        int pos = path.indexOf(91, path.lastIndexOf(47));
        if (pos > 0) {
            idx = Integer.parseInt(path.substring(pos + 1, path.length() - 1));
            path = path.substring(0, pos);
        }
        if (a.getType() == ArtifactType.FILE && a instanceof PropertyValueArtifact) {
            String parentPath = ((PropertyValueArtifact)a).getProperty().getParent().getPath();
            this.preserveProperties.add(parentPath + "/" + "jcr:data");
            this.preserveProperties.add(parentPath + "/" + "jcr:lastModified");
        } else {
            BlobInfo info;
            this.preserveProperties.add(path);
            this.preserveProperties.add(path + "/jcr:content/jcr:data");
            this.preserveProperties.add(path + "/jcr:content/jcr:lastModified");
            this.preserveProperties.add(path + "/jcr:content/jcr:mimeType");
            String parentPath = Text.getRelativeParent((String)path, (int)1);
            String name = Text.getName((String)path);
            Map<String, BlobInfo> infoSet = this.binaries.get(parentPath);
            if (infoSet == null) {
                infoSet = new HashMap<String, BlobInfo>();
                this.binaries.put(parentPath, infoSet);
            }
            if ((info = infoSet.get(name)) == null) {
                info = new BlobInfo(idx >= 0);
                infoSet.put(name, info);
            }
            if (idx >= 0) {
                info.add(idx, a);
            } else {
                info.add(a);
            }
        }
        log.trace("scheduling binary: {}{}", (Object)rootPath, (Object)(a.getRelativePath() + a.getExtension()));
    }

    private boolean isIncluded(Item item, int depth) throws RepositoryException {
        String path = this.importInfo.getRemapped().map(item.getPath());
        return this.wspFilter.contains(path) && (depth == 0 || this.filter.contains(item, path, depth));
    }

    public ImportInfoImpl getInfo() {
        return this.importInfo;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.stack = new StackElement(this.parentNode, this.parentNode.isNew());
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.stack.isRoot()) {
            throw new IllegalStateException("stack mismatch");
        }
        for (String parentPath : this.binaries.keySet()) {
            Map<String, BlobInfo> blobs = this.binaries.get(parentPath);
            log.trace("processing binaries at {}", (Object)parentPath);
            try {
                Node fNode;
                BlobInfo info;
                Node node;
                if (this.session.nodeExists(parentPath)) {
                    node = this.session.getNode(parentPath);
                    for (String propName : blobs.keySet()) {
                        info = blobs.get(propName);
                        if (node.hasNode(propName)) {
                            this.handleBinNode(node.getNode(propName), info, true);
                            continue;
                        }
                        if (info.isFile()) {
                            fNode = node.addNode(propName, "nt:file");
                            this.importInfo.onCreated(fNode.getPath());
                            this.handleBinNode(fNode, info, false);
                            continue;
                        }
                        if (info.isMulti) {
                            node.setProperty(propName, info.getValues(this.session));
                        } else {
                            node.setProperty(propName, info.getValue(this.session));
                        }
                        this.importInfo.onModified(node.getPath());
                    }
                    continue;
                }
                log.warn("binaries parent path does not exist: {}", (Object)parentPath);
                node = null;
                for (String propName : blobs.keySet()) {
                    info = blobs.get(propName);
                    if (!info.isFile()) continue;
                    if (node == null) {
                        node = this.createNodeDeep(parentPath);
                    }
                    fNode = node.addNode(propName, "nt:file");
                    this.importInfo.onCreated(fNode.getPath());
                    this.handleBinNode(fNode, info, false);
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private Node createNodeDeep(String path) throws RepositoryException {
        Node node;
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        int idx = path.lastIndexOf(47);
        if (idx <= 0) {
            return this.session.getRootNode();
        }
        String parentPath = path.substring(0, idx);
        String name = path.substring(idx + 1);
        Node parentNode = this.createNodeDeep(parentPath);
        try {
            node = parentNode.addNode(name);
        }
        catch (RepositoryException e) {
            node = parentNode.addNode(name, "nt:folder");
        }
        this.importInfo.onCreated(node.getPath());
        return node;
    }

    private void handleBinNode(Node node, BlobInfo info, boolean checkIfNtFileOk) throws RepositoryException, IOException {
        log.trace("handling binary file at {}", (Object)node.getPath());
        if (info.isMulti) {
            throw new IllegalStateException("unable to add MV binary to node " + node.getPath());
        }
        if (checkIfNtFileOk) {
            if (node.isNodeType("nt:file")) {
                node = node.hasNode("jcr:content") ? node.getNode("jcr:content") : node.addNode("jcr:content", "nt:resource");
            }
        } else {
            node = node.addNode("jcr:content", "nt:resource");
        }
        Artifact a = (Artifact)info.artifacts.get(0);
        boolean modified = false;
        ValueFactory factory = node.getSession().getValueFactory();
        try (InputStream input = a.getInputStream();){
            Value value = factory.createValue(input);
            if (node.hasProperty("jcr:data")) {
                Property data = node.getProperty("jcr:data");
                if (!value.equals(data.getValue())) {
                    data.setValue(value);
                    this.importInfo.onModified(data.getPath());
                    modified = true;
                }
            } else {
                Property data = node.setProperty("jcr:data", value);
                this.importInfo.onCreated(data.getPath());
                modified = true;
            }
        }
        if (!node.hasProperty("jcr:lastModified") || modified) {
            Calendar lastModified = Calendar.getInstance();
            node.setProperty("jcr:lastModified", lastModified);
            modified = true;
        }
        if (!node.hasProperty("jcr:mimeType")) {
            String mimeType = a.getContentType();
            if (mimeType == null) {
                mimeType = Text.getName((String)a.getRelativePath(), (char)'.');
                mimeType = MimeTypes.getMimeType(mimeType, "application/octet-stream");
            }
            node.setProperty("jcr:mimeType", mimeType);
            modified = true;
        }
        if (node.isNew()) {
            this.importInfo.onCreated(node.getPath());
        } else if (modified) {
            this.importInfo.onModified(node.getPath());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String oldPrefix;
        log.trace("-> prefixMapping for {}:{}", (Object)prefix, (Object)uri);
        NameSpace ns = new NameSpace(prefix, uri);
        ns.next = this.nsStack;
        this.nsStack = ns;
        try {
            oldPrefix = this.session.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                oldPrefix = this.nsHelper.registerNamespace(prefix, uri);
            }
            catch (RepositoryException e1) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (!oldPrefix.equals(prefix)) {
            try {
                this.session.setNamespacePrefix(prefix, uri);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        log.trace("<- prefixMapping for {}", (Object)prefix);
        NameSpace ns = this.nsStack;
        NameSpace prev = null;
        while (ns != null && !ns.prefix.equals(prefix)) {
            prev = ns;
            ns = ns.next;
        }
        if (ns == null) {
            throw new SAXException("Illegal state: prefix " + prefix + " never mapped.");
        }
        if (prev == null) {
            this.nsStack = ns.next;
        } else {
            prev.next = ns.next;
        }
        ns = ns.next;
        while (ns != null && !ns.prefix.equals(prefix)) {
            ns = ns.next;
        }
        if (ns != null) {
            try {
                this.session.setNamespacePrefix(prefix, ns.uri);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
            log.trace("   remapped: {}:{}", (Object)prefix, (Object)ns.uri);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block26: {
            String label = ISO9075.decode((String)qName);
            if (this.stack.isRoot() && localName.equals(NameConstants.JCR_ROOT.getLocalName()) && uri.equals(NameConstants.JCR_ROOT.getNamespaceURI())) {
                label = this.rootNodeName;
            }
            String name = label;
            log.trace("-> element {}", (Object)label);
            boolean snsNode = false;
            int idx = name.lastIndexOf(91);
            if (idx > 0) {
                int idx2;
                if (!this.snsSupported && (idx2 = name.indexOf(93, idx)) > 0) {
                    try {
                        if (Integer.valueOf(name.substring(idx + 1, idx2)) > 1) {
                            snsNode = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                name = name.substring(0, idx);
            }
            try {
                this.stack.addName(label);
                Node node = this.stack.getNode();
                if (node == null) {
                    this.stack = this.stack.push();
                    DocViewAdapter xform = this.stack.getAdapter();
                    if (xform != null) {
                        DocViewNode ni = new DocViewNode(name, label, attributes, (NamePathResolver)this.npResolver);
                        xform.startNode(ni);
                    } else {
                        log.trace("Skipping ignored element {}", (Object)name);
                    }
                    break block26;
                }
                String path = (!node.getPath().equals("/") ? node.getPath() : "") + "/" + name;
                if (attributes.getLength() == 0) {
                    log.trace("Skipping empty node {}", (Object)path);
                    this.stack = this.stack.push();
                    break block26;
                }
                if (snsNode) {
                    log.warn("Skipping unsupported SNS node with index > 1. Some content will be missing after import: {}", (Object)path);
                    this.stack = this.stack.push();
                    break block26;
                }
                try {
                    DocViewNode ni = new DocViewNode(name, label, attributes, (NamePathResolver)this.npResolver);
                    if (this.aclManagement.isACLNodeType(ni.primary)) {
                        AccessControlHandling acHandling = this.getAcHandling(label);
                        if (acHandling != AccessControlHandling.CLEAR && acHandling != AccessControlHandling.IGNORE) {
                            log.trace("Access control policy element detected. starting special transformation {}/{}", (Object)node.getPath(), (Object)name);
                            if (this.aclManagement.ensureAccessControllable(node, ni.primary)) {
                                log.debug("Adding access control policy element to non access-controllable parent - adding mixin: {}", (Object)node.getPath());
                            }
                            this.stack = this.stack.push();
                            if ("rep:repoPolicy".equals(name)) {
                                if (node.getDepth() == 0) {
                                    this.stack.adapter = new JackrabbitACLImporter(this.session, acHandling);
                                    this.stack.adapter.startNode(ni);
                                } else {
                                    log.debug("ignoring invalid location for repository level ACL: {}", (Object)node.getPath());
                                }
                            } else {
                                this.stack.adapter = new JackrabbitACLImporter(node, acHandling);
                                this.stack.adapter.startNode(ni);
                            }
                        } else {
                            this.stack = this.stack.push();
                        }
                        break block26;
                    }
                    if (this.userManagement != null && this.userManagement.isAuthorizableNodeType(ni.primary)) {
                        this.handleAuthorizable(node, ni);
                        break block26;
                    }
                    this.stack = this.stack.push(this.addNode(ni));
                }
                catch (IOException | RepositoryException e) {
                    if (e instanceof ConstraintViolationException && this.wspFilter.getImportMode(path) != ImportMode.REPLACE) {
                        log.warn("Error during processing of {}: {}, skip node due to import mode {}", new Object[]{path, e.toString(), this.wspFilter.getImportMode(path)});
                        this.importInfo.onNop(path);
                    } else {
                        log.error("Error during processing of {}: {}", (Object)path, (Object)e.toString());
                        this.importInfo.onError(path, (Exception)e);
                    }
                    this.stack = this.stack.push();
                }
            }
            catch (RepositoryException e) {
                throw new SAXException("Fatal exception while parsing", (Exception)((Object)e));
            }
        }
    }

    private void handleAuthorizable(Node node, DocViewNode ni) throws RepositoryException, SAXException {
        String id = this.userManagement.getAuthorizableId(ni);
        String newPath = node.getPath() + "/" + ni.name;
        boolean isIncluded = this.wspFilter.contains(newPath);
        String oldPath = this.userManagement.getAuthorizablePath(this.session, id);
        if (oldPath == null) {
            if (!isIncluded) {
                log.trace("auto-creating authorizable node not in filter {}", (Object)newPath);
            }
            log.trace("Authorizable element detected. starting sysview transformation {}", (Object)newPath);
            this.stack = this.stack.push();
            this.stack.adapter = new JcrSysViewTransformer(node, this.wspFilter.getImportMode(newPath));
            this.stack.adapter.startNode(ni);
            this.importInfo.onCreated(newPath);
            return;
        }
        Node authNode = this.session.getNode(oldPath);
        ImportMode mode = this.wspFilter.getImportMode(newPath);
        if (mode != ImportMode.REPLACE || !isIncluded) {
            this.importInfo.onRemapped(oldPath, newPath);
        }
        if (!isIncluded) {
            this.stack = this.stack.push(new StackElement(authNode, false));
            this.importInfo.onNop(oldPath);
            return;
        }
        switch (mode) {
            case MERGE: 
            case MERGE_PROPERTIES: {
                DocViewProperty prop = ni.props.get("rep:members");
                if (prop != null) {
                    this.importInfo.registerMemberships(id, prop.values);
                }
                log.debug("Skipping import of existing authorizable '{}' due to MERGE import mode.", (Object)id);
                this.stack = this.stack.push(new StackElement(authNode, false));
                this.importInfo.onNop(newPath);
                break;
            }
            case REPLACE: {
                log.trace("Authorizable element detected. starting sysview transformation {}", (Object)newPath);
                this.stack = this.stack.push();
                this.stack.adapter = new JcrSysViewTransformer(node, mode);
                this.stack.adapter.startNode(ni);
                this.importInfo.onReplaced(newPath);
                break;
            }
            case UPDATE: 
            case UPDATE_PROPERTIES: {
                log.trace("Authorizable element detected. starting sysview transformation {}", (Object)newPath);
                this.stack = this.stack.push();
                this.stack.adapter = new JcrSysViewTransformer(node, oldPath, mode);
                String newName = Text.getName((String)oldPath);
                DocViewNode mapped = new DocViewNode(newName, newName, ni.uuid, ni.props, ni.mixins, ni.primary);
                if (authNode.hasProperty("rep:authorizableId")) {
                    DocViewProperty authId = new DocViewProperty("rep:authorizableId", new String[]{authNode.getProperty("rep:authorizableId").getString()}, false, 1);
                    mapped.props.put(authId.name, authId);
                }
                this.stack.adapter.startNode(mapped);
                this.importInfo.onReplaced(newPath);
            }
        }
    }

    private StackElement addNode(DocViewNode ni) throws RepositoryException, IOException {
        boolean isNew;
        Node existingNode;
        Node currentNode;
        block22: {
            currentNode = this.stack.getNode();
            existingNode = null;
            if ("".equals(ni.label)) {
                existingNode = currentNode;
            } else {
                if (this.stack.checkForNode() && currentNode.hasNode(ni.label)) {
                    existingNode = currentNode.getNode(ni.label);
                }
                if (ni.uuid != null && this.idConflictPolicy == IdConflictPolicy.FAIL) {
                    try {
                        Node sameIdNode = this.session.getNodeByIdentifier(ni.uuid);
                        if (existingNode != null && existingNode.getPath().equals(sameIdNode.getPath())) {
                            log.debug("Node with existing identifier {} at {} is being updated without modifying its uuid", (Object)ni.uuid, (Object)existingNode.getPath());
                            break block22;
                        }
                        if (this.isIncluded((Item)sameIdNode, 0)) {
                            log.warn("Node identifier {} for to-be imported node {}/{} already taken by {}, trying to release it.", new Object[]{ni.uuid, currentNode.getPath(), ni.label, sameIdNode.getPath()});
                            this.removeReferences(sameIdNode);
                            this.session.removeItem(sameIdNode.getPath());
                            existingNode = null;
                            break block22;
                        }
                        throw new ReferentialIntegrityException("UUID " + ni.uuid + " already taken by node " + sameIdNode.getPath());
                    }
                    catch (ItemNotFoundException sameIdNode) {
                        // empty catch block
                    }
                }
            }
        }
        DocViewProperty coProp = ni.props.remove("jcr:isCheckedOut");
        boolean isCheckedIn = coProp != null && "false".equals(coProp.values[0]);
        boolean bl = isNew = existingNode == null;
        if (isNew) {
            if (!ni.props.containsKey("jcr:mixinTypes")) {
                ni.props.put("jcr:mixinTypes", new DocViewProperty("jcr:mixinTypes", new String[0], true, 7));
            }
            this.stack.ensureCheckedOut();
            existingNode = this.createNewNode(currentNode, ni);
            if (existingNode.getDefinition() == null) {
                throw new RepositoryException("Child node not allowed.");
            }
            if (existingNode.isNodeType("nt:resource")) {
                if (!existingNode.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(existingNode.getPath() + "/" + "jcr:data");
                }
            } else if (isCheckedIn) {
                this.importInfo.registerToVersion(existingNode.getPath());
            }
            this.importInfo.onCreated(existingNode.getPath());
        } else if (this.isIncluded((Item)existingNode, existingNode.getDepth() - this.rootDepth)) {
            ImportMode importMode;
            Node updatedNode;
            if (isCheckedIn) {
                this.importInfo.registerToVersion(existingNode.getPath());
            }
            if ((updatedNode = this.updateExistingNode(existingNode, ni, importMode = this.wspFilter.getImportMode(existingNode.getPath()))) != null) {
                if (updatedNode.isNodeType("nt:resource") && !updatedNode.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(existingNode.getPath() + "/" + "jcr:data");
                }
                this.importInfo.onModified(updatedNode.getPath());
                existingNode = updatedNode;
            } else {
                this.importInfo.onNop(existingNode.getPath());
            }
        } else {
            this.binaries.remove(existingNode.getPath());
        }
        return new StackElement(existingNode, isNew);
    }

    public void removeReferences(@NotNull Node node) throws ReferentialIntegrityException, RepositoryException {
        ArrayList<String> removableReferencePaths = new ArrayList<String>();
        PropertyIterator pIter = node.getReferences();
        while (pIter.hasNext()) {
            Property referenceProperty = pIter.nextProperty();
            if (this.isIncluded((Item)referenceProperty, 0) || this.idConflictPolicy == IdConflictPolicy.FORCE_REMOVE_CONFLICTING_ID) {
                removableReferencePaths.add(referenceProperty.getPath());
                continue;
            }
            throw new ReferentialIntegrityException("Found non-removable reference for conflicting UUID " + node.getIdentifier() + " (" + node.getPath() + ") at " + referenceProperty.getPath());
        }
        for (String referencePath : removableReferencePaths) {
            log.info("Remove reference towards {} at {}", (Object)node.getIdentifier(), (Object)referencePath);
            this.session.removeItem(referencePath);
        }
    }

    @Nullable
    private Node updateExistingNode(@NotNull Node node, @NotNull DocViewNode ni, @NotNull ImportMode importMode) throws RepositoryException {
        VersioningState vs = new VersioningState(this.stack, node);
        Node updatedNode = null;
        if (ni.uuid != null && !node.getIdentifier().equals(ni.uuid) && !"rep:root".equals(ni.primary)) {
            NodeStash stash = new NodeStash(this.session, node.getPath());
            stash.stash();
            Node parent = node.getParent();
            this.removeReferences(node);
            node.remove();
            updatedNode = this.createNewNode(parent, ni);
            stash.recover(importMode, this.importInfo);
        } else {
            if (importMode == ImportMode.REPLACE && !"rep:root".equals(ni.primary) && !node.getPrimaryNodeType().getName().equals(ni.primary)) {
                vs.ensureCheckedOut();
                node.setPrimaryType(ni.primary);
                updatedNode = node;
            }
            HashSet<Object> newMixins = new HashSet<Object>();
            AccessControlHandling acHandling = this.getAcHandling(ni.name);
            if (ni.mixins != null) {
                for (String mixin : ni.mixins) {
                    if (this.aclManagement.isAccessControllableMixin(mixin) && acHandling == AccessControlHandling.CLEAR) continue;
                    newMixins.add(mixin);
                }
            }
            if (importMode == ImportMode.REPLACE) {
                for (NodeType mix : node.getMixinNodeTypes()) {
                    String name = mix.getName();
                    if (newMixins.remove(name) || this.aclManagement.isAccessControllableMixin(name) && acHandling != AccessControlHandling.CLEAR && acHandling != AccessControlHandling.OVERWRITE) continue;
                    vs.ensureCheckedOut();
                    node.removeMixin(name);
                    updatedNode = node;
                }
            }
            for (String string : newMixins) {
                vs.ensureCheckedOut();
                node.addMixin(string);
                updatedNode = node;
            }
            if (importMode == ImportMode.REPLACE) {
                PropertyIterator pIter = node.getProperties();
                while (pIter.hasNext()) {
                    Property property = pIter.nextProperty();
                    String propName = property.getName();
                    if (property.getDefinition().isProtected() || ni.props.containsKey(propName) || this.preserveProperties.contains(property.getPath()) || !this.wspFilter.includesProperty(property.getPath())) continue;
                    vs.ensureCheckedOut();
                    property.remove();
                    updatedNode = node;
                }
            }
            if (this.setUnprotectedProperties(node, ni, importMode == ImportMode.REPLACE || importMode == ImportMode.UPDATE || importMode == ImportMode.UPDATE_PROPERTIES, vs)) {
                updatedNode = node;
            }
        }
        return updatedNode;
    }

    @NotNull
    private Node createNewNode(Node parentNode, DocViewNode ni) throws RepositoryException {
        int importUuidBehavior;
        switch (this.idConflictPolicy) {
            case CREATE_NEW_ID: {
                importUuidBehavior = 0;
                break;
            }
            case FORCE_REMOVE_CONFLICTING_ID: {
                importUuidBehavior = 1;
                break;
            }
            default: {
                importUuidBehavior = 3;
            }
        }
        try {
            String parentPath = parentNode.getPath();
            ContentHandler handler = this.session.getImportContentHandler(parentPath, importUuidBehavior);
            String[] prefixes = this.session.getNamespacePrefixes();
            handler.startDocument();
            for (String string : prefixes) {
                handler.startPrefixMapping(string, this.session.getNamespaceURI(string));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", ni.name);
            handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
            boolean addMixRef = false;
            if (!ni.label.equals(ni.name) && ni.uuid == null) {
                ni.uuid = UUID.randomUUID().toString();
                ni.props.put("jcr:uuid", new DocViewProperty("jcr:uuid", new String[]{ni.uuid}, false, 1));
                DocViewProperty mix = ni.props.get("jcr:mixinTypes");
                addMixRef = true;
                if (mix == null) {
                    mix = new DocViewProperty("jcr:mixinTypes", new String[]{"mix:referenceable"}, true, 7);
                    ni.props.put(mix.name, mix);
                } else {
                    for (String v : mix.values) {
                        if (!v.equals("mix:referenceable")) continue;
                        addMixRef = false;
                        break;
                    }
                    if (addMixRef) {
                        String[] stringArray = new String[mix.values.length + 1];
                        System.arraycopy(mix.values, 0, stringArray, 0, mix.values.length);
                        stringArray[mix.values.length] = "mix:referenceable";
                        mix = new DocViewProperty("jcr:mixinTypes", stringArray, true, 7);
                        ni.props.put(mix.name, mix);
                    }
                }
            }
            for (DocViewProperty docViewProperty : ni.props.values()) {
                if (docViewProperty == null || docViewProperty.values == null || !PROTECTED_PROPERTIES.contains(docViewProperty.name)) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", docViewProperty.name);
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue((int)docViewProperty.type));
                handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
                for (String v : docViewProperty.values) {
                    handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", EMPTY_ATTRIBUTES);
                    handler.characters(v.toCharArray(), 0, v.length());
                    handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
                }
                handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
            }
            handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
            handler.endDocument();
            Node node = this.getNodeByUUIDLabelOrName(parentNode, ni, importUuidBehavior == 0);
            this.setUnprotectedProperties(node, ni, true, null);
            if (addMixRef) {
                node.removeMixin("mix:referenceable");
            }
            return node;
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                if (root instanceof ConstraintViolationException) {
                    try {
                        Node node = this.getNodeByUUIDLabelOrName(parentNode, ni, importUuidBehavior == 0);
                        node.remove();
                    }
                    catch (RepositoryException repositoryException) {
                        // empty catch block
                    }
                }
                throw (RepositoryException)((Object)root);
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new RepositoryException("Error while creating node", (Throwable)root);
        }
    }

    private static boolean isPropertyProtected(@NotNull EffectiveNodeType effectiveNodeType, @NotNull DocViewProperty docViewProperty) throws RepositoryException {
        return effectiveNodeType.getApplicablePropertyDefinition(docViewProperty.name, docViewProperty.isMulti, docViewProperty.type).map(ItemDefinition::isProtected).orElse(false);
    }

    private Node getNodeByUUIDLabelOrName(@NotNull Node currentNode, @NotNull DocViewNode ni, boolean isUuidNewlyAssigned) throws RepositoryException {
        Node node = null;
        if (ni.uuid != null && !isUuidNewlyAssigned) {
            try {
                node = currentNode.getSession().getNodeByUUID(ni.uuid);
            }
            catch (RepositoryException e) {
                log.warn("Newly created node not found by uuid {}: {}", (Object)(currentNode.getPath() + "/" + ni.name), (Object)e.toString());
            }
        }
        if (node == null) {
            try {
                node = currentNode.getNode(ni.label);
            }
            catch (RepositoryException e) {
                log.warn("Newly created node not found by label {}: {}", (Object)(currentNode.getPath() + "/" + ni.name), (Object)e.toString());
            }
        }
        if (node == null) {
            try {
                node = currentNode.getNode(ni.name);
            }
            catch (RepositoryException e) {
                log.warn("Newly created node not found by name {}: {}", (Object)(currentNode.getPath() + "/" + ni.name), (Object)e.toString());
                throw e;
            }
        }
        return node;
    }

    private boolean setUnprotectedProperties(@NotNull Node node, @NotNull DocViewNode ni, boolean overwriteExistingProperties, @Nullable VersioningState vs) throws RepositoryException {
        boolean isAtomicCounter = false;
        if (ni.mixins != null) {
            for (String mixin : ni.mixins) {
                if (!"mix:atomicCounter".equals(mixin)) continue;
                isAtomicCounter = true;
            }
        }
        EffectiveNodeType effectiveNodeType = EffectiveNodeType.ofNode(node);
        boolean modified = false;
        for (DocViewProperty prop : ni.props.values()) {
            if (prop == null || DocViewSAXImporter.isPropertyProtected(effectiveNodeType, prop) || !overwriteExistingProperties && node.hasProperty(prop.name) || !this.wspFilter.includesProperty(node.getPath() + "/" + prop.name)) continue;
            try {
                modified |= prop.apply(node);
            }
            catch (RepositoryException e) {
                try {
                    if (vs == null) {
                        throw e;
                    }
                    vs.ensureCheckedOut();
                    modified |= prop.apply(node);
                }
                catch (RepositoryException e1) {
                    if (this.wspFilter.getImportMode(node.getPath()) != ImportMode.REPLACE) {
                        log.warn("Error while setting property {} (ignore due to mode {}): {}", new Object[]{prop.name, this.wspFilter.getImportMode(node.getPath()), e1});
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (isAtomicCounter && this.wspFilter.includesProperty(node.getPath() + "/" + PROP_OAK_COUNTER)) {
            long previous = 0L;
            if (node.hasProperty(PROP_OAK_COUNTER)) {
                previous = node.getProperty(PROP_OAK_COUNTER).getLong();
            }
            long counter = 0L;
            try {
                counter = Long.valueOf(ni.getValue(PROP_OAK_COUNTER));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (counter != previous) {
                node.setProperty("oak:increment", counter - previous);
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        log.trace("<- element {}", (Object)qName);
        try {
            NodeNameList childNames = this.stack.getChildNames();
            Node node = this.stack.getNode();
            int numChildren = 0;
            if (node == null) {
                DocViewAdapter adapter = this.stack.getAdapter();
                if (adapter != null) {
                    adapter.endNode();
                }
                if (this.stack.adapter != null) {
                    List<String> createdPaths = this.stack.adapter.close();
                    for (String createdPath : createdPaths) {
                        this.importInfo.onCreated(createdPath);
                    }
                    this.stack.adapter = null;
                    log.trace("Sysview transformation complete.");
                }
            } else {
                NodeIterator iter = node.getNodes();
                while (iter.hasNext()) {
                    ++numChildren;
                    Node child = iter.nextNode();
                    String path = child.getPath();
                    String label = Text.getName((String)path);
                    AccessControlHandling acHandling = this.getAcHandling(child.getName());
                    if (!childNames.contains(label) && !this.hints.contains(path) && this.isIncluded((Item)child, child.getDepth() - this.rootDepth)) {
                        if (this.aclManagement.isACLNode(child)) {
                            if (acHandling != AccessControlHandling.OVERWRITE && acHandling != AccessControlHandling.CLEAR) continue;
                            this.importInfo.onDeleted(path);
                            this.aclManagement.clearACL(node);
                            continue;
                        }
                        if (this.wspFilter.getImportMode(path) != ImportMode.REPLACE) continue;
                        boolean shouldRemoveChild = true;
                        if (child.getDefinition().isProtected()) {
                            log.warn("Refuse to delete protected child node: {}", (Object)path);
                            shouldRemoveChild = false;
                        } else if (child.getDefinition().isMandatory() && !child.getDefinition().getName().equals("*")) {
                            EffectiveNodeType ent = EffectiveNodeType.ofNode(child.getParent());
                            Optional<NodeDefinition> childNodeDefinition = ent.getApplicableChildNodeDefinition(child.getName(), child.getPrimaryNodeType());
                            if (!childNodeDefinition.isPresent()) {
                                throw new IllegalStateException("Could not find applicable child node definition for mandatory child node " + child.getPath());
                            }
                            if (!this.hasSiblingWithPrimaryTypesAndName(child, childNodeDefinition.get().getRequiredPrimaryTypes(), childNodeDefinition.get().getName())) {
                                log.warn("Refuse to delete mandatory non-residual child node: {} with no other matching siblings", (Object)path);
                                shouldRemoveChild = false;
                            }
                        }
                        if (!shouldRemoveChild) continue;
                        this.importInfo.onDeleted(path);
                        child.remove();
                        continue;
                    }
                    if (acHandling != AccessControlHandling.CLEAR || !this.aclManagement.isACLNode(child) || !this.isIncluded((Item)child, child.getDepth() - this.rootDepth)) continue;
                    this.importInfo.onDeleted(path);
                    this.aclManagement.clearACL(node);
                }
                if (this.isIncluded((Item)node, node.getDepth() - this.rootDepth)) {
                    this.stack.restoreOrder();
                }
            }
            this.stack = this.stack.pop();
            if (node != null && (numChildren == 0 && !childNames.isEmpty() || this.stack.isRoot())) {
                this.importInfo.addNameList(node.getPath(), childNames);
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    private boolean hasSiblingWithPrimaryTypesAndName(Node node, NodeType[] requiredPrimaryNodeTypes, String requiredName) throws RepositoryException {
        NodeIterator iter = node.getParent().getNodes();
        while (iter.hasNext()) {
            Node sibling = iter.nextNode();
            if (sibling.isSame((Item)node)) continue;
            boolean allTypesMatch = true;
            for (NodeType requiredPrimaryNodeType : requiredPrimaryNodeTypes) {
                allTypesMatch &= sibling.isNodeType(requiredPrimaryNodeType.getName());
            }
            if (!allTypesMatch || !requiredName.equals("*") && !requiredName.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.session.getNamespaceURI(prefix);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.session.getNamespacePrefix(uri);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    @NotNull
    private AccessControlHandling getAcHandling(@NotNull String nodeName) {
        if (this.cugHandling != null && "rep:cugPolicy".equals(nodeName)) {
            return this.cugHandling;
        }
        return this.aclHandling;
    }

    static {
        HashSet<String> props = new HashSet<String>();
        props.add("jcr:primaryType");
        props.add("jcr:mixinTypes");
        props.add("jcr:uuid");
        props.add("jcr:isCheckedOut");
        props.add("jcr:baseVersion");
        props.add("jcr:predecessors");
        props.add("jcr:successors");
        props.add("jcr:versionHistory");
        PROTECTED_PROPERTIES = Collections.unmodifiableSet(props);
    }

    private class StackElement {
        private final Node node;
        private StackElement parent;
        private final NodeNameList childNames = new NodeNameList();
        private boolean isCheckedOut;
        private boolean isNew;
        private DocViewAdapter adapter;

        public StackElement(Node node, boolean isNew) throws RepositoryException {
            this.node = node;
            this.isNew = isNew;
            this.isCheckedOut = node == null || !node.isNodeType("mix:versionable") || node.isCheckedOut();
        }

        public Node getNode() {
            return this.node;
        }

        public boolean isCheckedOut() {
            return this.isCheckedOut && (this.parent == null || this.parent.isCheckedOut());
        }

        public void ensureCheckedOut() throws RepositoryException {
            if (!this.isCheckedOut) {
                DocViewSAXImporter.this.importInfo.registerToVersion(this.node.getPath());
                try {
                    this.node.checkout();
                }
                catch (RepositoryException e) {
                    log.warn("error while checkout node (ignored)", (Throwable)e);
                }
                this.isCheckedOut = true;
            }
            if (this.parent != null) {
                this.parent.ensureCheckedOut();
            }
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean checkForNode() {
            return !this.isNew || this.parent == null;
        }

        public void addName(String name) {
            this.childNames.addName(name);
        }

        public NodeNameList getChildNames() {
            return this.childNames;
        }

        public void restoreOrder() throws RepositoryException {
            if (this.checkForNode() && this.childNames.needsReorder(this.node)) {
                this.ensureCheckedOut();
                this.childNames.restoreOrder(this.node);
            }
        }

        public StackElement push() throws RepositoryException {
            return this.push(new StackElement(null, false));
        }

        public StackElement push(StackElement elem) throws RepositoryException {
            elem.parent = this;
            return elem;
        }

        public StackElement pop() {
            return this.parent;
        }

        public DocViewAdapter getAdapter() {
            if (this.adapter != null) {
                return this.adapter;
            }
            return this.parent == null ? null : this.parent.getAdapter();
        }
    }

    private class VersioningState {
        private final StackElement stack;
        private final Node node;
        private boolean isCheckedOut;
        private boolean isParentCheckedOut;

        private VersioningState(StackElement stack, Node node) throws RepositoryException {
            this.stack = stack;
            this.node = node;
            this.isCheckedOut = node == null || !node.isNodeType("mix:versionable") || node.isCheckedOut();
            this.isParentCheckedOut = stack.isCheckedOut();
        }

        public void ensureCheckedOut() throws RepositoryException {
            if (!this.isCheckedOut) {
                DocViewSAXImporter.this.importInfo.registerToVersion(this.node.getPath());
                try {
                    this.node.checkout();
                }
                catch (RepositoryException e) {
                    log.warn("error while checkout node (ignored)", (Throwable)e);
                }
                this.isCheckedOut = true;
            }
            if (!this.isParentCheckedOut) {
                this.stack.ensureCheckedOut();
                this.isParentCheckedOut = true;
            }
        }
    }

    private static class BlobInfo {
        private final boolean isMulti;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public BlobInfo(boolean multi) {
            this.isMulti = multi;
        }

        public boolean isFile() {
            return this.artifacts.size() > 0 && this.artifacts.get(0).getType() == ArtifactType.FILE;
        }

        public void add(Artifact a) {
            assert (this.artifacts.isEmpty());
            this.artifacts.add(a);
        }

        public void add(int idx, Artifact a) {
            while (idx >= this.artifacts.size()) {
                this.artifacts.add(null);
            }
            this.artifacts.set(idx, a);
        }

        public Value[] getValues(Session session) throws RepositoryException, IOException {
            Value[] values = new Value[this.artifacts.size()];
            for (int i = 0; i < values.length; ++i) {
                Artifact a = this.artifacts.get(i);
                try (InputStream input = a.getInputStream();){
                    values[i] = session.getValueFactory().createValue(input);
                    continue;
                }
            }
            return values;
        }

        public Value getValue(Session session) throws RepositoryException, IOException {
            Artifact a = this.artifacts.get(0);
            try (InputStream input = a.getInputStream();){
                Value value = session.getValueFactory().createValue(input);
                return value;
            }
        }

        public void detach() {
            for (Artifact a : this.artifacts) {
                if (!(a instanceof PropertyValueArtifact)) continue;
                try {
                    ((PropertyValueArtifact)a).detach();
                }
                catch (IOException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
            }
        }
    }
}

