/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.CompositePackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.JcrPackageRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Packaging.class}, immediate=true, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class PackagingImpl
implements Packaging {
    private static final Logger log = LoggerFactory.getLogger(PackagingImpl.class);
    @Reference
    private PackageEventDispatcher eventDispatcher;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    volatile List<PackageRegistry> registries;
    private final PackageManagerImpl pkgManager = new PackageManagerImpl();
    Config config;

    @Activate
    private void activate(Config config) {
        this.config = config;
        this.pkgManager.setDispatcher(this.eventDispatcher);
        log.info("Jackrabbit Filevault Packaging initialized with config {}", (Object)config);
    }

    @Override
    public PackageManager getPackageManager() {
        return this.pkgManager;
    }

    @Override
    public JcrPackageManager getPackageManager(Session session) {
        JcrPackageManagerImpl mgr = new JcrPackageManagerImpl(session, this.config.packageRoots(), this.config.authIdsForHookExecution(), this.config.authIdsForRootInstallation(), this.config.isStrict());
        mgr.setDispatcher(this.eventDispatcher);
        PackagingImpl.setBaseRegistry(mgr.getInternalRegistry(), this.registries);
        return mgr;
    }

    private static boolean setBaseRegistry(JcrPackageRegistry jcrPackageRegistry, List<PackageRegistry> otherRegistries) {
        if (!otherRegistries.isEmpty()) {
            jcrPackageRegistry.setBaseRegistry(otherRegistries.get(0));
            return true;
        }
        return false;
    }

    @Override
    public JcrPackageDefinition createPackageDefinition(Node defNode) {
        return new JcrPackageDefinitionImpl(defNode);
    }

    @Override
    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageManager pMgr = this.getPackageManager(node.getSession());
        return pMgr.open(node, allowInvalid);
    }

    @Override
    public PackageRegistry getCompositePackageRegistry(Session session, boolean useJcrRegistryAsPrimaryRegistry) throws IOException {
        ArrayList<PackageRegistry> allRegistries = new ArrayList<PackageRegistry>(this.registries);
        JcrPackageRegistry jcrPackageRegistry = this.getJcrPackageRegistry(session, false);
        if (useJcrRegistryAsPrimaryRegistry) {
            allRegistries.add(0, jcrPackageRegistry);
        } else {
            allRegistries.add(jcrPackageRegistry);
        }
        return new CompositePackageRegistry(allRegistries);
    }

    @Override
    public JcrPackageRegistry getJcrPackageRegistry(Session session) {
        return this.getJcrPackageRegistry(session, true);
    }

    private JcrPackageRegistry getJcrPackageRegistry(Session session, boolean useBaseRegistry) {
        JcrPackageRegistry registry = new JcrPackageRegistry(session, new AbstractPackageRegistry.SecurityConfig(this.config.authIdsForHookExecution(), this.config.authIdsForRootInstallation()), this.config.isStrict(), this.config.packageRoots());
        registry.setDispatcher(this.eventDispatcher);
        if (useBaseRegistry) {
            PackagingImpl.setBaseRegistry(registry, this.registries);
        }
        return registry;
    }

    @ObjectClassDefinition(name="Apache Jackrabbit FileVault Packaging Service (Package Manager Configuration)")
    static @interface Config {
        @AttributeDefinition(description="The locations in the repository which are used by the package manager")
        public String[] packageRoots() default {"/etc/packages"};

        @AttributeDefinition(description="The authorizable ids or principal names which are allowed to execute hooks (in addition to 'admin', 'administrators' and 'system'")
        public String[] authIdsForHookExecution();

        @AttributeDefinition(description="The authorizable ids or principal names which are allowed to install packages with the 'requireRoot' flag (in addition to 'admin', 'administrators' and 'system'")
        public String[] authIdsForRootInstallation();

        @AttributeDefinition(description="The default value for strict imports (i.e. whether it just logs certain errors or always throws exceptions")
        public boolean isStrict() default true;
    }
}

