/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AbstractExporter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.ExportPostProcessor;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.JcrWorkspaceFilter;
import org.apache.jackrabbit.vault.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageDefinitionImpl
implements JcrPackageDefinition {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageDefinitionImpl.class);
    @NotNull
    private Node defNode;
    @Nullable
    private String userId;

    public JcrPackageDefinitionImpl(@NotNull Node definitionNode) {
        this.defNode = definitionNode;
    }

    @Override
    @NotNull
    public Node getNode() {
        return this.defNode;
    }

    @Override
    public PackageId getId() {
        String group = this.get("group");
        String name = this.get("name");
        String version = this.get("version");
        if (group == null || name == null || name.length() == 0) {
            String path = this.getInstallationPath();
            if (path == null) {
                log.warn("Unable to calculate installation path. setting to 'unknown'");
                path = "unknown";
            }
            return new PackageId(path, version);
        }
        return new PackageId(group, name, version);
    }

    @Override
    public void setId(PackageId id, boolean autoSave) {
        this.set("group", id.getGroup(), false);
        this.set("name", id.getName(), false);
        this.set("version", id.getVersionString(), false);
    }

    private String getInstallationPath() {
        try {
            String ext;
            int idx;
            String path = this.get("path");
            if (path == null || path.length() == 0) {
                path = this.defNode.getParent().getParent().getPath();
            }
            if ((idx = path.lastIndexOf(46)) > 0 && (".zip".equalsIgnoreCase(ext = path.substring(idx)) || ".jar".equalsIgnoreCase(ext))) {
                path = path.substring(0, idx);
            }
            return path;
        }
        catch (RepositoryException e) {
            log.warn("Error during getInstallationPath()", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isUnwrapped() {
        try {
            return this.defNode.hasProperty("unwrapped") || this.defNode.hasProperty("lastUnwrapped");
        }
        catch (RepositoryException e) {
            log.warn("Error during isUnwrapped()", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isModified() {
        if (!this.isUnwrapped()) {
            return false;
        }
        Calendar mod = this.getLastModified();
        if (mod == null) {
            return false;
        }
        Calendar uw = this.getLastWrapped();
        if (uw == null) {
            uw = this.getLastUnwrapped();
        }
        if (uw == null) {
            try {
                if (this.defNode.hasProperty("unwrapped")) {
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.warn("Error while checking unwrapped property", (Throwable)e);
            }
            return false;
        }
        return mod.after(uw);
    }

    public void unwrap(VaultPackage pack, boolean force) throws RepositoryException, IOException {
        this.unwrap(pack, force, true);
    }

    @Override
    public void unwrap(VaultPackage pack, boolean force, boolean autoSave) throws RepositoryException, IOException {
        if (!force && this.isUnwrapped()) {
            return;
        }
        log.debug("unwrapping package {}", pack == null ? "(unknown)" : pack.getId());
        long now = System.currentTimeMillis();
        this.unwrap(pack == null ? null : pack.getArchive(), autoSave);
        if (log.isDebugEnabled()) {
            log.debug("unwrapping package {} completed in {}ms", (Object)this.getId(), (Object)(System.currentTimeMillis() - now));
        }
    }

    public void unwrap(Archive archive, boolean autoSave) throws RepositoryException, IOException {
        if (archive != null) {
            MetaInf inf = archive.getMetaInf();
            if (inf.hasDefinition()) {
                this.extractDefinition(archive);
            }
            if (inf.getFilter() != null) {
                JcrWorkspaceFilter.saveFilter(inf.getFilter(), this.defNode, false);
            }
            if (inf.getProperties() != null) {
                this.writeProperties(inf.getProperties());
            }
        }
        this.defNode.setProperty("unwrapped", (Value)null);
        this.defNode.setProperty("lastUnwrapped", Calendar.getInstance());
        if (autoSave) {
            this.defNode.getSession().save();
        }
    }

    private void extractDefinition(Archive packArchive) throws RepositoryException {
        Archive archive = null;
        try {
            archive = packArchive.getSubArchive("META-INF/vault/definition", true);
        }
        catch (IOException e) {
            log.error("Error while accessing sub archive", (Throwable)e);
        }
        if (archive == null) {
            log.warn("Unable to extract definition. No such entry in archive.");
            return;
        }
        Value lastUnpacked = null;
        if (this.defNode.hasProperty("lastUnpacked")) {
            lastUnpacked = this.defNode.getProperty("lastUnpacked").getValue();
        }
        Value lastUnpackedBy = null;
        if (this.defNode.hasProperty("lastUnpackedBy")) {
            lastUnpackedBy = this.defNode.getProperty("lastUnpackedBy").getValue();
        }
        Session session = this.defNode.getSession();
        String rootPath = this.defNode.getPath();
        DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
        filter.add(new PathFilterSet(rootPath));
        try {
            Importer importer = new Importer();
            importer.getOptions().setAutoSaveThreshold(Integer.MAX_VALUE);
            importer.getOptions().setFilter(filter);
            importer.run(archive, session, rootPath);
            this.defNode = session.getNode(rootPath);
            if (lastUnpacked != null) {
                this.defNode.setProperty("lastUnpacked", lastUnpacked);
            }
            if (lastUnpackedBy != null) {
                this.defNode.setProperty("lastUnpackedBy", lastUnpackedBy);
            }
        }
        catch (Exception e) {
            log.error("Unable to extract definition: {}", (Object)e.toString());
        }
    }

    @Override
    public Dependency[] getDependencies() {
        try {
            if (this.defNode.hasProperty("dependencies")) {
                Property p = this.defNode.getProperty("dependencies");
                LinkedList<Dependency> deps = new LinkedList<Dependency>();
                if (p.getDefinition().isMultiple()) {
                    for (Value v : p.getValues()) {
                        Dependency dep = Dependency.fromString(v.getString());
                        if (dep == null) continue;
                        deps.add(dep);
                    }
                } else {
                    Dependency dep = Dependency.fromString(p.getString());
                    if (dep != null) {
                        deps.add(dep);
                    }
                }
                return deps.toArray(new Dependency[deps.size()]);
            }
        }
        catch (RepositoryException e) {
            log.error("Error during getDependencies()", (Throwable)e);
        }
        return Dependency.EMPTY;
    }

    @Override
    public void setDependencies(@NotNull Dependency[] dependencies, boolean autoSave) {
        try {
            ArrayList<Value> values = new ArrayList<Value>(dependencies.length);
            ValueFactory fac = this.defNode.getSession().getValueFactory();
            for (Dependency d : dependencies) {
                if (d == null) continue;
                values.add(fac.createValue(d.toString()));
            }
            this.defNode.setProperty("dependencies", values.toArray(new Value[values.size()]));
            if (autoSave) {
                this.defNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during setDependencies()", (Throwable)e);
        }
    }

    private void loadProperties(Properties props) {
        PackageId id = this.getId();
        JcrPackageDefinitionImpl.setProperty(props, "version", id.getVersionString());
        JcrPackageDefinitionImpl.setProperty(props, "name", id.getName());
        JcrPackageDefinitionImpl.setProperty(props, "group", id.getGroup());
        JcrPackageDefinitionImpl.setProperty(props, "buildCount", this.get("buildCount"));
        JcrPackageDefinitionImpl.setProperty(props, "description", this.get("jcr:description"));
        JcrPackageDefinitionImpl.setProperty(props, "requiresRoot", this.get("requiresRoot"));
        JcrPackageDefinitionImpl.setProperty(props, "requiresRestart", this.get("requiresRestart"));
        JcrPackageDefinitionImpl.setProperty(props, "lastModified", this.getCalendar("jcr:lastModified"));
        JcrPackageDefinitionImpl.setProperty(props, "lastModifiedBy", this.get("jcr:lastModifiedBy"));
        JcrPackageDefinitionImpl.setProperty(props, "lastWrapped", this.getCalendar("lastWrapped"));
        JcrPackageDefinitionImpl.setProperty(props, "lastWrappedBy", this.get("lastWrappedBy"));
        JcrPackageDefinitionImpl.setProperty(props, "created", this.getCalendar("jcr:created"));
        JcrPackageDefinitionImpl.setProperty(props, "createdBy", this.get("jcr:createdBy"));
        JcrPackageDefinitionImpl.setProperty(props, "dependencies", Dependency.toString(this.getDependencies()));
        JcrPackageDefinitionImpl.setProperty(props, "acHandling", this.get("acHandling"));
        JcrPackageDefinitionImpl.setProperty(props, "cndPattern", this.get("cndPattern"));
    }

    private static void setProperty(Properties props, String name, String value) {
        if (value == null) {
            props.remove(name);
        } else {
            props.put(name, value);
        }
    }

    private static void setProperty(Properties props, String name, Calendar value) {
        if (value == null) {
            props.remove(name);
        } else {
            props.put(name, ISO8601.format((Calendar)value));
        }
    }

    private void writeProperties(Properties props) {
        try {
            if (props.getProperty("lastModified") != null && props.getProperty("lastModified").equals(props.getProperty("lastModifiedBy"))) {
                props = new Properties(props);
                props.setProperty("lastModifiedBy", "unknown");
            }
            this.defNode.setProperty("version", props.getProperty("version"));
            this.defNode.setProperty("buildCount", props.getProperty("buildCount"));
            this.defNode.setProperty("name", props.getProperty("name"));
            this.defNode.setProperty("group", props.getProperty("group"));
            String deps = props.getProperty("dependencies");
            if (this.defNode.hasProperty("dependencies")) {
                this.defNode.getProperty("dependencies").remove();
            }
            if (deps != null) {
                ArrayList<String> ds = new ArrayList<String>();
                for (Dependency d : Dependency.parse(deps)) {
                    if (d == null) continue;
                    ds.add(d.toString());
                }
                this.defNode.setProperty("dependencies", ds.toArray(new String[ds.size()]));
            }
            this.defNode.setProperty("jcr:description", props.getProperty("description"));
            this.defNode.setProperty("requiresRoot", Boolean.valueOf(props.getProperty("requiresRoot", "false")).booleanValue());
            this.defNode.setProperty("requiresRestart", Boolean.valueOf(props.getProperty("requiresRestart", "false")).booleanValue());
            this.defNode.setProperty("jcr:lastModified", JcrPackageDefinitionImpl.getDate(props.getProperty("lastModified")));
            this.defNode.setProperty("jcr:lastModifiedBy", props.getProperty("lastModifiedBy"));
            this.defNode.setProperty("jcr:created", JcrPackageDefinitionImpl.getDate(props.getProperty("created")));
            this.defNode.setProperty("jcr:createdBy", props.getProperty("createdBy"));
            this.defNode.setProperty("lastWrapped", JcrPackageDefinitionImpl.getDate(props.getProperty("lastWrapped")));
            this.defNode.setProperty("lastWrappedBy", props.getProperty("lastWrappedBy"));
            this.defNode.setProperty("acHandling", props.getProperty("acHandling"));
            this.defNode.setProperty("cndPattern", props.getProperty("cndPattern"));
            this.defNode.setProperty("noIntermediateSaves", props.getProperty("noIntermediateSaves"));
        }
        catch (RepositoryException e) {
            log.error("error while saving properties.", (Throwable)e);
        }
    }

    private static Calendar getDate(String iso) {
        if (iso == null) {
            return null;
        }
        String tzd = iso.substring(iso.length() - 4);
        if (tzd.indexOf(58) < 0) {
            iso = iso.substring(0, iso.length() - 4);
            iso = iso + tzd.substring(0, 2);
            iso = iso + ":";
            iso = iso + tzd.substring(2);
        }
        return ISO8601.parse((String)iso);
    }

    @Override
    public void dumpCoverage(ProgressTrackerListener listener) throws RepositoryException {
        WorkspaceFilter filter = this.getMetaInf().getFilter();
        if (filter != null) {
            filter.dumpCoverage(this.defNode.getSession(), listener, false);
        }
    }

    @Override
    public String get(String name) {
        try {
            if (this.defNode.hasProperty(name)) {
                return this.defNode.getProperty(name).getString();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during get({})", (Object)name, (Object)e);
        }
        return null;
    }

    @Override
    public boolean getBoolean(String name) {
        try {
            if (this.defNode.hasProperty(name)) {
                return this.defNode.getProperty(name).getBoolean();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during getBoolean({})", (Object)name, (Object)e);
        }
        return false;
    }

    @Override
    public Calendar getCalendar(String name) {
        try {
            if (this.defNode.hasProperty(name)) {
                return this.defNode.getProperty(name).getDate();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during getCalendar({})", (Object)name, (Object)e);
        }
        return null;
    }

    @Override
    public void set(String name, String value, boolean autoSave) {
        try {
            this.defNode.setProperty(name, value);
            this.touch(null, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during set({})", (Object)name, (Object)e);
        }
    }

    @Override
    public void set(String name, Calendar value, boolean autoSave) {
        try {
            this.defNode.setProperty(name, value);
            this.touch(null, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during set({})", (Object)name, (Object)e);
        }
    }

    @Override
    public void set(String name, boolean value, boolean autoSave) {
        try {
            this.defNode.setProperty(name, value);
            this.touch(null, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during set({})", (Object)name, (Object)e);
        }
    }

    @Override
    public void touch(Calendar now, boolean autoSave) {
        try {
            this.defNode.setProperty("jcr:lastModified", now == null ? Calendar.getInstance() : now);
            this.defNode.setProperty("jcr:lastModifiedBy", this.getUserId());
            if (autoSave) {
                this.defNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during touch()", (Throwable)e);
        }
    }

    @Override
    public void setFilter(WorkspaceFilter filter, boolean autoSave) {
        try {
            JcrWorkspaceFilter.saveFilter(filter, this.defNode, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error while saving filter.", (Throwable)e);
        }
    }

    void sealForAssembly(Calendar now) {
        try {
            if (now == null) {
                now = Calendar.getInstance();
            }
            this.defNode.setProperty("buildCount", String.valueOf(this.getBuildCount() + 1L));
            this.defNode.setProperty("jcr:created", now);
            this.defNode.setProperty("jcr:createdBy", this.getUserId());
            this.defNode.setProperty("lastWrapped", now);
            this.defNode.setProperty("lastWrappedBy", this.getUserId());
            this.defNode.setProperty("lastUnwrapped", now);
            this.defNode.setProperty("lastUnwrappedBy", this.getUserId());
            this.defNode.setProperty("unwrapped", (Value)null);
            this.touch(now, false);
            this.defNode.getSession().save();
        }
        catch (RepositoryException e) {
            log.error("Error during sealForAssembly()", (Throwable)e);
        }
    }

    void sealForRewrap(Calendar now) {
        try {
            if (now == null) {
                now = Calendar.getInstance();
            }
            this.defNode.setProperty("buildCount", String.valueOf(this.getBuildCount() + 1L));
            if (!this.defNode.hasProperty("jcr:created")) {
                this.defNode.setProperty("jcr:created", now);
                this.defNode.setProperty("jcr:createdBy", this.getUserId());
            }
            this.defNode.setProperty("lastWrapped", now);
            this.defNode.setProperty("lastWrappedBy", this.getUserId());
            this.defNode.setProperty("lastUnwrapped", now);
            this.defNode.setProperty("lastUnwrappedBy", this.getUserId());
            this.defNode.setProperty("unwrapped", (Value)null);
            this.touch(now, false);
            this.defNode.getSession().save();
        }
        catch (RepositoryException e) {
            log.error("Error during sealForRewrap()", (Throwable)e);
        }
    }

    void touchLastUnpacked() {
        try {
            this.defNode.setProperty("lastUnpacked", Calendar.getInstance());
            this.defNode.setProperty("lastUnpackedBy", this.getUserId());
            this.defNode.getSession().save();
        }
        catch (RepositoryException e) {
            log.error("Error during touchLastUnpacked()", (Throwable)e);
        }
    }

    void clearLastUnpacked(boolean autoSave) {
        try {
            if (this.defNode.hasProperty("lastUnpacked")) {
                this.defNode.getProperty("lastUnpacked").remove();
            }
            if (this.defNode.hasProperty("lastUnpackedBy")) {
                this.defNode.getProperty("lastUnpackedBy").remove();
            }
            if (autoSave) {
                this.defNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during clearLastUnpacked()", (Throwable)e);
        }
    }

    @Override
    public Calendar getLastModified() {
        return this.getCalendar("jcr:lastModified");
    }

    @Override
    public String getLastModifiedBy() {
        return this.get("jcr:lastModifiedBy");
    }

    @Override
    public Calendar getCreated() {
        return this.getCalendar("jcr:created");
    }

    @Override
    public String getCreatedBy() {
        return this.get("jcr:createdBy");
    }

    @Override
    public Calendar getLastUnwrapped() {
        return this.getCalendar("lastUnwrapped");
    }

    @Override
    public String getLastWrappedBy() {
        return this.get("lastWrappedBy");
    }

    @Override
    public Calendar getLastWrapped() {
        return this.getCalendar("lastWrapped");
    }

    @Override
    public String getLastUnwrappedBy() {
        return this.get("lastUnwrappedBy");
    }

    @Override
    public Calendar getLastUnpacked() {
        return this.getCalendar("lastUnpacked");
    }

    @Override
    public String getLastUnpackedBy() {
        return this.get("lastUnpackedBy");
    }

    @Override
    @Deprecated
    public boolean requiresRoot() {
        return this.getBoolean("requiresRoot");
    }

    @Override
    public boolean requiresRestart() {
        return this.getBoolean("requiresRestart");
    }

    @Override
    public AccessControlHandling getAccessControlHandling() {
        String acHandling = this.get("acHandling");
        try {
            return acHandling == null ? null : AccessControlHandling.valueOf(acHandling.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn("invalid access control handling in definition: {} of {}", (Object)acHandling, (Object)this.getId());
            return null;
        }
    }

    @Override
    public String getDescription() {
        return this.get("jcr:description");
    }

    @Override
    public long getBuildCount() {
        try {
            String bc = this.get("buildCount");
            return bc == null ? 0L : Long.valueOf(bc);
        }
        catch (NumberFormatException e) {
            log.warn("Wrong build count in {}.", (Object)this.getId(), (Object)e);
            return 0L;
        }
    }

    @Override
    public MetaInf getMetaInf() throws RepositoryException {
        DefaultMetaInf inf = new DefaultMetaInf();
        inf.setFilter(JcrWorkspaceFilter.loadFilter(this.defNode));
        Properties props = new Properties();
        this.loadProperties(props);
        inf.setProperties(props);
        return inf;
    }

    ExportPostProcessor getInjectProcessor() {
        return new InjectProcessor(this.defNode);
    }

    private String getUserId() {
        if (this.userId == null) {
            try {
                this.userId = this.defNode.getSession().getUserID();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (this.userId == null) {
                this.userId = "system";
            }
        }
        return this.userId;
    }

    List<PackageId> getSubPackages() throws RepositoryException {
        LinkedList<PackageId> subPackages = new LinkedList<PackageId>();
        if (this.defNode.hasProperty("subPackages")) {
            Value[] subIds;
            for (Value v : subIds = this.defNode.getProperty("subPackages").getValues()) {
                subPackages.add(PackageId.fromString(v.getString()));
            }
        }
        return subPackages;
    }

    void setSubPackages(Collection<PackageId> subPackageIds) throws RepositoryException {
        String[] subIds = new String[subPackageIds.size()];
        int i = 0;
        for (PackageId subId : subPackageIds) {
            subIds[i++] = subId.toString();
        }
        this.defNode.setProperty("subPackages", subIds);
    }

    public State getState() {
        return new State().load(this);
    }

    public void setState(State state) {
        state.save(this);
    }

    private static class InjectProcessor
    implements ExportPostProcessor {
        private final Node defNode;

        private InjectProcessor(Node defNode) {
            this.defNode = defNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(AbstractExporter exporter) {
            try {
                RepositoryAddress addr;
                if (this.defNode.hasProperty("lastUnpacked")) {
                    this.defNode.getProperty("lastUnpacked").remove();
                }
                if (this.defNode.hasProperty("lastUnpackedBy")) {
                    this.defNode.getProperty("lastUnpackedBy").remove();
                }
                String rootPath = this.defNode.getPath();
                DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                filter.add(new PathFilterSet(rootPath));
                try {
                    addr = new RepositoryAddress(Text.escapePath("/" + this.defNode.getSession().getWorkspace().getName() + rootPath));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                VaultFileSystem jcrfs = Mounter.mount(null, filter, addr, "/definition", this.defNode.getSession());
                exporter.setRelativePaths(true);
                exporter.setRootPath("");
                exporter.createDirectory("META-INF/vault/definition");
                exporter.export(jcrfs.getRoot(), "META-INF/vault/definition");
                jcrfs.unmount();
            }
            catch (Exception e) {
                log.error("Error during post processing", (Throwable)e);
            }
            finally {
                try {
                    this.defNode.getSession().refresh(false);
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }

    public static class State {
        private final String[] PROPERTY_NAMES = new String[]{"lastUnpacked", "lastUnwrapped", "jcr:lastModified", "lastWrapped", "lastUnpackedBy", "lastUnwrappedBy", "jcr:lastModifiedBy", "lastWrappedBy"};
        private final Value[] values = new Value[this.PROPERTY_NAMES.length];

        private State load(JcrPackageDefinitionImpl def) {
            for (int i = 0; i < this.PROPERTY_NAMES.length; ++i) {
                try {
                    if (def.defNode.hasProperty(this.PROPERTY_NAMES[i])) {
                        this.values[i] = def.defNode.getProperty(this.PROPERTY_NAMES[i]).getValue();
                        continue;
                    }
                    this.values[i] = null;
                    continue;
                }
                catch (RepositoryException e) {
                    log.error("Error while reading property {}: {}", (Object)this.PROPERTY_NAMES[i], (Object)e.toString());
                }
            }
            return this;
        }

        private void save(JcrPackageDefinitionImpl def) {
            for (int i = 0; i < this.PROPERTY_NAMES.length; ++i) {
                if (this.values[i] == null) continue;
                try {
                    def.defNode.setProperty(this.PROPERTY_NAMES[i], this.values[i]);
                    continue;
                }
                catch (RepositoryException e) {
                    log.error("Error while setting {}: {}", (Object)this.PROPERTY_NAMES[i], (Object)e.toString());
                }
            }
        }
    }
}

