/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.filter;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;

public class DefaultPathFilter
implements PathFilter {
    private Pattern regex;

    public DefaultPathFilter() {
    }

    public DefaultPathFilter(String pattern) throws ConfigurationException {
        this.setPattern(pattern);
    }

    public void setPattern(String pattern) throws ConfigurationException {
        try {
            this.regex = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException("Invalid pattern given: '" + pattern + "'", e);
        }
    }

    public String getPattern() {
        return this.regex.pattern();
    }

    @Override
    public boolean matches(String path) {
        return this.regex.matcher(path).matches();
    }

    @Override
    public boolean isAbsolute() {
        return this.regex.pattern().startsWith("/");
    }

    @Override
    public PathFilter translate(PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        String pattern = this.regex.pattern();
        if (!pattern.startsWith("/")) {
            return this;
        }
        try {
            return new DefaultPathFilter(mapping.map(pattern));
        }
        catch (ConfigurationException e) {
            return this;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPathFilter)) {
            return false;
        }
        DefaultPathFilter that = (DefaultPathFilter)o;
        return this.regex.toString().equals(that.regex.toString());
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    public String toString() {
        return "regex: " + this.regex.toString();
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", this.getClass().getSimpleName());
        ctx.indent(isLast);
        ctx.printf(true, "regex: %s", this.regex.toString());
        ctx.outdent();
    }
}

