/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.util.Calendar;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRegisteredPackage
implements RegisteredPackage {
    private static final Logger log = LoggerFactory.getLogger(FSPackageRegistry.class);
    private VaultPackage vltPkg;
    private FSPackageRegistry registry;

    public FSRegisteredPackage(FSPackageRegistry registry, VaultPackage vltPkg) throws IOException, RepositoryException {
        this.vltPkg = vltPkg;
        this.registry = registry;
    }

    @Override
    @Nonnull
    public PackageId getId() {
        return this.vltPkg.getId();
    }

    @Override
    @Nonnull
    public VaultPackage getPackage() throws IOException {
        return this.vltPkg;
    }

    @Override
    public boolean isInstalled() {
        try {
            return this.registry.isInstalled(this.getId());
        }
        catch (IOException e) {
            log.error("Packagestate couldn't be read for package {}", (Object)this.getId().toString(), (Object)e);
            return false;
        }
    }

    @Override
    public long getSize() {
        return this.vltPkg.getSize();
    }

    @Override
    @CheckForNull
    public Calendar getInstallationTime() {
        Calendar cal = Calendar.getInstance();
        try {
            Long installTime = this.registry.getInstallState(this.getId()).getInstallationTime();
            if (installTime == null) {
                cal = null;
            } else {
                cal.setTimeInMillis(installTime);
            }
        }
        catch (IOException e) {
            log.error("Could not read package state for package {}.", (Object)this.getId(), (Object)e);
            cal = null;
        }
        return cal;
    }

    @Override
    public void close() {
        this.vltPkg.close();
        this.vltPkg = null;
    }

    @Override
    public int compareTo(RegisteredPackage o) {
        return this.getId().compareTo(o.getId());
    }
}

