/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.JcrRegisteredPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTaskImpl
implements PackageTask {
    private static final Logger log = LoggerFactory.getLogger(PackageTaskImpl.class);
    static final PackageTaskImpl MARKER = new PackageTaskImpl(new PackageId("", "", ""), PackageTask.Type.INSTALL);
    private final PackageId id;
    private final PackageTask.Type type;
    private PackageTask.State state = PackageTask.State.NEW;
    private Throwable error;

    PackageTaskImpl(@Nonnull PackageId id, @Nonnull PackageTask.Type type) {
        this.id = id;
        this.type = type;
    }

    @Override
    @Nonnull
    public PackageId getPackageId() {
        return this.id;
    }

    @Override
    @Nonnull
    public PackageTask.Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public PackageTask.State getState() {
        return this.state;
    }

    @Override
    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return "PackageTaskImpl{id=" + this.id + ", type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + '}';
    }

    void execute(ExecutionPlanImpl executionPlan) {
        if (this.state != PackageTask.State.NEW) {
            return;
        }
        this.state = PackageTask.State.RUNNING;
        try {
            switch (this.type) {
                case INSTALL: {
                    this.doInstall(executionPlan, false);
                    break;
                }
                case UNINSTALL: {
                    this.doUninstall(executionPlan);
                    break;
                }
                case REMOVE: {
                    this.doRemove(executionPlan);
                    break;
                }
                case EXTRACT: {
                    this.doInstall(executionPlan, true);
                }
            }
            this.state = PackageTask.State.COMPLETED;
        }
        catch (Exception e) {
            log.info("error during package task {} on {}: {}", new Object[]{this.type, this.id, e.toString()});
            this.error = e;
            this.state = PackageTask.State.ERROR;
        }
    }

    private void doRemove(ExecutionPlanImpl plan) throws IOException, PackageException {
        try (RegisteredPackage pkg = plan.getRegistry().open(this.id);){
            if (pkg == null) {
                throw new NoSuchPackageException("No such package: " + this.id);
            }
            if (pkg.isInstalled()) {
                throw new PackageException("refusing to remove installed package: " + this.id);
            }
            plan.getRegistry().remove(this.id);
        }
    }

    private void doUninstall(ExecutionPlanImpl plan) throws IOException, PackageException {
        ImportOptions opts = new ImportOptions();
        opts.setListener(plan.getListener());
        opts.setDependencyHandling(DependencyHandling.STRICT);
        try (RegisteredPackage pkg = plan.getRegistry().open(this.id);){
            if (pkg == null) {
                throw new NoSuchPackageException("No such package: " + this.id);
            }
            if (!(pkg instanceof JcrRegisteredPackage)) {
                throw new PackageException("non jcr packages not supported yet");
            }
            try (JcrPackage jcrPkg = ((JcrRegisteredPackage)pkg).getJcrPackage();){
                jcrPkg.uninstall(opts);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }

    private void doInstall(ExecutionPlanImpl plan, boolean extract) throws IOException, PackageException {
        ImportOptions opts = new ImportOptions();
        opts.setListener(plan.getListener());
        opts.setDependencyHandling(DependencyHandling.STRICT);
        try (RegisteredPackage pkg = plan.getRegistry().open(this.id);){
            if (pkg == null) {
                throw new NoSuchPackageException("No such package: " + this.id);
            }
            if (!(pkg instanceof JcrRegisteredPackage)) {
                throw new PackageException("non jcr packages not supported yet");
            }
            try (JcrPackage jcrPkg = ((JcrRegisteredPackage)pkg).getJcrPackage();){
                if (extract) {
                    jcrPkg.extract(opts);
                } else {
                    jcrPkg.install(opts);
                }
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }
}

